/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.report;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.TimeUnit;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.BaseResult;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.report.MessageStatus;
import cn.jpush.api.report.MessagesResult;
import cn.jpush.api.report.ReceivedsResult;
import cn.jpush.api.report.UsersResult;
import cn.jpush.api.report.model.CheckMessagePayload;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Pattern;

public class ReportClient {
    private final NativeHttpClient _httpClient;
    private String _hostName;
    private String _receivePath;
    private String _userPath;
    private String _messagePath;
    private static final Pattern MSGID_PATTERNS = Pattern.compile("[^0-9, ]");

    public ReportClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    @Deprecated
    public ReportClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    @Deprecated
    public ReportClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        ClientConfig conf = ClientConfig.getInstance();
        conf.setMaxRetryTimes(maxRetryTimes);
        this._hostName = (String)conf.get((Object)"report.host.name");
        this._receivePath = (String)conf.get((Object)"report.receive.path");
        this._userPath = (String)conf.get((Object)"report.user.path");
        this._messagePath = (String)conf.get((Object)"report.message.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public ReportClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        this._hostName = (String)conf.get((Object)"report.host.name");
        this._receivePath = (String)conf.get((Object)"report.receive.path");
        this._userPath = (String)conf.get((Object)"report.user.path");
        this._messagePath = (String)conf.get((Object)"report.message.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public ReceivedsResult getReceiveds(String[] msgIdArray) throws APIConnectionException, APIRequestException {
        return this.getReceiveds(StringUtils.arrayToString((String[])msgIdArray));
    }

    public ReceivedsResult getReceiveds(String msgIds) throws APIConnectionException, APIRequestException {
        ReportClient.checkMsgids(msgIds);
        String url = this._hostName + this._receivePath + "?msg_ids=" + msgIds;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return ReceivedsResult.fromResponse(response);
    }

    public MessagesResult getMessages(String msgIds) throws APIConnectionException, APIRequestException {
        ReportClient.checkMsgids(msgIds);
        String url = this._hostName + this._messagePath + "?msg_ids=" + msgIds;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return MessagesResult.fromResponse(response);
    }

    public Map<String, MessageStatus> getMessagesStatus(CheckMessagePayload payload) throws APIConnectionException, APIRequestException {
        String url = this._hostName + "/v3/status/message";
        ResponseWrapper result = this._httpClient.sendPost(url, payload.toString());
        Type type = new TypeToken<Map<String, MessageStatus>>(){}.getType();
        return (Map)new Gson().fromJson(result.responseContent, type);
    }

    public UsersResult getUsers(TimeUnit timeUnit, String start, int duration) throws APIConnectionException, APIRequestException {
        String startEncoded = null;
        try {
            startEncoded = URLEncoder.encode(start, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String url = this._hostName + this._userPath + "?time_unit=" + timeUnit.toString() + "&start=" + startEncoded + "&duration=" + duration;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return (UsersResult)BaseResult.fromResponse((ResponseWrapper)response, UsersResult.class);
    }

    public static void checkMsgids(String msgIds) {
        if (StringUtils.isTrimedEmpty((String)msgIds)) {
            throw new IllegalArgumentException("msgIds param is required.");
        }
        if (MSGID_PATTERNS.matcher(msgIds).find()) {
            throw new IllegalArgumentException("msgIds param format is incorrect. It should be msg_id (number) which response from JPush Push API. If there are many, use ',' as interval. ");
        }
        if ((msgIds = msgIds.trim()).endsWith(",")) {
            msgIds = msgIds.substring(0, msgIds.length() - 1);
        }
        String[] splits = msgIds.split(",");
        try {
            for (String s : splits) {
                if (StringUtils.isEmpty((String)(s = s.trim()))) continue;
                Long.parseLong(s);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Every msg_id should be valid Long number which splits by ','");
        }
    }
}

