/*
 * Decompiled with CFR 0.152.
 */
package cn.jzvd;

import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import cn.jzvd.JZResizeTextureView;
import cn.jzvd.JZVideoPlayerManager;
import java.lang.reflect.Method;
import java.util.Map;

public class JZMediaManager
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnVideoSizeChangedListener {
    public static final int HANDLER_PREPARE = 0;
    public static final int HANDLER_RELEASE = 2;
    public static final String TAG = "JiaoZiVideoPlayer";
    public static JZResizeTextureView textureView;
    public static SurfaceTexture savedSurfaceTexture;
    public static String CURRENT_PLAYING_URL;
    public static boolean CURRENT_PLING_LOOP;
    public static Map<String, String> MAP_HEADER_DATA;
    private static JZMediaManager JZMediaManager;
    public MediaPlayer mediaPlayer = new MediaPlayer();
    public int currentVideoWidth = 0;
    public int currentVideoHeight = 0;
    HandlerThread mMediaHandlerThread = new HandlerThread("JiaoZiVideoPlayer");
    MediaHandler mMediaHandler;
    Handler mainThreadHandler;

    public JZMediaManager() {
        this.mMediaHandlerThread.start();
        this.mMediaHandler = new MediaHandler(this.mMediaHandlerThread.getLooper());
        this.mainThreadHandler = new Handler();
    }

    public static JZMediaManager instance() {
        if (JZMediaManager == null) {
            JZMediaManager = new JZMediaManager();
        }
        return JZMediaManager;
    }

    public Point getVideoSize() {
        if (this.currentVideoWidth != 0 && this.currentVideoHeight != 0) {
            return new Point(this.currentVideoWidth, this.currentVideoHeight);
        }
        return null;
    }

    public void prepare() {
        this.releaseMediaPlayer();
        Message msg = new Message();
        msg.what = 0;
        this.mMediaHandler.sendMessage(msg);
    }

    public void releaseMediaPlayer() {
        Message msg = new Message();
        msg.what = 2;
        this.mMediaHandler.sendMessage(msg);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int i, int i1) {
        Log.i((String)TAG, (String)("onSurfaceTextureAvailable [" + ((Object)((Object)JZVideoPlayerManager.getCurrentJzvd())).hashCode() + "] "));
        if (savedSurfaceTexture == null) {
            savedSurfaceTexture = surfaceTexture;
            this.prepare();
        } else {
            textureView.setSurfaceTexture(savedSurfaceTexture);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int i, int i1) {
        Log.i((String)TAG, (String)("onSurfaceTextureSizeChanged [" + ((Object)((Object)JZVideoPlayerManager.getCurrentJzvd())).hashCode() + "] "));
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return savedSurfaceTexture == null;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public void onPrepared(MediaPlayer mp) {
        this.mediaPlayer.start();
    }

    public void onCompletion(MediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onAutoCompletion();
                }
            }
        });
    }

    public void onBufferingUpdate(MediaPlayer mp, final int percent) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().setBufferProgress(percent);
                }
            }
        });
    }

    public void onSeekComplete(MediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onSeekComplete();
                }
            }
        });
    }

    public boolean onError(MediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onError(what, extra);
                }
            }
        });
        return true;
    }

    public boolean onInfo(MediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onInfo(what, extra);
                }
            }
        });
        return false;
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        this.currentVideoWidth = width;
        this.currentVideoHeight = height;
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().onVideoSizeChanged();
                }
            }
        });
    }

    public class MediaHandler
    extends Handler {
        public MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    try {
                        JZMediaManager.this.currentVideoWidth = 0;
                        JZMediaManager.this.currentVideoHeight = 0;
                        JZMediaManager.this.mediaPlayer.release();
                        JZMediaManager.this.mediaPlayer = new MediaPlayer();
                        JZMediaManager.this.mediaPlayer.setAudioStreamType(3);
                        JZMediaManager.this.mediaPlayer.setLooping(CURRENT_PLING_LOOP);
                        JZMediaManager.this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)JZMediaManager.this);
                        JZMediaManager.this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)JZMediaManager.this);
                        JZMediaManager.this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)JZMediaManager.this);
                        JZMediaManager.this.mediaPlayer.setScreenOnWhilePlaying(true);
                        JZMediaManager.this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)JZMediaManager.this);
                        JZMediaManager.this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)JZMediaManager.this);
                        JZMediaManager.this.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)JZMediaManager.this);
                        JZMediaManager.this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)JZMediaManager.this);
                        Class<MediaPlayer> clazz = MediaPlayer.class;
                        Method method = clazz.getDeclaredMethod("setDataSource", String.class, Map.class);
                        method.invoke((Object)JZMediaManager.this.mediaPlayer, CURRENT_PLAYING_URL, MAP_HEADER_DATA);
                        JZMediaManager.this.mediaPlayer.prepareAsync();
                        JZMediaManager.this.mediaPlayer.setSurface(new Surface(savedSurfaceTexture));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    JZMediaManager.this.mediaPlayer.release();
                }
            }
        }
    }
}

