/*
 * Decompiled with CFR 0.152.
 */
package cn.jzvd;

import android.content.ContentResolver;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.media.AudioManager;
import android.os.Handler;
import android.provider.Settings;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import cn.jzvd.JZMediaManager;
import cn.jzvd.JZResizeTextureView;
import cn.jzvd.JZUserAction;
import cn.jzvd.JZUtils;
import cn.jzvd.JZVideoPlayerManager;
import cn.jzvd.R;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class JZVideoPlayer
extends FrameLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
View.OnTouchListener {
    public static final String TAG = "JiaoZiVideoPlayer";
    public static final int FULLSCREEN_ID = 33797;
    public static final int TINY_ID = 33798;
    public static final int THRESHOLD = 80;
    public static final int FULL_SCREEN_NORMAL_DELAY = 300;
    public static final int SCREEN_LAYOUT_NORMAL = 0;
    public static final int SCREEN_LAYOUT_LIST = 1;
    public static final int SCREEN_WINDOW_FULLSCREEN = 2;
    public static final int SCREEN_WINDOW_TINY = 3;
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPARING = 1;
    public static final int CURRENT_STATE_PREPARING_CHANGING_URL = 2;
    public static final int CURRENT_STATE_PLAYING = 3;
    public static final int CURRENT_STATE_PLAYING_BUFFERING_START = 4;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    public static final String URL_KEY_DEFAULT = "URL_KEY_DEFAULT";
    public static boolean ACTION_BAR_EXIST = true;
    public static boolean TOOL_BAR_EXIST = true;
    public static int FULLSCREEN_ORIENTATION = 4;
    public static int NORMAL_ORIENTATION = 1;
    public static boolean SAVE_PROGRESS = true;
    public static boolean WIFI_TIP_DIALOG_SHOWED = false;
    public static long CLICK_QUIT_FULLSCREEN_TIME = 0L;
    public static int BACKUP_PLAYING_BUFFERING_STATE = -1;
    public static long lastAutoFullscreenTime = 0L;
    public static AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    break;
                }
                case -1: {
                    JZVideoPlayer.releaseAllVideos();
                    Log.d((String)JZVideoPlayer.TAG, (String)("AUDIOFOCUS_LOSS [" + this.hashCode() + "]"));
                    break;
                }
                case -2: {
                    try {
                        if (JZMediaManager.instance().mediaPlayer != null && JZMediaManager.instance().mediaPlayer.isPlaying()) {
                            JZMediaManager.instance().mediaPlayer.pause();
                        }
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)JZVideoPlayer.TAG, (String)("AUDIOFOCUS_LOSS_TRANSIENT [" + this.hashCode() + "]"));
                    break;
                }
            }
        }
    };
    protected static JZUserAction JZ_USER_EVENT;
    protected static Timer UPDATE_PROGRESS_TIMER;
    public int currentState = -1;
    public int currentScreen = -1;
    public boolean loop = false;
    public Map<String, String> headData;
    public Object[] objects = null;
    public int seekToInAdvance = 0;
    public ImageView startButton;
    public SeekBar progressBar;
    public ImageView fullscreenButton;
    public TextView currentTimeTextView;
    public TextView totalTimeTextView;
    public ViewGroup textureViewContainer;
    public ViewGroup topContainer;
    public ViewGroup bottomContainer;
    public int widthRatio = 0;
    public int heightRatio = 0;
    protected boolean isVideoRendingStart = false;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected AudioManager mAudioManager;
    protected Handler mHandler;
    protected ProgressTimerTask mProgressTimerTask;
    protected boolean mTouchingProgressBar;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeVolume;
    protected boolean mChangePosition;
    protected boolean mChangeBrightness;
    protected int mGestureDownPosition;
    protected int mGestureDownVolume;
    protected float mGestureDownBrightness;
    protected int mSeekTimePosition;
    LinkedHashMap urlMap;
    int currentUrlMapIndex = 0;

    public JZVideoPlayer(Context context) {
        super(context);
        this.init(context);
    }

    public JZVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public static void releaseAllVideos() {
        if (System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME > 300L) {
            Log.d((String)TAG, (String)"releaseAllVideos");
            JZVideoPlayerManager.completeAll();
            JZMediaManager.instance().releaseMediaPlayer();
        }
    }

    public static void startFullscreen(Context context, Class _class, String url, Object ... objects) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(URL_KEY_DEFAULT, url);
        JZVideoPlayer.startFullscreen(context, _class, map, 0, objects);
    }

    public static void startFullscreen(Context context, Class _class, LinkedHashMap urlMap, int defaultUrlMapIndex, Object ... objects) {
        JZVideoPlayer.hideSupportActionBar(context);
        JZUtils.getAppCompActivity(context).setRequestedOrientation(FULLSCREEN_ORIENTATION);
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(context).findViewById(0x1020002);
        View old = vp.findViewById(33797);
        if (old != null) {
            vp.removeView(old);
        }
        try {
            Constructor constructor = _class.getConstructor(Context.class);
            JZVideoPlayer jzVideoPlayer = (JZVideoPlayer)((Object)constructor.newInstance(context));
            jzVideoPlayer.setId(33797);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            vp.addView((View)jzVideoPlayer, (ViewGroup.LayoutParams)lp);
            jzVideoPlayer.setUp(urlMap, defaultUrlMapIndex, 2, objects);
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            jzVideoPlayer.startButton.performClick();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean backPress() {
        Log.i((String)TAG, (String)"backPress");
        if (System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 300L) {
            return false;
        }
        if (JZVideoPlayerManager.getSecondFloor() != null) {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            JZVideoPlayer jzVideoPlayer = JZVideoPlayerManager.getSecondFloor();
            jzVideoPlayer.onEvent(jzVideoPlayer.currentScreen == 2 ? 8 : 10);
            JZVideoPlayerManager.getFirstFloor().playOnThisJzvd();
            return true;
        }
        if (JZVideoPlayerManager.getFirstFloor() != null && (JZVideoPlayerManager.getFirstFloor().currentScreen == 2 || JZVideoPlayerManager.getFirstFloor().currentScreen == 3)) {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            JZVideoPlayerManager.getCurrentJzvd().currentState = 0;
            JZVideoPlayerManager.getFirstFloor().clearFloatScreen();
            JZMediaManager.instance().releaseMediaPlayer();
            JZVideoPlayerManager.setFirstFloor(null);
            return true;
        }
        return false;
    }

    public static void showSupportActionBar(Context context) {
        ActionBar ab;
        if (ACTION_BAR_EXIST && (ab = JZUtils.getAppCompActivity(context).getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
        if (TOOL_BAR_EXIST) {
            JZUtils.getAppCompActivity(context).getWindow().clearFlags(1024);
        }
    }

    public static void hideSupportActionBar(Context context) {
        ActionBar ab;
        if (ACTION_BAR_EXIST && (ab = JZUtils.getAppCompActivity(context).getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.hide();
        }
        if (TOOL_BAR_EXIST) {
            JZUtils.getAppCompActivity(context).getWindow().setFlags(1024, 1024);
        }
    }

    public static void clearSavedProgress(Context context, String url) {
        JZUtils.clearSavedProgress(context, url);
    }

    public static void setJzUserAction(JZUserAction jzUserEvent) {
        JZ_USER_EVENT = jzUserEvent;
    }

    public abstract int getLayoutId();

    public void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.startButton = (ImageView)this.findViewById(R.id.start);
        this.fullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.progressBar = (SeekBar)this.findViewById(R.id.bottom_seek_progress);
        this.currentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.totalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.bottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.textureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        this.topContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.startButton.setOnClickListener((View.OnClickListener)this);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.bottomContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.mScreenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mHandler = new Handler();
        try {
            if (this.isCurrentJzvd()) {
                NORMAL_ORIENTATION = ((AppCompatActivity)context).getRequestedOrientation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUp(String url, int screen, Object ... objects) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(URL_KEY_DEFAULT, url);
        this.setUp(map, 0, screen, objects);
    }

    public void setUp(LinkedHashMap urlMap, int defaultUrlMapIndex, int screen, Object ... objects) {
        if (this.urlMap != null && !TextUtils.isEmpty((CharSequence)JZUtils.getCurrentUrlFromMap(urlMap, this.currentUrlMapIndex)) && TextUtils.equals((CharSequence)JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex), (CharSequence)JZUtils.getCurrentUrlFromMap(urlMap, this.currentUrlMapIndex))) {
            return;
        }
        this.urlMap = urlMap;
        this.currentUrlMapIndex = defaultUrlMapIndex;
        this.currentScreen = screen;
        this.objects = objects;
        this.headData = null;
        this.isVideoRendingStart = false;
        this.onStateNormal();
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            Log.i((String)TAG, (String)("onClick start [" + ((Object)((Object)this)).hashCode() + "] "));
            if (this.urlMap == null || TextUtils.isEmpty((CharSequence)JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex))) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.currentState == 0 || this.currentState == 7) {
                if (!(JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex).startsWith("file") || JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex).startsWith("/") || JZUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                    this.showWifiDialog(0);
                    return;
                }
                this.startVideo();
                this.onEvent(this.currentState != 7 ? 0 : 1);
            } else if (this.currentState == 3) {
                this.onEvent(3);
                Log.d((String)TAG, (String)("pauseVideo [" + ((Object)((Object)this)).hashCode() + "] "));
                JZMediaManager.instance().mediaPlayer.pause();
                this.onStatePause();
            } else if (this.currentState == 5) {
                this.onEvent(4);
                JZMediaManager.instance().mediaPlayer.start();
                this.onStatePlaying();
            } else if (this.currentState == 6) {
                this.onEvent(2);
                this.startVideo();
            }
        } else if (i == R.id.fullscreen) {
            Log.i((String)TAG, (String)("onClick fullscreen [" + ((Object)((Object)this)).hashCode() + "] "));
            if (this.currentState == 6) {
                return;
            }
            if (this.currentScreen == 2) {
                JZVideoPlayer.backPress();
            } else {
                Log.d((String)TAG, (String)("toFullscreenActivity [" + ((Object)((Object)this)).hashCode() + "] "));
                this.onEvent(7);
                this.startWindowFullscreen();
            }
        } else if (i == R.id.surface_container && this.currentState == 7) {
            Log.i((String)TAG, (String)("onClick surfaceContainer State=Error [" + ((Object)((Object)this)).hashCode() + "] "));
            this.startVideo();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionDown [" + ((Object)((Object)this)).hashCode() + "] "));
                    this.mTouchingProgressBar = true;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mChangeVolume = false;
                    this.mChangePosition = false;
                    this.mChangeBrightness = false;
                    break;
                }
                case 2: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionMove [" + ((Object)((Object)this)).hashCode() + "] "));
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if (!(this.currentScreen != 2 || this.mChangePosition || this.mChangeVolume || this.mChangeBrightness || !(absDeltaX > 80.0f) && !(absDeltaY > 80.0f))) {
                        this.cancelProgressTimer();
                        if (absDeltaX >= 80.0f) {
                            if (this.currentState != 7) {
                                this.mChangePosition = true;
                                this.mGestureDownPosition = this.getCurrentPositionWhenPlaying();
                            }
                        } else if (this.mDownX < (float)this.mScreenWidth * 0.5f) {
                            this.mChangeBrightness = true;
                            WindowManager.LayoutParams lp = JZUtils.getAppCompActivity(this.getContext()).getWindow().getAttributes();
                            if (lp.screenBrightness < 0.0f) {
                                try {
                                    this.mGestureDownBrightness = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness");
                                    Log.i((String)TAG, (String)("current system brightness: " + this.mGestureDownBrightness));
                                }
                                catch (Settings.SettingNotFoundException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                this.mGestureDownBrightness = lp.screenBrightness * 255.0f;
                                Log.i((String)TAG, (String)("current activity brightness: " + this.mGestureDownBrightness));
                            }
                        } else {
                            this.mChangeVolume = true;
                            this.mGestureDownVolume = this.mAudioManager.getStreamVolume(3);
                        }
                    }
                    if (this.mChangePosition) {
                        int totalTimeDuration = this.getDuration();
                        this.mSeekTimePosition = (int)((float)this.mGestureDownPosition + deltaX * (float)totalTimeDuration / (float)this.mScreenWidth);
                        if (this.mSeekTimePosition > totalTimeDuration) {
                            this.mSeekTimePosition = totalTimeDuration;
                        }
                        String seekTime = JZUtils.stringForTime(this.mSeekTimePosition);
                        String totalTime = JZUtils.stringForTime(totalTimeDuration);
                        this.showProgressDialog(deltaX, seekTime, this.mSeekTimePosition, totalTime, totalTimeDuration);
                    }
                    if (this.mChangeVolume) {
                        deltaY = -deltaY;
                        int max = this.mAudioManager.getStreamMaxVolume(3);
                        int deltaV = (int)((float)max * deltaY * 3.0f / (float)this.mScreenHeight);
                        this.mAudioManager.setStreamVolume(3, this.mGestureDownVolume + deltaV, 0);
                        int volumePercent = (int)((float)(this.mGestureDownVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                        this.showVolumeDialog(-deltaY, volumePercent);
                    }
                    if (!this.mChangeBrightness) break;
                    deltaY = -deltaY;
                    int deltaV = (int)(255.0f * deltaY * 3.0f / (float)this.mScreenHeight);
                    WindowManager.LayoutParams params = JZUtils.getAppCompActivity(this.getContext()).getWindow().getAttributes();
                    params.screenBrightness = (this.mGestureDownBrightness + (float)deltaV) / 255.0f >= 1.0f ? 1.0f : ((this.mGestureDownBrightness + (float)deltaV) / 255.0f <= 0.0f ? 0.01f : (this.mGestureDownBrightness + (float)deltaV) / 255.0f);
                    JZUtils.getAppCompActivity(this.getContext()).getWindow().setAttributes(params);
                    int brightnessPercent = (int)(this.mGestureDownBrightness * 100.0f / 255.0f + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                    this.showBrightnessDialog(brightnessPercent);
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionUp [" + ((Object)((Object)this)).hashCode() + "] "));
                    this.mTouchingProgressBar = false;
                    this.dismissProgressDialog();
                    this.dismissVolumeDialog();
                    this.dismissBrightnessDialog();
                    if (this.mChangePosition) {
                        this.onEvent(12);
                        JZMediaManager.instance().mediaPlayer.seekTo(this.mSeekTimePosition);
                        int duration = this.getDuration();
                        int progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.progressBar.setProgress(progress);
                    }
                    if (this.mChangeVolume) {
                        this.onEvent(11);
                    }
                    this.startProgressTimer();
                }
            }
        }
        return false;
    }

    public void startVideo() {
        JZVideoPlayerManager.completeAll();
        Log.d((String)TAG, (String)("startVideo [" + ((Object)((Object)this)).hashCode() + "] "));
        this.initTextureView();
        this.addTextureView();
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.requestAudioFocus(onAudioFocusChangeListener, 3, 2);
        JZUtils.scanForActivity(this.getContext()).getWindow().addFlags(128);
        JZMediaManager.CURRENT_PLAYING_URL = JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex);
        JZMediaManager.CURRENT_PLING_LOOP = this.loop;
        JZMediaManager.MAP_HEADER_DATA = this.headData;
        this.onStatePreparing();
        JZVideoPlayerManager.setFirstFloor(this);
    }

    public void onVideoRendingStart() {
        Log.i((String)TAG, (String)("onVideoRendingStart  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.isVideoRendingStart = true;
        if (this.currentState != 1 && this.currentState != 2 && this.currentState != 4) {
            return;
        }
        if (this.seekToInAdvance != 0) {
            JZMediaManager.instance().mediaPlayer.seekTo(this.seekToInAdvance);
            this.seekToInAdvance = 0;
        } else {
            int position = JZUtils.getSavedProgress(this.getContext(), JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex));
            if (position != 0) {
                JZMediaManager.instance().mediaPlayer.seekTo(position);
            }
        }
        this.startProgressTimer();
        this.onStatePlaying();
    }

    public void setState(int state) {
        this.setState(state, 0, 0);
    }

    public void setState(int state, int urlMapIndex, int seekToInAdvance) {
        switch (state) {
            case 0: {
                this.onStateNormal();
                break;
            }
            case 1: {
                this.onStatePreparing();
                break;
            }
            case 2: {
                this.onStatePreparingChangingUrl(urlMapIndex, seekToInAdvance);
                break;
            }
            case 3: {
                this.onStatePlaying();
                break;
            }
            case 5: {
                this.onStatePause();
                break;
            }
            case 4: {
                this.onStatePlaybackBufferingStart();
                break;
            }
            case 7: {
                this.onStateError();
                break;
            }
            case 6: {
                this.onStateAutoComplete();
            }
        }
    }

    public void onStateNormal() {
        Log.i((String)TAG, (String)("onStateNormal  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 0;
        this.cancelProgressTimer();
        if (this.isCurrentJzvd()) {
            JZMediaManager.instance().releaseMediaPlayer();
        }
    }

    public void onStatePreparing() {
        Log.i((String)TAG, (String)("onStatePreparing  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 1;
        this.resetProgressAndTime();
    }

    public void onStatePreparingChangingUrl(int urlMapIndex, int seekToInAdvance) {
        this.currentState = 2;
        this.currentUrlMapIndex = urlMapIndex;
        this.seekToInAdvance = seekToInAdvance;
        JZMediaManager.CURRENT_PLAYING_URL = JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex);
        JZMediaManager.CURRENT_PLING_LOOP = this.loop;
        JZMediaManager.MAP_HEADER_DATA = this.headData;
        JZMediaManager.instance().prepare();
    }

    public void onStatePlaying() {
        Log.i((String)TAG, (String)("onStatePlaying  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 3;
        this.startProgressTimer();
    }

    public void onStatePause() {
        Log.i((String)TAG, (String)("onStatePause  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 5;
        this.startProgressTimer();
    }

    public void onStatePlaybackBufferingStart() {
        Log.i((String)TAG, (String)("onStatePlaybackBufferingStart  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 4;
        this.startProgressTimer();
    }

    public void onStateError() {
        Log.i((String)TAG, (String)("onStateError  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 7;
        this.cancelProgressTimer();
    }

    public void onStateAutoComplete() {
        Log.i((String)TAG, (String)("onStateAutoComplete  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 6;
        this.cancelProgressTimer();
        this.progressBar.setProgress(100);
        this.currentTimeTextView.setText(this.totalTimeTextView.getText());
    }

    public void onInfo(int what, int extra) {
        Log.d((String)TAG, (String)("onInfo what - " + what + " extra - " + extra));
        if (what == 701) {
            if (this.currentState == 4) {
                return;
            }
            BACKUP_PLAYING_BUFFERING_STATE = this.currentState;
            this.onStatePlaybackBufferingStart();
            Log.d((String)TAG, (String)"MEDIA_INFO_BUFFERING_START");
        } else if (what == 702) {
            if (BACKUP_PLAYING_BUFFERING_STATE != -1) {
                if (this.currentState == 4) {
                    this.setState(BACKUP_PLAYING_BUFFERING_STATE);
                }
                BACKUP_PLAYING_BUFFERING_STATE = -1;
            }
            Log.d((String)TAG, (String)"MEDIA_INFO_BUFFERING_END");
        } else if (what == 3) {
            this.onVideoRendingStart();
        }
    }

    public void onError(int what, int extra) {
        Log.e((String)TAG, (String)("onError " + what + " - " + extra + " [" + ((Object)((Object)this)).hashCode() + "] "));
        if (what != 38 && what != -38 && extra != -38) {
            this.onStateError();
            if (this.isCurrentJzvd()) {
                JZMediaManager.instance().releaseMediaPlayer();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.currentScreen == 2 || this.currentScreen == 3) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (this.widthRatio != 0 && this.heightRatio != 0) {
            int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int specHeight = (int)((float)specWidth * (float)this.heightRatio / (float)this.widthRatio);
            this.setMeasuredDimension(specWidth, specHeight);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)specWidth, (int)0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)specHeight, (int)0x40000000);
            this.getChildAt(0).measure(childWidthMeasureSpec, childHeightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void onAutoCompletion() {
        Runtime.getRuntime().gc();
        Log.i((String)TAG, (String)("onAutoCompletion  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(6);
        this.dismissVolumeDialog();
        this.dismissProgressDialog();
        this.dismissBrightnessDialog();
        this.cancelProgressTimer();
        this.onStateAutoComplete();
        if (this.currentScreen == 2) {
            JZVideoPlayer.backPress();
        }
        JZUtils.saveProgress(this.getContext(), JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex), 0);
    }

    public void onCompletion() {
        Log.i((String)TAG, (String)("onCompletion  [" + ((Object)((Object)this)).hashCode() + "] "));
        if (this.currentState == 3 || this.currentState == 5) {
            int position = this.getCurrentPositionWhenPlaying();
            JZUtils.saveProgress(this.getContext(), JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex), position);
        }
        this.cancelProgressTimer();
        this.onStateNormal();
        this.textureViewContainer.removeView((View)JZMediaManager.textureView);
        JZMediaManager.instance().currentVideoWidth = 0;
        JZMediaManager.instance().currentVideoHeight = 0;
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
        JZUtils.scanForActivity(this.getContext()).getWindow().clearFlags(128);
        this.clearFullscreenLayout();
        JZUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(NORMAL_ORIENTATION);
        JZMediaManager.textureView = null;
        JZMediaManager.savedSurfaceTexture = null;
        this.isVideoRendingStart = false;
    }

    public void release() {
        if (!(!JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex).equals(JZMediaManager.CURRENT_PLAYING_URL) || System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME <= 300L || JZVideoPlayerManager.getSecondFloor() != null && JZVideoPlayerManager.getSecondFloor().currentScreen == 2 || JZVideoPlayerManager.getSecondFloor() == null && JZVideoPlayerManager.getFirstFloor() != null && JZVideoPlayerManager.getFirstFloor().currentScreen == 2)) {
            Log.d((String)TAG, (String)("release [" + ((Object)((Object)this)).hashCode() + "]"));
            JZVideoPlayer.releaseAllVideos();
        }
    }

    public void initTextureView() {
        this.removeTextureView();
        JZMediaManager.textureView = new JZResizeTextureView(this.getContext());
        JZMediaManager.textureView.setSurfaceTextureListener(JZMediaManager.instance());
    }

    public void addTextureView() {
        Log.d((String)TAG, (String)("addTextureView [" + ((Object)((Object)this)).hashCode() + "] "));
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.textureViewContainer.addView((View)JZMediaManager.textureView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void removeTextureView() {
        JZMediaManager.savedSurfaceTexture = null;
        if (JZMediaManager.textureView != null && JZMediaManager.textureView.getParent() != null) {
            ((ViewGroup)JZMediaManager.textureView.getParent()).removeView((View)JZMediaManager.textureView);
        }
    }

    public void clearFullscreenLayout() {
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View oldF = vp.findViewById(33797);
        View oldT = vp.findViewById(33798);
        if (oldF != null) {
            vp.removeView(oldF);
        }
        if (oldT != null) {
            vp.removeView(oldT);
        }
        JZVideoPlayer.showSupportActionBar(this.getContext());
    }

    public void clearFloatScreen() {
        JZUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(NORMAL_ORIENTATION);
        JZVideoPlayer.showSupportActionBar(this.getContext());
        JZVideoPlayer currJzvd = JZVideoPlayerManager.getCurrentJzvd();
        currJzvd.textureViewContainer.removeView((View)JZMediaManager.textureView);
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        vp.removeView((View)currJzvd);
        JZVideoPlayerManager.setSecondFloor(null);
    }

    public void onVideoSizeChanged() {
        Log.i((String)TAG, (String)("onVideoSizeChanged  [" + ((Object)((Object)this)).hashCode() + "] "));
        if (JZMediaManager.textureView != null) {
            JZMediaManager.textureView.setVideoSize(JZMediaManager.instance().getVideoSize());
        }
    }

    public void startProgressTimer() {
        this.cancelProgressTimer();
        UPDATE_PROGRESS_TIMER = new Timer();
        this.mProgressTimerTask = new ProgressTimerTask();
        UPDATE_PROGRESS_TIMER.schedule((TimerTask)this.mProgressTimerTask, 0L, 300L);
    }

    public void cancelProgressTimer() {
        if (UPDATE_PROGRESS_TIMER != null) {
            UPDATE_PROGRESS_TIMER.cancel();
        }
        if (this.mProgressTimerTask != null) {
            this.mProgressTimerTask.cancel();
        }
    }

    public void setProgressAndText(int progress, int position, int duration) {
        if (!this.mTouchingProgressBar && progress != 0) {
            this.progressBar.setProgress(progress);
        }
        if (position != 0) {
            this.currentTimeTextView.setText((CharSequence)JZUtils.stringForTime(position));
        }
        this.totalTimeTextView.setText((CharSequence)JZUtils.stringForTime(duration));
    }

    public void setBufferProgress(int bufferProgress) {
        if (bufferProgress != 0) {
            this.progressBar.setSecondaryProgress(bufferProgress);
        }
    }

    public void resetProgressAndTime() {
        this.progressBar.setProgress(0);
        this.progressBar.setSecondaryProgress(0);
        this.currentTimeTextView.setText((CharSequence)JZUtils.stringForTime(0));
        this.totalTimeTextView.setText((CharSequence)JZUtils.stringForTime(0));
    }

    public int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (JZMediaManager.instance().mediaPlayer == null) {
            return position;
        }
        if (this.currentState == 3 || this.currentState == 5 || this.currentState == 4) {
            try {
                position = JZMediaManager.instance().mediaPlayer.getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return position;
            }
        }
        return position;
    }

    public int getDuration() {
        int duration = 0;
        if (JZMediaManager.instance().mediaPlayer == null) {
            return duration;
        }
        try {
            duration = JZMediaManager.instance().mediaPlayer.getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStartTrackingTouch [" + ((Object)((Object)this)).hashCode() + "] "));
        this.cancelProgressTimer();
        for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
            vpdown.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStopTrackingTouch [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(5);
        this.startProgressTimer();
        for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
            vpup.requestDisallowInterceptTouchEvent(false);
        }
        if (this.currentState != 3 && this.currentState != 5) {
            return;
        }
        int time = seekBar.getProgress() * this.getDuration() / 100;
        JZMediaManager.instance().mediaPlayer.seekTo(time);
        Log.i((String)TAG, (String)("seekTo " + time + " [" + ((Object)((Object)this)).hashCode() + "] "));
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void startWindowFullscreen() {
        Log.i((String)TAG, (String)("startWindowFullscreen  [" + ((Object)((Object)this)).hashCode() + "] "));
        JZVideoPlayer.hideSupportActionBar(this.getContext());
        JZUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(FULLSCREEN_ORIENTATION);
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(33797);
        if (old != null) {
            vp.removeView(old);
        }
        this.textureViewContainer.removeView((View)JZMediaManager.textureView);
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(Context.class);
            JZVideoPlayer jzVideoPlayer = (JZVideoPlayer)((Object)constructor.newInstance(this.getContext()));
            jzVideoPlayer.setId(33797);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            vp.addView((View)jzVideoPlayer, (ViewGroup.LayoutParams)lp);
            jzVideoPlayer.setUp(this.urlMap, this.currentUrlMapIndex, 2, this.objects);
            jzVideoPlayer.setState(this.currentState);
            jzVideoPlayer.addTextureView();
            JZVideoPlayerManager.setSecondFloor(jzVideoPlayer);
            this.onStateNormal();
            jzVideoPlayer.startProgressTimer();
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startWindowTiny() {
        Log.i((String)TAG, (String)("startWindowTiny  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(9);
        if (this.currentState == 0 || this.currentState == 7) {
            return;
        }
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(33798);
        if (old != null) {
            vp.removeView(old);
        }
        this.textureViewContainer.removeView((View)JZMediaManager.textureView);
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(Context.class);
            JZVideoPlayer jzVideoPlayer = (JZVideoPlayer)((Object)constructor.newInstance(this.getContext()));
            jzVideoPlayer.setId(33798);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(400, 400);
            lp.gravity = 85;
            vp.addView((View)jzVideoPlayer, (ViewGroup.LayoutParams)lp);
            jzVideoPlayer.setUp(this.urlMap, this.currentUrlMapIndex, 3, this.objects);
            jzVideoPlayer.setState(this.currentState);
            jzVideoPlayer.addTextureView();
            JZVideoPlayerManager.setSecondFloor(jzVideoPlayer);
            this.onStateNormal();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCurrentJzvd() {
        return JZVideoPlayerManager.getCurrentJzvd() != null && JZVideoPlayerManager.getCurrentJzvd() == this;
    }

    public void playOnThisJzvd() {
        Log.i((String)TAG, (String)("playOnThisJzvd  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = JZVideoPlayerManager.getSecondFloor().currentState;
        this.currentUrlMapIndex = JZVideoPlayerManager.getSecondFloor().currentUrlMapIndex;
        this.clearFloatScreen();
        this.setState(this.currentState);
        this.addTextureView();
    }

    public void autoFullscreen(float x) {
        if (this.isCurrentJzvd() && this.currentState == 3 && this.currentScreen != 2 && this.currentScreen != 3) {
            if (x > 0.0f) {
                JZUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(0);
            } else {
                JZUtils.getAppCompActivity(this.getContext()).setRequestedOrientation(8);
            }
            this.onEvent(7);
            this.startWindowFullscreen();
        }
    }

    public void autoQuitFullscreen() {
        if (System.currentTimeMillis() - lastAutoFullscreenTime > 2000L && this.isCurrentJzvd() && this.currentState == 3 && this.currentScreen == 2) {
            lastAutoFullscreenTime = System.currentTimeMillis();
            JZVideoPlayer.backPress();
        }
    }

    public void onEvent(int type) {
        if (JZ_USER_EVENT != null && this.isCurrentJzvd() && this.urlMap != null) {
            JZ_USER_EVENT.onEvent(type, JZUtils.getCurrentUrlFromMap(this.urlMap, this.currentUrlMapIndex), this.currentScreen, this.objects);
        }
    }

    public void onSeekComplete() {
    }

    public void showWifiDialog(int event) {
    }

    public void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
    }

    public void dismissProgressDialog() {
    }

    public void showVolumeDialog(float deltaY, int volumePercent) {
    }

    public void dismissVolumeDialog() {
    }

    public void showBrightnessDialog(int brightnessPercent) {
    }

    public void dismissBrightnessDialog() {
    }

    public class ProgressTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (JZVideoPlayer.this.currentState == 3 || JZVideoPlayer.this.currentState == 5 || JZVideoPlayer.this.currentState == 4) {
                JZVideoPlayer.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        int position = JZVideoPlayer.this.getCurrentPositionWhenPlaying();
                        int duration = JZVideoPlayer.this.getDuration();
                        int progress = position * 100 / (duration == 0 ? 1 : duration);
                        JZVideoPlayer.this.setProgressAndText(progress, position, duration);
                    }
                });
            }
        }
    }

    public static class JZAutoFullscreenListener
    implements SensorEventListener {
        public void onSensorChanged(SensorEvent event) {
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            if ((x > -15.0f && x < -10.0f || x < 15.0f && x > 10.0f) && (double)Math.abs(y) < 1.5 && System.currentTimeMillis() - lastAutoFullscreenTime > 2000L) {
                if (JZVideoPlayerManager.getCurrentJzvd() != null) {
                    JZVideoPlayerManager.getCurrentJzvd().autoFullscreen(x);
                }
                lastAutoFullscreenTime = System.currentTimeMillis();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

