/*
 * Decompiled with CFR 0.152.
 */
package com.hunter.library.debug;

import android.util.Log;
import com.hunter.library.debug.HunterLoggerHandler;
import java.util.Arrays;

public class ParameterPrinter {
    private StringBuilder result = new StringBuilder();
    private int paramIndex = 0;
    private String divider = ",divider ";
    private String tag = "";

    public ParameterPrinter(String tag, String methodName) {
        this.tag = tag;
        this.result.append("\u21e2 ").append(methodName).append("[");
    }

    public ParameterPrinter append(String name, int val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, val));
        return this;
    }

    public ParameterPrinter append(String name, boolean val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, val));
        return this;
    }

    public ParameterPrinter append(String name, short val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, val));
        return this;
    }

    public ParameterPrinter append(String name, byte val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, val));
        return this;
    }

    public ParameterPrinter append(String name, char val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, Character.valueOf(val)));
        return this;
    }

    public ParameterPrinter append(String name, long val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, val));
        return this;
    }

    public ParameterPrinter append(String name, double val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, val));
        return this;
    }

    public ParameterPrinter append(String name, float val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        this.result.append(String.format("%s=\"%s\"", name, Float.valueOf(val)));
        return this;
    }

    public ParameterPrinter append(String name, Object val) {
        if (this.paramIndex++ != 0) {
            this.result.append(this.divider);
        }
        if (val != null && val.getClass().isArray()) {
            this.result.append(String.format("%s=\"%s\"", name, this.arrayToString(val)));
        } else {
            this.result.append(String.format("%s=\"%s\"", name, val));
        }
        return this;
    }

    private String arrayToString(Object val) {
        if (!(val instanceof Object[])) {
            if (val instanceof int[]) {
                return Arrays.toString((int[])val);
            }
            if (val instanceof char[]) {
                return Arrays.toString((char[])val);
            }
            if (val instanceof boolean[]) {
                return Arrays.toString((boolean[])val);
            }
            if (val instanceof byte[]) {
                return Arrays.toString((byte[])val);
            }
            if (val instanceof long[]) {
                return Arrays.toString((long[])val);
            }
            if (val instanceof double[]) {
                return Arrays.toString((double[])val);
            }
            if (val instanceof float[]) {
                return Arrays.toString((float[])val);
            }
            if (val instanceof short[]) {
                return Arrays.toString((short[])val);
            }
            return "Unknown type array";
        }
        return Arrays.deepToString((Object[])val);
    }

    public void print() {
        this.result.append("]");
        Log.i((String)this.tag, (String)this.result.toString());
    }

    public void printWithCustomLogger() {
        this.result.append("]");
        HunterLoggerHandler.CUSTOM_IMPL.log(this.tag, this.result.toString());
    }
}

