/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import cn.rongcloud.wrapper.RongCloudCrashConfig;
import cn.rongcloud.wrapper.callback.impl.ANRCrashCallbackImpl;
import cn.rongcloud.wrapper.callback.impl.JavaCrashCallbackImpl;
import cn.rongcloud.wrapper.callback.impl.NativeCrashCallbackImpl;
import cn.rongcloud.wrapper.report.RongCloudCrashReportManager;
import cn.rongcloud.wrapper.util.ProcessUtil;
import cn.rongcloud.wrapper.util.RongCloudLogger;
import cn.rongcloud.wrapper.watchdog.ANRWatchDog;
import cn.rongcloud.wrapper.watchdog.ANRWatchDogReport;
import cn.rongcloud.xcrash.XCrash;
import java.lang.reflect.Field;

public final class RongCloudCrash {
    private static final int PLACE_HOLDER_COUNT_MAX = 3;
    private static final int PLACE_HOLDER_SIZE_KB = 512;
    private static final int MAX_COUNT = 10;
    private static final String CRASH_STORAGE_PATH = "/rongcloud/tombstones";
    private static final String[] JAVA_DUMP_ALL_THREAD_WHITE_LIST = new String[]{"^main$", "^Binder:.*", ".*Finalizer.*"};
    private static final String[] NATIVE_DUMP_ALL_THREAD_WRITE_LIST = new String[]{"^Signal Catcher$", "^Jit thread pool$", ".*(R|r)ender.*", ".*Chrome.*"};
    private static final long REPORT_CRASH_DELAY_MILLIS = 10000L;
    private static final String RTC_SDK_BUILD_CONFIG_CLASS_NAME = "cn.rongcloud.rtclib.BuildConfig";
    private static final String IM_SDK_BUILD_CONFIG_CLASS_NAME = "io.rong.libcore.BuildConfig";
    private static final String SDK_VERSION_NAME_FIELD_NAME = "VERSION_NAME";
    private Context globalContext;
    private boolean debug = false;
    private String imVersion;
    private String rtcVersion;
    private boolean initialized = false;
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    private ANRWatchDog anrWatchDog;

    public String getIMVersion() {
        if (!TextUtils.isEmpty((CharSequence)this.imVersion)) {
            return this.imVersion;
        }
        String version = this.getFieldValByReflect(IM_SDK_BUILD_CONFIG_CLASS_NAME, SDK_VERSION_NAME_FIELD_NAME);
        if (!TextUtils.isEmpty((CharSequence)version)) {
            this.imVersion = version;
        }
        return this.imVersion;
    }

    private String getFieldValByReflect(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getRTCVersion() {
        if (!TextUtils.isEmpty((CharSequence)this.rtcVersion)) {
            return this.rtcVersion;
        }
        String version = this.getFieldValByReflect(RTC_SDK_BUILD_CONFIG_CLASS_NAME, SDK_VERSION_NAME_FIELD_NAME);
        if (!TextUtils.isEmpty((CharSequence)version)) {
            this.rtcVersion = version;
        }
        return this.rtcVersion;
    }

    public static RongCloudCrash getInstance() {
        return RongCloudCrashHolder.INSTANCE;
    }

    public Context getGlobalContext() {
        return this.globalContext;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getPackageName() {
        Context context = this.getGlobalContext();
        if (context != null) {
            return context.getPackageName();
        }
        return "";
    }

    public void init(Context context) {
        this.init(context, "", "");
    }

    public synchronized void init(Context context, String imVersion, String rtcVersion) {
        if (!RongCloudCrashConfig.getInstance().isAllowCrashCatch()) {
            RongCloudLogger.d("init # RongCloudCrashConfig disAllowCrashCatch just return !");
            return;
        }
        if (!ProcessUtil.isMainProcess(context)) {
            RongCloudLogger.d("init # RongCloudCrash Crash SDK only init in main process!!!");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)imVersion)) {
            this.imVersion = imVersion;
        }
        if (!TextUtils.isEmpty((CharSequence)rtcVersion)) {
            this.rtcVersion = rtcVersion;
        }
        String version = String.format("%s:%s", this.imVersion, this.rtcVersion);
        if (context == null) {
            RongCloudLogger.d("context is null !");
            return;
        }
        this.debug = (context.getApplicationInfo().flags & 2) != 0;
        this.globalContext = context;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.initial(context, version);
        } else {
            mainHandler.post(() -> this.initial(context, version));
        }
        mainHandler.postDelayed(RongCloudCrashReportManager::handleCrashReport, 10000L);
    }

    private void initial(Context context, String sdkVersion) {
        if (this.initialized) {
            RongCloudLogger.d("xCrash SDK only init once!!!");
            return;
        }
        RongCloudLogger.d("xCrash SDK init: start");
        XCrash.InitParameters parameters = new XCrash.InitParameters().setAppVersion(sdkVersion);
        if (RongCloudCrashConfig.getInstance().isAllowJavaCrashCatch()) {
            RongCloudLogger.d("RongCloudCrashConfig enableJavaCrashHandler");
            parameters.setJavaRethrow(true).enableJavaCrashHandler().setJavaLogCountMax(10).setJavaDumpAllThreadsWhiteList(JAVA_DUMP_ALL_THREAD_WHITE_LIST).setJavaDumpAllThreadsCountMax(10).setJavaCallback(new JavaCrashCallbackImpl());
        } else {
            parameters.disableJavaCrashHandler();
            RongCloudLogger.d("RongCloudCrashConfig disableJavaCrashHandler");
        }
        if (RongCloudCrashConfig.getInstance().isAllowNativeCrashCatch()) {
            RongCloudLogger.d("RongCloudCrashConfig enableNativeCrashHandler");
            parameters.setNativeRethrow(true).enableNativeCrashHandler().setNativeLogCountMax(10).setNativeDumpAllThreadsWhiteList(NATIVE_DUMP_ALL_THREAD_WRITE_LIST).setNativeDumpAllThreadsCountMax(10).setNativeCallback(new NativeCrashCallbackImpl());
        } else {
            parameters.disableNativeCrashHandler();
            RongCloudLogger.d("RongCloudCrashConfig disableNativeCrashHandler");
        }
        if (RongCloudCrashConfig.getInstance().isAllowANRCatch()) {
            parameters.setAnrRethrow(true).enableAnrCrashHandler().setAnrLogCountMax(10).setAnrCallback(new ANRCrashCallbackImpl());
            RongCloudLogger.d("RongCloudCrashConfig enableAnrCrashHandler");
        } else {
            parameters.disableAnrCrashHandler();
            RongCloudLogger.d("RongCloudCrashConfig disableAnrCrashHandler And Start ANRWatchDog...");
            this.anrWatchDog = new ANRWatchDog(new ANRWatchDogReport(), context);
            this.anrWatchDog.start();
        }
        parameters.setPlaceholderCountMax(3).setPlaceholderSizeKb(512).setLogDir(context.getFilesDir() + CRASH_STORAGE_PATH);
        XCrash.init(context, parameters);
        this.initialized = true;
        RongCloudLogger.d("xCrash SDK init: end");
    }

    private static final class RongCloudCrashHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final RongCloudCrash INSTANCE = new RongCloudCrash();

        private RongCloudCrashHolder() {
        }
    }
}

