/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.callback;

import cn.rongcloud.wrapper.RongCloudCrash;
import cn.rongcloud.wrapper.util.RongCloudLogger;
import cn.rongcloud.xcrash.ICrashCallback;
import cn.rongcloud.xcrash.TombstoneManager;
import cn.rongcloud.xcrash.TombstoneParser;
import cn.rongcloud.xcrash.XCrash;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.UUID;
import org.json.JSONObject;

public abstract class AbstractCrashCallbackImpl
implements ICrashCallback {
    @Override
    public void onCrash(String logPath, String emergency) throws Exception {
        String uuid = UUID.randomUUID().toString();
        TombstoneManager.appendSection(logPath, "crash_uuid", uuid);
        if (RongCloudCrash.getInstance().isDebug()) {
            this.debug(logPath, emergency, uuid);
            RongCloudLogger.d(this.getCrashType() + " <<<>>> log path: " + (logPath != null ? logPath : "(null)") + ", emergency: " + (emergency != null ? emergency : "(null)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debug(String logPath, String emergency, String uuid) {
        OutputStreamWriter writer = null;
        try {
            String fileName = String.format("%s_%s_%s.json", uuid, this.getCrashType(), "debug");
            File debug = new File(XCrash.getLogDir() + "/" + fileName);
            debug.createNewFile();
            writer = new FileWriter(debug, false);
            writer.write(new JSONObject(TombstoneParser.parse(logPath, emergency)).toString());
        }
        catch (Exception e) {
            RongCloudLogger.d("debug failed", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public abstract String getCrashType();
}

