/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.parse;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public final class ANRTraceParser {
    private static final String KEY_SPLIT_LINE = "\n";
    private static final String KEY_ANR_MAIN_PRE = "\"main\"";
    private static final String KEY_DALVIK_THREADS = "DALVIK THREADS";

    private static List<List<String>> parseAllThreadTrace(String allThreadTrace) {
        String[] lines;
        ArrayList<List<String>> threads = new ArrayList<List<String>>();
        if (TextUtils.isEmpty((CharSequence)allThreadTrace)) {
            return threads;
        }
        ArrayList<String> threadTrace = new ArrayList<String>();
        for (String line : lines = allThreadTrace.split(KEY_SPLIT_LINE)) {
            if (line.isEmpty()) {
                ArrayList<String> thread = new ArrayList<String>();
                thread.addAll(threadTrace);
                if (!thread.isEmpty()) {
                    threads.add(thread);
                }
                threadTrace.clear();
                continue;
            }
            if (line.startsWith(KEY_DALVIK_THREADS)) {
                threadTrace.clear();
                continue;
            }
            threadTrace.add(line);
        }
        return threads;
    }

    public static List<String> findMainTrace(List<List<String>> traces) {
        for (List<String> trace : traces) {
            if (trace == null || trace.size() <= 0 || !trace.get(0).startsWith(KEY_ANR_MAIN_PRE)) continue;
            return trace;
        }
        return null;
    }

    public static String findMainTrance(String allThreadTrace) {
        try {
            List<List<String>> traces = ANRTraceParser.parseAllThreadTrace(allThreadTrace);
            List<String> mainTrace = ANRTraceParser.findMainTrace(traces);
            return ANRTraceParser.parseMainTrace(mainTrace);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String parseMainTrace(List<String> trace) {
        if (trace == null || trace.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String line : trace) {
            result.append(line).append(KEY_SPLIT_LINE);
        }
        return result.toString();
    }
}

