/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.parse;

import cn.rongcloud.wrapper.RongCloudCrash;
import cn.rongcloud.wrapper.report.CrashEvent;
import cn.rongcloud.wrapper.util.DateFormatUtil;
import cn.rongcloud.xcrash.TombstoneParser;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class RongTombstoneConvertManager {
    public static CrashEvent toCrashEvent(Map<String, String> tombstone) {
        try {
            CrashEvent crashEvent = new CrashEvent();
            crashEvent.packageName = tombstone.get("App ID");
            crashEvent.imVersion = RongCloudCrash.getInstance().getIMVersion();
            crashEvent.rtcVersion = RongCloudCrash.getInstance().getRTCVersion();
            crashEvent.crashTimestamp = DateFormatUtil.parseTombstoneTimestamp(tombstone.get("Crash time"));
            crashEvent.abi = tombstone.get("ABI");
            crashEvent.APILevel = tombstone.get("API level");
            crashEvent.brand = tombstone.get("Brand");
            crashEvent.model = tombstone.get("Model");
            crashEvent.foreground = tombstone.get("foreground");
            crashEvent.isDebug = RongCloudCrash.getInstance().isDebug();
            return crashEvent;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Map<String, String> transformTombstoneFileToMap(File file) {
        try {
            return TombstoneParser.parse(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

