/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.report;

import android.text.TextUtils;
import cn.rongcloud.wrapper.RongCloudCrash;
import cn.rongcloud.wrapper.parse.RongTombstoneConvertManager;
import cn.rongcloud.wrapper.report.CrashEvent;
import cn.rongcloud.wrapper.util.ABIUtil;
import cn.rongcloud.wrapper.util.RongCloudLogger;
import cn.rongcloud.wrapper.util.SDKTypeUtil;
import cn.rongcloud.xcrash.TombstoneManager;
import com.google.gson.Gson;
import io.rong.common.fwlog.FwLog;
import java.io.File;
import java.util.Map;

public abstract class AbstractCrashReport<T> {
    protected static final String COMMON_KEYS = "APILevel|abi|brand|crashTimestamp|foreground|model|imVersion|rtcVersion|isDebug|appName|stacks";
    protected CrashEvent<T> crashEvent;

    public abstract String crashType();

    public abstract File[] getTombstonesByCrashType();

    public abstract T generateCrashData(Map<String, String> var1);

    public abstract String getTrace();

    public int getSDKType() {
        String trace = this.getTrace();
        return SDKTypeUtil.getSDKTypeByJavaTrace(trace);
    }

    public boolean canReport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void report() {
        File[] files = this.getTombstonesByCrashType();
        if (files == null || files.length == 0) {
            RongCloudLogger.d(this + ":" + this.crashType() + " has no tombstone file!");
            return;
        }
        for (File file : files) {
            if (file == null || !file.exists()) {
                RongCloudLogger.d(this + ":" + this.crashType() + " file not exists!");
                continue;
            }
            String string = file.getAbsolutePath().intern();
            synchronized (string) {
                byte[] buffer;
                String data;
                this.crashEvent = this.generateCrashEvent(file);
                if (this.crashEvent == null) {
                    return;
                }
                if (this.canReport()) {
                    this.handleCrashData();
                    RongCloudLogger.d("crash event call FwLog.write after");
                    if (RongCloudCrash.getInstance().isDebug()) {
                        data = new Gson().toJson(this.crashEvent);
                        buffer = data.getBytes();
                        RongCloudLogger.d("\u300cDebug Mode\u300d\u300cMatch cn.rongcloud Report\u300d Crash Data >>> " + String.format("data size = %s,%s, %s", buffer.length, this.crashEvent.crashType, data));
                    }
                } else if (RongCloudCrash.getInstance().isDebug()) {
                    data = new Gson().toJson(this.crashEvent);
                    buffer = data.getBytes();
                    RongCloudLogger.d("\u300cDebug Mode\u300d\u300cNot Match Report\u300d Crash Data >>> " + String.format("size = %s,%s, %s", buffer.length, this.crashEvent.crashType, data));
                }
                TombstoneManager.deleteTombstone(file);
            }
        }
    }

    private String fixAbi(String abi) {
        if (TextUtils.isEmpty((CharSequence)abi) || "null".equals(abi)) {
            return ABIUtil.getCurrentAbi();
        }
        return abi;
    }

    private void handleCrashData() {
        String stackTrace = this.getTrace();
        if (TextUtils.isEmpty((CharSequence)stackTrace)) {
            return;
        }
        Object[] commonArgs = new Object[]{this.crashEvent.APILevel, this.fixAbi(this.crashEvent.abi), this.crashEvent.brand, this.crashEvent.crashTimestamp, this.crashEvent.foreground, this.crashEvent.model, this.crashEvent.imVersion, this.crashEvent.rtcVersion, this.crashEvent.isDebug, this.crashEvent.packageName, stackTrace};
        FwLog.write((int)0, (int)this.getSDKType(), (String)this.crashType(), (String)COMMON_KEYS, (Object[])commonArgs);
    }

    private CrashEvent<T> generateCrashEvent(File file) {
        Map<String, String> tombstone = RongTombstoneConvertManager.transformTombstoneFileToMap(file);
        this.crashEvent = RongTombstoneConvertManager.toCrashEvent(tombstone);
        this.crashEvent.data = this.generateCrashData(tombstone);
        return this.crashEvent;
    }
}

