/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.report;

import cn.rongcloud.wrapper.report.AbstractCrashReport;
import cn.rongcloud.wrapper.report.impl.ANRCrashReportImpl;
import cn.rongcloud.wrapper.report.impl.JavaCrashReportImpl;
import cn.rongcloud.wrapper.report.impl.NativeCrashReportImpl;
import cn.rongcloud.wrapper.util.RongCloudLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class RongCloudCrashReportManager {
    private static final List<AbstractCrashReport> sCrashReports = new ArrayList<AbstractCrashReport>();
    private static final Executor sExecutor = Executors.newSingleThreadExecutor();

    public static void handleCrashReport() {
        sExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    RongCloudCrashReportManager.handleCrashReportInner();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static void handleCrashReportInner() {
        if (sCrashReports.isEmpty()) {
            RongCloudLogger.d("crash report not register!");
            return;
        }
        for (AbstractCrashReport crashReport : sCrashReports) {
            crashReport.report();
        }
    }

    static {
        sCrashReports.add(new JavaCrashReportImpl());
        sCrashReports.add(new NativeCrashReportImpl());
        sCrashReports.add(new ANRCrashReportImpl());
    }
}

