/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.report.impl;

import android.text.TextUtils;
import cn.rongcloud.wrapper.parse.ANRTraceParser;
import cn.rongcloud.wrapper.report.AbstractCrashReport;
import cn.rongcloud.wrapper.report.impl.ANRCrashData;
import cn.rongcloud.xcrash.TombstoneManager;
import java.io.File;
import java.util.Map;

public class ANRCrashReportImpl
extends AbstractCrashReport<ANRCrashData> {
    @Override
    public String crashType() {
        return "L-crash_anr-S";
    }

    @Override
    public File[] getTombstonesByCrashType() {
        return TombstoneManager.getAnrTombstones();
    }

    @Override
    public ANRCrashData generateCrashData(Map<String, String> tombstone) {
        ANRCrashData anrCrashData = new ANRCrashData();
        String anrAllThreadTraces = tombstone.get("other threads");
        anrCrashData.mainTrace = ANRTraceParser.findMainTrance(anrAllThreadTraces);
        return anrCrashData;
    }

    @Override
    public boolean canReport() {
        if (!TextUtils.isEmpty((CharSequence)((ANRCrashData)this.crashEvent.data).mainTrace)) {
            return ((ANRCrashData)this.crashEvent.data).mainTrace.contains("cn.rongcloud") || ((ANRCrashData)this.crashEvent.data).mainTrace.contains("io.rong");
        }
        return true;
    }

    @Override
    public String getTrace() {
        return ((ANRCrashData)this.crashEvent.data).mainTrace;
    }
}

