/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.report.impl;

import android.text.TextUtils;
import cn.rongcloud.wrapper.report.AbstractCrashReport;
import cn.rongcloud.wrapper.report.impl.NativeCrashData;
import cn.rongcloud.wrapper.util.SDKTypeUtil;
import cn.rongcloud.xcrash.TombstoneManager;
import java.io.File;
import java.util.Map;

public class NativeCrashReportImpl
extends AbstractCrashReport<NativeCrashData> {
    @Override
    public String crashType() {
        return "L-crash_native-S";
    }

    @Override
    public File[] getTombstonesByCrashType() {
        return TombstoneManager.getNativeTombstones();
    }

    @Override
    public NativeCrashData generateCrashData(Map<String, String> tombstone) {
        String backTrace;
        NativeCrashData nativeCrashData = new NativeCrashData();
        nativeCrashData.javaStackTrace = tombstone.get("java stacktrace");
        nativeCrashData.abortMessage = tombstone.get("Abort message");
        nativeCrashData.code = tombstone.get("code");
        nativeCrashData.backTrace = backTrace = tombstone.get("backtrace");
        return nativeCrashData;
    }

    @Override
    public int getSDKType() {
        String backTrace = ((NativeCrashData)this.crashEvent.data).backTrace;
        if (TextUtils.isEmpty((CharSequence)backTrace)) {
            return super.getSDKType();
        }
        int sdkType = SDKTypeUtil.getSDKTypeByBackTrace(backTrace);
        if (sdkType != 0) {
            return sdkType;
        }
        return super.getSDKType();
    }

    @Override
    public boolean canReport() {
        if (!TextUtils.isEmpty((CharSequence)((NativeCrashData)this.crashEvent.data).javaStackTrace)) {
            return ((NativeCrashData)this.crashEvent.data).javaStackTrace.contains("cn.rongcloud") || ((NativeCrashData)this.crashEvent.data).javaStackTrace.contains("io.rong");
        }
        if (!TextUtils.isEmpty((CharSequence)((NativeCrashData)this.crashEvent.data).backTrace)) {
            return ((NativeCrashData)this.crashEvent.data).backTrace.contains("cn.rongcloud") || ((NativeCrashData)this.crashEvent.data).backTrace.contains("io.rong");
        }
        return true;
    }

    @Override
    public String getTrace() {
        StringBuilder builder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)((NativeCrashData)this.crashEvent.data).javaStackTrace)) {
            builder.append(((NativeCrashData)this.crashEvent.data).javaStackTrace).append("\n");
        }
        if (!TextUtils.isEmpty((CharSequence)((NativeCrashData)this.crashEvent.data).code)) {
            builder.append(((NativeCrashData)this.crashEvent.data).code).append("\n");
        }
        if (!TextUtils.isEmpty((CharSequence)((NativeCrashData)this.crashEvent.data).abortMessage)) {
            builder.append(((NativeCrashData)this.crashEvent.data).abortMessage).append("\n");
        }
        if (!TextUtils.isEmpty((CharSequence)((NativeCrashData)this.crashEvent.data).backTrace)) {
            builder.append(((NativeCrashData)this.crashEvent.data).backTrace);
        }
        return builder.toString();
    }
}

