/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.util;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import cn.rongcloud.wrapper.RongCloudCrash;
import java.lang.reflect.Method;

public final class ABIUtil {
    private static final String ARMEABI_V7A = "arm-v7a";
    private static final String ARM64_V8A = "arm64";
    private static final String UNKNOWN = "unknown";
    private static String currentABI = "unknown";

    public static String getCurrentAbi() {
        if (Build.VERSION.SDK_INT < 21) {
            return ARMEABI_V7A;
        }
        if (!currentABI.equals(UNKNOWN)) {
            return currentABI;
        }
        currentABI = ABIUtil.getAbiByRuntime();
        if (!TextUtils.isEmpty((CharSequence)currentABI)) {
            return currentABI;
        }
        currentABI = ABIUtil.getAbiByUnsafe();
        if (!TextUtils.isEmpty((CharSequence)currentABI)) {
            return currentABI;
        }
        currentABI = ABIUtil.getAibByApplicationInfo(RongCloudCrash.getInstance().getGlobalContext());
        if (!TextUtils.isEmpty((CharSequence)currentABI)) {
            return currentABI;
        }
        return UNKNOWN;
    }

    private static String getAbiByRuntime() {
        try {
            Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
            Method method = clazz.getMethod("getRuntime", new Class[0]);
            method.setAccessible(true);
            Object instance = method.invoke(null, new Object[0]);
            Method is64BitMethod = clazz.getMethod("is64Bit", new Class[0]);
            is64BitMethod.setAccessible(true);
            boolean is64 = (Boolean)is64BitMethod.invoke(instance, new Object[0]);
            if (is64) {
                return ARM64_V8A;
            }
            return ARMEABI_V7A;
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    private static String getAbiByUnsafe() {
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Method method = clazz.getMethod("getUnsafe", new Class[0]);
            method.setAccessible(true);
            Object instance = method.invoke(null, new Object[0]);
            Method addressSizeMethod = clazz.getMethod("addressSize", new Class[0]);
            addressSizeMethod.setAccessible(true);
            Integer addressSize = (Integer)addressSizeMethod.invoke(instance, new Object[0]);
            if (addressSize == 8) {
                return ARM64_V8A;
            }
            return ARMEABI_V7A;
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    private static String getAibByApplicationInfo(Context context) {
        try {
            if (context == null) {
                return UNKNOWN;
            }
            boolean isArm64 = context.getApplicationInfo().nativeLibraryDir.contains(ARM64_V8A);
            if (isArm64) {
                return ARM64_V8A;
            }
            return ARMEABI_V7A;
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }
}

