/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.List;

public final class ProcessUtil {
    private static String PROCESS_NAME = "";

    private static String getProcessNameByAMS(Context context) {
        if (context == null) {
            return "";
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return "";
        }
        List processInfoList = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo processInfo : processInfoList) {
            if (processInfo.pid != Process.myPid()) continue;
            return processInfo.processName;
        }
        return "";
    }

    private static String getProcessNameByProc() {
        String path = String.format("/proc/%s/cmdline", Process.myPid());
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            return reader.readLine().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getProcessName(Context context) {
        if (TextUtils.isEmpty((CharSequence)PROCESS_NAME) && TextUtils.isEmpty((CharSequence)(PROCESS_NAME = ProcessUtil.getProcessNameByAMS(context)))) {
            PROCESS_NAME = ProcessUtil.getProcessNameByProc();
        }
        return PROCESS_NAME;
    }

    public static boolean isMainProcess(Context context) {
        String currentProcessName = context.getPackageName();
        return !TextUtils.isEmpty((CharSequence)currentProcessName) && currentProcessName.equals(ProcessUtil.getProcessName(context));
    }

    public static String getVersionName(Context context) {
        if (context == null) {
            return "";
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo info = packageManager.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getVersionCode(Context context) {
        if (context == null) {
            return "";
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo info = packageManager.getPackageInfo(context.getPackageName(), 0);
            return String.valueOf(info.versionCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

