/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.util;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class SDKTypeUtil {
    public static final int FW_LOG_DEFAULT = 0;
    private static final List<Pattern> RTC_NATIVE_LIBS_PATTERN_LIST = new ArrayList<Pattern>();
    private static final List<Pattern> IM_NATIVE_LIBS_PATTERN_LIST = new ArrayList<Pattern>();
    private static final List<Pattern> RTC_JAVA_PATTERN_LIST = new ArrayList<Pattern>();
    private static final List<Pattern> IM_JAVA_PATTERN_LIST = new ArrayList<Pattern>();

    public static void clearDefaultSDKPatterns() {
        RTC_JAVA_PATTERN_LIST.clear();
        RTC_NATIVE_LIBS_PATTERN_LIST.clear();
        IM_JAVA_PATTERN_LIST.clear();
        IM_NATIVE_LIBS_PATTERN_LIST.clear();
    }

    public static void registerRTCSDKSoPattern(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        RTC_NATIVE_LIBS_PATTERN_LIST.add(pattern);
    }

    public static void registerRTCSDKJavaPattern(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        RTC_JAVA_PATTERN_LIST.add(pattern);
    }

    public static void registerIMSDKSoPattern(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        IM_NATIVE_LIBS_PATTERN_LIST.add(pattern);
    }

    public static void registerIMSDKJavaPattern(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        IM_JAVA_PATTERN_LIST.add(pattern);
    }

    public static int getSDKTypeByBackTrace(String backTrace) {
        String[] traces;
        if (TextUtils.isEmpty((CharSequence)backTrace)) {
            return 0;
        }
        for (String trace : traces = backTrace.split("\n")) {
            if (SDKTypeUtil.isRTCBackTrace(trace)) {
                return 2;
            }
            if (!SDKTypeUtil.isIMBackTrace(trace)) continue;
            return 1;
        }
        return 0;
    }

    public static int getSDKTypeByJavaTrace(String javaTrace) {
        String[] traces;
        if (TextUtils.isEmpty((CharSequence)javaTrace)) {
            return 1;
        }
        for (String trace : traces = javaTrace.split("\n")) {
            if (SDKTypeUtil.isRTCJavaTrace(trace)) {
                return 2;
            }
            if (!SDKTypeUtil.isIMJavaTrace(trace)) continue;
            return 1;
        }
        return 1;
    }

    private static boolean isRTCBackTrace(String trace) {
        return SDKTypeUtil.checkSDKTraceByPatterns(trace, RTC_NATIVE_LIBS_PATTERN_LIST);
    }

    private static boolean isRTCJavaTrace(String trace) {
        return SDKTypeUtil.checkSDKTraceByPatterns(trace, RTC_JAVA_PATTERN_LIST);
    }

    public static boolean isIMBackTrace(String trace) {
        return SDKTypeUtil.checkSDKTraceByPatterns(trace, IM_NATIVE_LIBS_PATTERN_LIST);
    }

    public static boolean isIMJavaTrace(String trace) {
        return SDKTypeUtil.checkSDKTraceByPatterns(trace, IM_JAVA_PATTERN_LIST);
    }

    private static boolean checkSDKTraceByPatterns(String trace, List<Pattern> patterns) {
        if (TextUtils.isEmpty((CharSequence)trace)) {
            return false;
        }
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(trace).find()) continue;
            return true;
        }
        return false;
    }

    static {
        SDKTypeUtil.registerRTCSDKJavaPattern(Pattern.compile(".*cn.rongcloud.*"));
        SDKTypeUtil.registerRTCSDKSoPattern(Pattern.compile(".*RongRTC.*.so.*"));
        SDKTypeUtil.registerIMSDKJavaPattern(Pattern.compile(".*io.rong.*"));
        SDKTypeUtil.registerIMSDKSoPattern(Pattern.compile(".*RongIM.*.so.*"));
    }
}

