/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.watchdog;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import cn.rongcloud.wrapper.util.RongCloudLogger;
import cn.rongcloud.wrapper.watchdog.ApplicationNotResponding;
import cn.rongcloud.wrapper.watchdog.IHandler;
import cn.rongcloud.wrapper.watchdog.MainLooperHandler;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class ANRWatchDog
extends Thread {
    private static final long TIMEOUT_INTERVAL_MILLIS = 5000L;
    private final boolean reportInDebug;
    private final ANRListener anrListener;
    private final IHandler uiHandler;
    private final long timeoutIntervalMillis;
    private final AtomicLong tick = new AtomicLong(0L);
    private final AtomicBoolean reported = new AtomicBoolean(false);
    private final Context context;
    private final Runnable ticker = () -> {
        this.tick.set(0L);
        this.reported.set(false);
    };

    public ANRWatchDog(ANRListener listener, Context context) {
        this(5000L, true, listener, new MainLooperHandler(), context);
    }

    ANRWatchDog(long timeoutIntervalMillis, boolean reportInDebug, ANRListener listener, IHandler uiHandler, Context context) {
        this.reportInDebug = reportInDebug;
        this.anrListener = listener;
        this.timeoutIntervalMillis = timeoutIntervalMillis;
        this.uiHandler = uiHandler;
        this.context = context;
    }

    @Override
    public void run() {
        this.setName("|ANR-WatchDog|");
        long interval = this.timeoutIntervalMillis;
        while (!this.isInterrupted()) {
            boolean needPost = this.tick.get() == 0L;
            this.tick.addAndGet(interval);
            if (needPost) {
                this.uiHandler.post(this.ticker);
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                RongCloudLogger.d(String.format("Interrupted: %s", e.getMessage()));
                return;
            }
            if (this.tick.get() == 0L || this.reported.get()) continue;
            if (!this.reportInDebug && (Debug.isDebuggerConnected() || Debug.waitingForDebugger())) {
                RongCloudLogger.d("An ANR was detected but ignored because the debugger is connected.");
                this.reported.set(true);
                continue;
            }
            ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
            if (am != null) {
                try {
                    List processesInErrorState = am.getProcessesInErrorState();
                    if (processesInErrorState == null) continue;
                    boolean isAnr = false;
                    for (ActivityManager.ProcessErrorStateInfo item : processesInErrorState) {
                        if (item.condition != 2) continue;
                        isAnr = true;
                        break;
                    }
                    if (!isAnr) {
                        continue;
                    }
                }
                catch (Exception processesInErrorState) {
                    // empty catch block
                }
            }
            RongCloudLogger.d("Raising ANR");
            String message = "ANR : ";
            ApplicationNotResponding error = new ApplicationNotResponding("ANR : ", this.uiHandler.getThread());
            this.anrListener.onAppNotResponding(error);
            interval = this.timeoutIntervalMillis;
            this.reported.set(true);
        }
    }

    public static interface ANRListener {
        public void onAppNotResponding(ApplicationNotResponding var1);
    }
}

