/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.wrapper.watchdog;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import cn.rongcloud.wrapper.RongCloudCrash;
import cn.rongcloud.wrapper.util.ABIUtil;
import cn.rongcloud.wrapper.util.RongCloudLogger;
import cn.rongcloud.wrapper.util.SDKTypeUtil;
import cn.rongcloud.wrapper.watchdog.ANRWatchDog;
import cn.rongcloud.wrapper.watchdog.ApplicationNotResponding;
import io.rong.common.fwlog.FwLog;

public final class ANRWatchDogReport
implements ANRWatchDog.ANRListener {
    @Override
    public void onAppNotResponding(ApplicationNotResponding error) {
        String stackTrace = Log.getStackTraceString((Throwable)error);
        stackTrace = ApplicationNotResponding.replaceTag(stackTrace);
        String tags = String.format("APILevel|abi|brand|model|%s|%s|%s|%s|%s|%s", "imVersion", "rtcVersion", "crashTimestamp", "isDebug", "appName", "stacks");
        if (TextUtils.isEmpty((CharSequence)stackTrace)) {
            return;
        }
        FwLog.write((int)0, (int)SDKTypeUtil.getSDKTypeByJavaTrace(stackTrace), (String)"L-crash_anr-S", (String)tags, (Object[])new Object[]{Build.VERSION.SDK_INT, ABIUtil.getCurrentAbi(), Build.BOARD, Build.MODEL, RongCloudCrash.getInstance().getIMVersion(), RongCloudCrash.getInstance().getRTCVersion(), System.currentTimeMillis(), RongCloudCrash.getInstance().isDebug(), RongCloudCrash.getInstance().getPackageName(), stackTrace});
        if (RongCloudCrash.getInstance().isDebug()) {
            RongCloudLogger.d("ANRWatchDog report ANR " + stackTrace);
        }
    }
}

