/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.xcrash;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import java.util.LinkedList;

class ActivityMonitor {
    private static final ActivityMonitor instance = new ActivityMonitor();
    private LinkedList<Activity> activities = null;
    private boolean isAppForeground = false;
    private static final int MAX_ACTIVITY_NUM = 100;

    private ActivityMonitor() {
    }

    static ActivityMonitor getInstance() {
        return instance;
    }

    void initialize(Application application) {
        this.activities = new LinkedList();
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
            private int activityReferences = 0;
            private boolean isActivityChangingConfigurations = false;

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ActivityMonitor.this.activities.addFirst(activity);
                if (ActivityMonitor.this.activities.size() > 100) {
                    ActivityMonitor.this.activities.removeLast();
                }
            }

            public void onActivityStarted(Activity activity) {
                if (++this.activityReferences == 1 && !this.isActivityChangingConfigurations) {
                    ActivityMonitor.this.isAppForeground = true;
                }
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
                this.isActivityChangingConfigurations = activity.isChangingConfigurations();
                if (--this.activityReferences == 0 && !this.isActivityChangingConfigurations) {
                    ActivityMonitor.this.isAppForeground = false;
                }
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                ActivityMonitor.this.activities.remove(activity);
            }
        });
    }

    void finishAllActivities() {
        if (this.activities != null) {
            for (Activity activity : this.activities) {
                activity.finish();
            }
            this.activities.clear();
        }
    }

    boolean isApplicationForeground() {
        return this.isAppForeground;
    }
}

