/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.xcrash;

import android.content.Context;
import android.os.Build;
import android.os.FileObserver;
import android.text.TextUtils;
import cn.rongcloud.xcrash.FileManager;
import cn.rongcloud.xcrash.ICrashCallback;
import cn.rongcloud.xcrash.Util;
import cn.rongcloud.xcrash.XCrash;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AnrHandler {
    private static final AnrHandler instance = new AnrHandler();
    private final Date startTime = new Date();
    private final Pattern patPidTime = Pattern.compile("^-----\\spid\\s(\\d+)\\sat\\s(.*)\\s-----$");
    private final Pattern patProcessName = Pattern.compile("^Cmd\\sline:\\s+(.*)$");
    private final long anrTimeoutMs = 15000L;
    private Context ctx;
    private int pid;
    private String processName;
    private String appId;
    private String appVersion;
    private String logDir;
    private boolean checkProcessState;
    private int logcatSystemLines;
    private int logcatEventsLines;
    private int logcatMainLines;
    private boolean dumpFds;
    private boolean dumpNetworkInfo;
    private ICrashCallback callback;
    private ICrashCallback anrFastCallback;
    private long lastTime = 0L;
    private FileObserver fileObserver = null;

    private AnrHandler() {
    }

    static AnrHandler getInstance() {
        return instance;
    }

    void initialize(Context ctx, int pid, String processName, String appId, String appVersion, String logDir, boolean checkProcessState, int logcatSystemLines, int logcatEventsLines, int logcatMainLines, boolean dumpFds, boolean dumpNetworkInfo, ICrashCallback callback, ICrashCallback anrFastCallback) {
        if (Build.VERSION.SDK_INT >= 21) {
            return;
        }
        this.ctx = ctx;
        this.pid = pid;
        this.processName = TextUtils.isEmpty((CharSequence)processName) ? "unknown" : processName;
        this.appId = appId;
        this.appVersion = appVersion;
        this.logDir = logDir;
        this.checkProcessState = checkProcessState;
        this.logcatSystemLines = logcatSystemLines;
        this.logcatEventsLines = logcatEventsLines;
        this.logcatMainLines = logcatMainLines;
        this.dumpFds = dumpFds;
        this.dumpNetworkInfo = dumpNetworkInfo;
        this.callback = callback;
        this.anrFastCallback = anrFastCallback;
        this.fileObserver = new FileObserver("/data/anr/", 8){

            public void onEvent(int event, String path) {
                try {
                    String filepath;
                    if (path != null && (filepath = "/data/anr/" + path).contains("trace")) {
                        AnrHandler.this.handleAnr(filepath);
                    }
                }
                catch (Exception e) {
                    XCrash.getLogger().e("rongcloud_xcrash", "AnrHandler fileObserver onEvent failed", e);
                }
            }
        };
        try {
            this.fileObserver.startWatching();
        }
        catch (Exception e) {
            this.fileObserver = null;
            XCrash.getLogger().e("rongcloud_xcrash", "AnrHandler fileObserver startWatching failed", e);
        }
    }

    void notifyJavaCrashed() {
        if (this.fileObserver != null) {
            try {
                this.fileObserver.stopWatching();
            }
            catch (Exception e) {
                XCrash.getLogger().e("rongcloud_xcrash", "AnrHandler fileObserver stopWatching failed", e);
            }
            finally {
                this.fileObserver = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAnr(String filepath) {
        Date anrTime = new Date();
        if (anrTime.getTime() - this.lastTime < 15000L) {
            return;
        }
        if (this.anrFastCallback != null) {
            try {
                this.anrFastCallback.onCrash(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.checkProcessState && !Util.checkProcessAnrState(this.ctx, 15000L)) {
            return;
        }
        String trace = this.getTrace(filepath, anrTime.getTime());
        if (TextUtils.isEmpty((CharSequence)trace)) {
            return;
        }
        this.lastTime = anrTime.getTime();
        if (!FileManager.getInstance().maintainAnr()) {
            return;
        }
        String emergency = null;
        try {
            emergency = this.getEmergency(anrTime, trace);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "AnrHandler getEmergency failed", e);
        }
        File logFile = null;
        try {
            String logPath = String.format(Locale.US, "%s/%s_%020d_%s__%s%s", this.logDir, "tombstone", anrTime.getTime() * 1000L, this.appVersion, this.processName, ".anr.xcrash");
            logFile = FileManager.getInstance().createLogFile(logPath);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "AnrHandler createLogFile failed", e);
        }
        if (logFile != null) {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(logFile, "rws");
                if (emergency != null) {
                    raf.write(emergency.getBytes("UTF-8"));
                }
                emergency = null;
                if (this.logcatMainLines > 0 || this.logcatSystemLines > 0 || this.logcatEventsLines > 0) {
                    raf.write(Util.getLogcat(this.logcatMainLines, this.logcatSystemLines, this.logcatEventsLines).getBytes("UTF-8"));
                }
                if (this.dumpFds) {
                    raf.write(Util.getFds().getBytes("UTF-8"));
                }
                if (this.dumpNetworkInfo) {
                    raf.write(Util.getNetworkInfo().getBytes("UTF-8"));
                }
                raf.write(Util.getMemoryInfo().getBytes("UTF-8"));
            }
            catch (Exception e) {
                XCrash.getLogger().e("rongcloud_xcrash", "AnrHandler write log file failed", e);
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.callback != null) {
            try {
                this.callback.onCrash(logFile == null ? null : logFile.getAbsolutePath(), emergency);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getEmergency(Date anrTime, String trace) {
        return Util.getLogHeader(this.startTime, anrTime, "anr", this.appId, this.appVersion) + "pid: " + this.pid + "  >>> " + this.processName + " <<<\n\n" + "--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---" + "\n" + trace + "\n" + "+++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++" + "\n\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTrace(String filepath, long anrTime) {
        BufferedReader br = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        StringBuilder sb = new StringBuilder();
        boolean found = false;
        try {
            String sPid;
            String line;
            br = new BufferedReader(new FileReader(filepath));
            while ((line = br.readLine()) != null) {
                if (!found && line.startsWith("----- pid ")) {
                    String pName;
                    long logTime;
                    Date dLogTime;
                    Matcher matcher = this.patPidTime.matcher(line);
                    if (!matcher.find() || matcher.groupCount() != 2) continue;
                    sPid = matcher.group(1);
                    String sLogTime = matcher.group(2);
                    if (sPid == null || sLogTime == null || this.pid != Integer.parseInt(sPid) || (dLogTime = dateFormat.parse(sLogTime)) == null || Math.abs((logTime = dLogTime.getTime()) - anrTime) > 15000L) continue;
                    line = br.readLine();
                    if (line == null) break;
                    matcher = this.patProcessName.matcher(line);
                    if (!matcher.find() || matcher.groupCount() != 1 || (pName = matcher.group(1)) == null || !pName.equals(this.processName)) continue;
                    found = true;
                    sb.append(line).append('\n');
                    sb.append("Mode: Watching /data/anr/*\n");
                    continue;
                }
                if (!found) continue;
                if (line.startsWith("----- end ")) break;
                sb.append(line).append('\n');
            }
            sPid = sb.toString();
            return sPid;
        }
        catch (Exception ignored) {
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

