/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.xcrash;

import cn.rongcloud.xcrash.Util;
import cn.rongcloud.xcrash.XCrash;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

class FileManager {
    private String placeholderPrefix = "placeholder";
    private String placeholderCleanSuffix = ".clean.xcrash";
    private String placeholderDirtySuffix = ".dirty.xcrash";
    private String logDir = null;
    private int javaLogCountMax = 0;
    private int nativeLogCountMax = 0;
    private int anrLogCountMax = 0;
    private int traceLogCountMax = 1;
    private int placeholderCountMax = 0;
    private int placeholderSizeKb = 0;
    private int delayMs = 0;
    private AtomicInteger unique = new AtomicInteger();
    private static final FileManager instance = new FileManager();

    private FileManager() {
    }

    static FileManager getInstance() {
        return instance;
    }

    void initialize(String logDir, int javaLogCountMax, int nativeLogCountMax, int anrLogCountMax, int placeholderCountMax, int placeholderSizeKb, int delayMs) {
        this.logDir = logDir;
        this.javaLogCountMax = javaLogCountMax;
        this.nativeLogCountMax = nativeLogCountMax;
        this.anrLogCountMax = anrLogCountMax;
        this.placeholderCountMax = placeholderCountMax;
        this.placeholderSizeKb = placeholderSizeKb;
        this.delayMs = delayMs;
        try {
            File dir = new File(logDir);
            if (!dir.exists() || !dir.isDirectory()) {
                return;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            int javaLogCount = 0;
            int nativeLogCount = 0;
            int anrLogCount = 0;
            int traceLogCount = 0;
            int placeholderCleanCount = 0;
            int placeholderDirtyCount = 0;
            for (File file : files) {
                if (!file.isFile()) continue;
                String name = file.getName();
                if (name.startsWith("tombstone_")) {
                    if (name.endsWith(".java.xcrash")) {
                        ++javaLogCount;
                        continue;
                    }
                    if (name.endsWith(".native.xcrash")) {
                        ++nativeLogCount;
                        continue;
                    }
                    if (name.endsWith(".anr.xcrash")) {
                        ++anrLogCount;
                        continue;
                    }
                    if (!name.endsWith(".trace.xcrash")) continue;
                    ++traceLogCount;
                    continue;
                }
                if (!name.startsWith(this.placeholderPrefix + "_")) continue;
                if (name.endsWith(this.placeholderCleanSuffix)) {
                    ++placeholderCleanCount;
                    continue;
                }
                if (!name.endsWith(this.placeholderDirtySuffix)) continue;
                ++placeholderDirtyCount;
            }
            if (javaLogCount <= this.javaLogCountMax && nativeLogCount <= this.nativeLogCountMax && anrLogCount <= this.anrLogCountMax && traceLogCount <= this.traceLogCountMax && placeholderCleanCount == this.placeholderCountMax && placeholderDirtyCount == 0) {
                this.delayMs = -1;
            } else if (javaLogCount > this.javaLogCountMax + 10 || nativeLogCount > this.nativeLogCountMax + 10 || anrLogCount > this.anrLogCountMax + 10 || traceLogCount > this.traceLogCountMax + 10 || placeholderCleanCount > this.placeholderCountMax + 10 || placeholderDirtyCount > 10) {
                this.doMaintain();
                this.delayMs = -1;
            } else if (javaLogCount > this.javaLogCountMax || nativeLogCount > this.nativeLogCountMax || anrLogCount > this.anrLogCountMax || traceLogCount > this.traceLogCountMax || placeholderCleanCount > this.placeholderCountMax || placeholderDirtyCount > 0) {
                this.delayMs = 0;
            }
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager init failed", e);
        }
    }

    void maintain() {
        if (this.logDir == null || this.delayMs < 0) {
            return;
        }
        try {
            String threadName = "xcrash_file_mgr";
            if (this.delayMs == 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        FileManager.this.doMaintain();
                    }
                }, threadName).start();
            } else {
                new Timer(threadName).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        FileManager.this.doMaintain();
                    }
                }, this.delayMs);
            }
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager maintain start failed", e);
        }
    }

    boolean maintainAnr() {
        if (!Util.checkAndCreateDir(this.logDir)) {
            return false;
        }
        File dir = new File(this.logDir);
        try {
            return this.doMaintainTombstoneType(dir, ".anr.xcrash", this.anrLogCountMax);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager maintainAnr failed", e);
            return false;
        }
    }

    File createLogFile(String filePath) {
        if (this.logDir == null) {
            return null;
        }
        if (!Util.checkAndCreateDir(this.logDir)) {
            return null;
        }
        File newFile = new File(filePath);
        File dir = new File(this.logDir);
        File[] cleanFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(FileManager.this.placeholderPrefix + "_") && name.endsWith(FileManager.this.placeholderCleanSuffix);
            }
        });
        if (cleanFiles != null) {
            for (int cleanFilesCount = cleanFiles.length; cleanFilesCount > 0; --cleanFilesCount) {
                File cleanFile = cleanFiles[cleanFilesCount - 1];
                try {
                    if (cleanFile.renameTo(newFile)) {
                        return newFile;
                    }
                }
                catch (Exception e) {
                    XCrash.getLogger().e("rongcloud_xcrash", "FileManager createLogFile by renameTo failed", e);
                }
                cleanFile.delete();
            }
        }
        try {
            if (newFile.createNewFile()) {
                return newFile;
            }
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager createLogFile by createNewFile failed, file already exists");
            return null;
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager createLogFile by createNewFile failed", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean appendText(String logPath, String text) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(logPath, "rws");
            long pos = 0L;
            if (raf.length() > 0L) {
                FileChannel fc = raf.getChannel();
                MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                for (pos = raf.length(); pos > 0L && mbb.get((int)pos - 1) == 0; --pos) {
                }
            }
            raf.seek(pos);
            raf.write(text.getBytes("UTF-8"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager appendText failed", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    boolean recycleLogFile(File logFile) {
        if (logFile == null) {
            return false;
        }
        if (this.logDir == null || this.placeholderCountMax <= 0) {
            try {
                return logFile.delete();
            }
            catch (Exception ignored) {
                return false;
            }
        }
        try {
            File dir = new File(this.logDir);
            File[] cleanFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(FileManager.this.placeholderPrefix + "_") && name.endsWith(FileManager.this.placeholderCleanSuffix);
                }
            });
            if (cleanFiles != null && cleanFiles.length >= this.placeholderCountMax) {
                try {
                    return logFile.delete();
                }
                catch (Exception ignored) {
                    return false;
                }
            }
            String dirtyFilePath = String.format(Locale.US, "%s/%s_%020d%s", this.logDir, this.placeholderPrefix, new Date().getTime() * 1000L + (long)this.getNextUnique(), this.placeholderDirtySuffix);
            File dirtyFile = new File(dirtyFilePath);
            if (!logFile.renameTo(dirtyFile)) {
                try {
                    return logFile.delete();
                }
                catch (Exception ignored) {
                    return false;
                }
            }
            return this.cleanTheDirtyFile(dirtyFile);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager recycleLogFile failed", e);
            try {
                return logFile.delete();
            }
            catch (Exception ignored) {
                return false;
            }
        }
    }

    private void doMaintain() {
        if (!Util.checkAndCreateDir(this.logDir)) {
            return;
        }
        File dir = new File(this.logDir);
        try {
            this.doMaintainTombstone(dir);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager doMaintainTombstone failed", e);
        }
        try {
            this.doMaintainPlaceholder(dir);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager doMaintainPlaceholder failed", e);
        }
    }

    private void doMaintainTombstone(File dir) {
        this.doMaintainTombstoneType(dir, ".native.xcrash", this.nativeLogCountMax);
        this.doMaintainTombstoneType(dir, ".java.xcrash", this.javaLogCountMax);
        this.doMaintainTombstoneType(dir, ".anr.xcrash", this.anrLogCountMax);
        this.doMaintainTombstoneType(dir, ".trace.xcrash", this.traceLogCountMax);
    }

    private boolean doMaintainTombstoneType(File dir, final String logSuffix, int logCountMax) {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("tombstone_") && name.endsWith(logSuffix);
            }
        });
        boolean result = true;
        if (files != null && files.length > logCountMax) {
            if (logCountMax > 0) {
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1.getName().compareTo(f2.getName());
                    }
                });
            }
            for (int i = 0; i < files.length - logCountMax; ++i) {
                if (this.recycleLogFile(files[i])) continue;
                result = false;
            }
        }
        return result;
    }

    private void doMaintainPlaceholder(File dir) {
        File[] cleanFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(FileManager.this.placeholderPrefix + "_") && name.endsWith(FileManager.this.placeholderCleanSuffix);
            }
        });
        if (cleanFiles == null) {
            return;
        }
        File[] dirtyFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(FileManager.this.placeholderPrefix + "_") && name.endsWith(FileManager.this.placeholderDirtySuffix);
            }
        });
        if (dirtyFiles == null) {
            return;
        }
        int i = 0;
        int cleanFilesCount = cleanFiles.length;
        int dirtyFilesCount = dirtyFiles.length;
        while (cleanFilesCount < this.placeholderCountMax) {
            File dirtyFile;
            if (dirtyFilesCount > 0) {
                dirtyFile = dirtyFiles[dirtyFilesCount - 1];
                if (this.cleanTheDirtyFile(dirtyFile)) {
                    ++cleanFilesCount;
                }
                --dirtyFilesCount;
            } else {
                try {
                    dirtyFile = new File(String.format(Locale.US, "%s/%s_%020d%s", this.logDir, this.placeholderPrefix, new Date().getTime() * 1000L + (long)this.getNextUnique(), this.placeholderDirtySuffix));
                    if (dirtyFile.createNewFile() && this.cleanTheDirtyFile(dirtyFile)) {
                        ++cleanFilesCount;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (++i <= this.placeholderCountMax * 2) continue;
        }
        if (i > 0) {
            cleanFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(FileManager.this.placeholderPrefix + "_") && name.endsWith(FileManager.this.placeholderCleanSuffix);
                }
            });
            dirtyFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(FileManager.this.placeholderPrefix + "_") && name.endsWith(FileManager.this.placeholderDirtySuffix);
                }
            });
        }
        if (cleanFiles != null && cleanFiles.length > this.placeholderCountMax) {
            for (i = 0; i < cleanFiles.length - this.placeholderCountMax; ++i) {
                cleanFiles[i].delete();
            }
        }
        if (dirtyFiles != null) {
            for (File dirtyFile : dirtyFiles) {
                dirtyFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanTheDirtyFile(File dirtyFile) {
        FileOutputStream stream = null;
        boolean succeeded = false;
        try {
            byte[] block = new byte[1024];
            Arrays.fill(block, (byte)0);
            long blockCount = this.placeholderSizeKb;
            long dirtyFileSize = dirtyFile.length();
            if (dirtyFileSize > (long)(this.placeholderSizeKb * 1024)) {
                blockCount = dirtyFileSize / 1024L;
                if (dirtyFileSize % 1024L != 0L) {
                    ++blockCount;
                }
            }
            stream = new FileOutputStream(dirtyFile.getAbsoluteFile(), false);
            int i = 0;
            while ((long)i < blockCount) {
                if ((long)(i + 1) == blockCount && dirtyFileSize % 1024L != 0L) {
                    stream.write(block, 0, (int)(dirtyFileSize % 1024L));
                } else {
                    stream.write(block);
                }
                ++i;
            }
            stream.flush();
            String newCleanFilePath = String.format(Locale.US, "%s/%s_%020d%s", this.logDir, this.placeholderPrefix, new Date().getTime() * 1000L + (long)this.getNextUnique(), this.placeholderCleanSuffix);
            succeeded = dirtyFile.renameTo(new File(newCleanFilePath));
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "FileManager cleanTheDirtyFile failed", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!succeeded) {
            try {
                dirtyFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return succeeded;
    }

    private int getNextUnique() {
        int i = this.unique.incrementAndGet();
        if (i >= 999) {
            this.unique.set(0);
        }
        return i;
    }
}

