/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.xcrash;

import android.annotation.SuppressLint;
import android.os.Process;
import android.text.TextUtils;
import cn.rongcloud.xcrash.ActivityMonitor;
import cn.rongcloud.xcrash.AnrHandler;
import cn.rongcloud.xcrash.FileManager;
import cn.rongcloud.xcrash.ICrashCallback;
import cn.rongcloud.xcrash.NativeHandler;
import cn.rongcloud.xcrash.Util;
import cn.rongcloud.xcrash.XCrash;
import java.io.File;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

@SuppressLint(value={"StaticFieldLeak"})
class JavaCrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final JavaCrashHandler instance = new JavaCrashHandler();
    private final Date startTime = new Date();
    private int pid;
    private String processName;
    private String appId;
    private String appVersion;
    private boolean rethrow;
    private String logDir;
    private int logcatSystemLines;
    private int logcatEventsLines;
    private int logcatMainLines;
    private boolean dumpFds;
    private boolean dumpNetworkInfo;
    private boolean dumpAllThreads;
    private int dumpAllThreadsCountMax;
    private String[] dumpAllThreadsWhiteList;
    private ICrashCallback callback;
    private Thread.UncaughtExceptionHandler defaultHandler = null;

    private JavaCrashHandler() {
    }

    static JavaCrashHandler getInstance() {
        return instance;
    }

    void initialize(int pid, String processName, String appId, String appVersion, String logDir, boolean rethrow, int logcatSystemLines, int logcatEventsLines, int logcatMainLines, boolean dumpFds, boolean dumpNetworkInfo, boolean dumpAllThreads, int dumpAllThreadsCountMax, String[] dumpAllThreadsWhiteList, ICrashCallback callback) {
        this.pid = pid;
        this.processName = TextUtils.isEmpty((CharSequence)processName) ? "unknown" : processName;
        this.appId = appId;
        this.appVersion = appVersion;
        this.rethrow = rethrow;
        this.logDir = logDir;
        this.logcatSystemLines = logcatSystemLines;
        this.logcatEventsLines = logcatEventsLines;
        this.logcatMainLines = logcatMainLines;
        this.dumpFds = dumpFds;
        this.dumpNetworkInfo = dumpNetworkInfo;
        this.dumpAllThreads = dumpAllThreads;
        this.dumpAllThreadsCountMax = dumpAllThreadsCountMax;
        this.dumpAllThreadsWhiteList = dumpAllThreadsWhiteList;
        this.callback = callback;
        this.defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        try {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "JavaCrashHandler setDefaultUncaughtExceptionHandler failed", e);
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.defaultHandler != null) {
            Thread.setDefaultUncaughtExceptionHandler(this.defaultHandler);
        }
        try {
            this.handleException(thread, throwable);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "JavaCrashHandler handleException failed", e);
        }
        if (this.rethrow) {
            if (this.defaultHandler != null) {
                this.defaultHandler.uncaughtException(thread, throwable);
            }
        } else {
            ActivityMonitor.getInstance().finishAllActivities();
            Process.killProcess((int)this.pid);
            System.exit(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Thread thread, Throwable throwable) {
        Date crashTime = new Date();
        NativeHandler.getInstance().notifyJavaCrashed();
        AnrHandler.getInstance().notifyJavaCrashed();
        File logFile = null;
        try {
            String logPath = String.format(Locale.US, "%s/%s_%020d_%s__%s%s", this.logDir, "tombstone", this.startTime.getTime() * 1000L, this.appVersion, this.processName, ".java.xcrash");
            logFile = FileManager.getInstance().createLogFile(logPath);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "JavaCrashHandler createLogFile failed", e);
        }
        String emergency = null;
        try {
            emergency = this.getEmergency(crashTime, thread, throwable);
        }
        catch (Exception e) {
            XCrash.getLogger().e("rongcloud_xcrash", "JavaCrashHandler getEmergency failed", e);
        }
        if (logFile != null) {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(logFile, "rws");
                if (emergency != null) {
                    raf.write(emergency.getBytes("UTF-8"));
                }
                emergency = null;
                if (this.logcatMainLines > 0 || this.logcatSystemLines > 0 || this.logcatEventsLines > 0) {
                    raf.write(Util.getLogcat(this.logcatMainLines, this.logcatSystemLines, this.logcatEventsLines).getBytes("UTF-8"));
                }
                if (this.dumpFds) {
                    raf.write(Util.getFds().getBytes("UTF-8"));
                }
                if (this.dumpNetworkInfo) {
                    raf.write(Util.getNetworkInfo().getBytes("UTF-8"));
                }
                raf.write(Util.getMemoryInfo().getBytes("UTF-8"));
                raf.write(("foreground:\n" + (ActivityMonitor.getInstance().isApplicationForeground() ? "yes" : "no") + "\n\n").getBytes("UTF-8"));
                if (this.dumpAllThreads) {
                    raf.write(this.getOtherThreadsInfo(thread).getBytes("UTF-8"));
                }
            }
            catch (Exception e) {
                XCrash.getLogger().e("rongcloud_xcrash", "JavaCrashHandler write log file failed", e);
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.callback != null) {
            try {
                this.callback.onCrash(logFile == null ? null : logFile.getAbsolutePath(), emergency);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getLibInfo(List<String> libPathList) {
        StringBuilder sb = new StringBuilder();
        for (String libPath : libPathList) {
            File libFile = new File(libPath);
            if (libFile.exists() && libFile.isFile()) {
                String md5 = Util.getFileMD5(libFile);
                SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
                Date lastTime = new Date(libFile.lastModified());
                sb.append("    ").append(libPath).append("(BuildId: unknown. FileSize: ").append(libFile.length()).append(". LastModified: ").append(timeFormatter.format(lastTime)).append(". MD5: ").append(md5).append(")\n");
                continue;
            }
            sb.append("    ").append(libPath).append(" (Not found)\n");
        }
        String libInfo = sb.toString();
        return libInfo;
    }

    private String getBuildId(String stktrace) {
        String buildId = "";
        ArrayList<String> libPathList = new ArrayList<String>();
        if (stktrace.contains("UnsatisfiedLinkError")) {
            String[] tempLibPathStr;
            String libInfo = null;
            for (String libPathStr : tempLibPathStr = stktrace.split("\"")) {
                if (libPathStr.isEmpty() || !libPathStr.endsWith(".so")) continue;
                libPathList.add(libPathStr);
                String libName = libPathStr.substring(libPathStr.lastIndexOf(47) + 1);
                libPathList.add(XCrash.nativeLibDir + "/" + libName);
                libPathList.add("/vendor/lib/" + libName);
                libPathList.add("/vendor/lib64/" + libName);
                libPathList.add("/system/lib/" + libName);
                libPathList.add("/system/lib64/" + libName);
                libInfo = this.getLibInfo(libPathList);
            }
            buildId = "build id:\n" + libInfo + "\n";
        }
        return buildId;
    }

    private String getEmergency(Date crashTime, Thread thread, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String stacktrace = sw.toString();
        return Util.getLogHeader(this.startTime, crashTime, "java", this.appId, this.appVersion) + "pid: " + this.pid + ", tid: " + Process.myTid() + ", name: " + thread.getName() + "  >>> " + this.processName + " <<<\n\njava stacktrace:\n" + stacktrace + "\n" + this.getBuildId(stacktrace);
    }

    private String getOtherThreadsInfo(Thread crashedThread) {
        int thdMatchedRegex = 0;
        int thdIgnoredByLimit = 0;
        int thdDumped = 0;
        ArrayList<Pattern> whiteList = null;
        if (this.dumpAllThreadsWhiteList != null) {
            whiteList = new ArrayList<Pattern>();
            for (String s : this.dumpAllThreadsWhiteList) {
                try {
                    whiteList.add(Pattern.compile(s));
                }
                catch (Exception e) {
                    XCrash.getLogger().w("rongcloud_xcrash", "JavaCrashHandler pattern compile failed", e);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            Thread thd = entry.getKey();
            StackTraceElement[] stacktrace = entry.getValue();
            if (thd.getName().equals(crashedThread.getName()) || whiteList != null && !this.matchThreadName(whiteList, thd.getName())) continue;
            ++thdMatchedRegex;
            if (this.dumpAllThreadsCountMax > 0 && thdDumped >= this.dumpAllThreadsCountMax) {
                ++thdIgnoredByLimit;
                continue;
            }
            sb.append("--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---\n");
            sb.append("pid: ").append(this.pid).append(", tid: ").append(thd.getId()).append(", name: ").append(thd.getName()).append("  >>> ").append(this.processName).append(" <<<\n");
            sb.append("\n");
            sb.append("java stacktrace:\n");
            for (StackTraceElement element : stacktrace) {
                sb.append("    at ").append(element.toString()).append("\n");
            }
            sb.append("\n");
            ++thdDumped;
        }
        if (map.size() > 1) {
            if (thdDumped == 0) {
                sb.append("--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---\n");
            }
            sb.append("total JVM threads (exclude the crashed thread): ").append(map.size() - 1).append("\n");
            if (whiteList != null) {
                sb.append("JVM threads matched whitelist: ").append(thdMatchedRegex).append("\n");
            }
            if (this.dumpAllThreadsCountMax > 0) {
                sb.append("JVM threads ignored by max count limit: ").append(thdIgnoredByLimit).append("\n");
            }
            sb.append("dumped JVM threads:").append(thdDumped).append("\n");
            sb.append("+++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++\n");
        }
        return sb.toString();
    }

    private boolean matchThreadName(ArrayList<Pattern> whiteList, String threadName) {
        for (Pattern pat : whiteList) {
            if (!pat.matcher(threadName).matches()) continue;
            return true;
        }
        return false;
    }
}

