/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.base;

import android.content.Context;
import android.os.IBinder;
import io.rong.imlib.IChatRoomEventListener;
import io.rong.imlib.IChatRoomHistoryMessageCallback;
import io.rong.imlib.IChatRoomOperationCallback;
import io.rong.imlib.IDataByBatchListener;
import io.rong.imlib.IMLibExtensionModuleIPC;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.ISetChatRoomKVCallbackListener;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.KVStatusDataByBatchListener;
import io.rong.imlib.NativeObject;
import io.rong.imlib.chatroom.base.ChatRoomNativeClient;
import java.util.List;
import java.util.Map;

public class ChatRoomExtensionIPCModule
implements IMLibExtensionModuleIPC {
    private static final String TAG = "ChatRoomExtensionModuleIPCManager";

    public static ChatRoomExtensionIPCModule getInstance() {
        return SingletonHolder.sInstance;
    }

    private ChatRoomExtensionIPCModule() {
    }

    public void onIPCProcessInit(Context context, NativeObject nativeObject) {
        ChatRoomNativeClient.getInstance().init(context, nativeObject);
    }

    public Map onMethodCall(String className, String methodKey, Map param, NativeObject nativeObject) {
        if (methodKey.equals("joinExistChatRoom")) {
            String id = (String)param.get("id");
            int defMessageCount = (Integer)param.get("defMessageCount");
            IChatRoomOperationCallback callback = IChatRoomOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
            boolean keepMsg = (Boolean)param.get("keepMsg");
            int joinMode = (Integer)param.get("joinMode");
            ChatRoomNativeClient.getInstance().joinExistChatRoom(id, defMessageCount, callback, keepMsg, nativeObject, joinMode);
        } else {
            if (methodKey.equals("getJoinMultiChatRoomEnable")) {
                return ChatRoomNativeClient.getInstance().getJoinMultiChatRoomEnable();
            }
            if (methodKey.equals("reJoinChatRoom")) {
                String id = (String)param.get("id");
                int defMessageCount = (Integer)param.get("defMessageCount");
                IChatRoomOperationCallback callback = IChatRoomOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                int joinMode = (Integer)param.get("joinMode");
                ChatRoomNativeClient.getInstance().reJoinChatRoom(id, defMessageCount, callback, nativeObject, joinMode);
            } else if (methodKey.equals("joinChatRoom")) {
                String id = (String)param.get("id");
                int defMessageCount = (Integer)param.get("defMessageCount");
                IChatRoomOperationCallback callback = IChatRoomOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                int joinMode = (Integer)param.get("joinMode");
                ChatRoomNativeClient.getInstance().joinChatRoom(id, defMessageCount, callback, nativeObject, joinMode);
            } else if (methodKey.equals("bindChatRoom4RTCRoom")) {
                String chatRoomId = (String)param.get("chatRoomId");
                String rtcRoomId = (String)param.get("rtcRoomId");
                IChatRoomOperationCallback callback = IChatRoomOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().bindChatRoom4RTCRoom(chatRoomId, rtcRoomId, callback, nativeObject);
            } else if (methodKey.equals("quitChatRoom")) {
                String id = (String)param.get("id");
                IOperationCallback callback = IOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().quitChatRoom(id, callback, nativeObject);
            } else if (methodKey.equals("deleteChatRoomEntry")) {
                String key = (String)param.get("key");
                String value = (String)param.get("value");
                String chatRoomId = (String)param.get("chatRoomId");
                boolean sendNotification = (Boolean)param.get("sendNotification");
                String notificationExtra = (String)param.get("notificationExtra");
                boolean autoDelete = (Boolean)param.get("autoDelete");
                boolean isOverWrite = (Boolean)param.get("isOverWrite");
                IOperationCallback callback = IOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().deleteChatRoomEntry(key, value, chatRoomId, sendNotification, notificationExtra, autoDelete, isOverWrite, callback, nativeObject);
            } else if (methodKey.equals("setChatRoomEntry")) {
                String key = (String)param.get("key");
                String value = (String)param.get("value");
                String chatRoomId = (String)param.get("chatRoomId");
                boolean sendNotification = (Boolean)param.get("sendNotification");
                String notificationExtra = (String)param.get("notificationExtra");
                boolean autoDelete = (Boolean)param.get("autoDelete");
                boolean isOverWrite = (Boolean)param.get("isOverWrite");
                IOperationCallback callback = IOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().setChatRoomEntry(key, value, chatRoomId, sendNotification, notificationExtra, autoDelete, isOverWrite, callback, nativeObject);
            } else if (methodKey.equals("getChatRoomEntry")) {
                String key = (String)param.get("key");
                String chatRoomId = (String)param.get("chatRoomId");
                IStringCallback callback = IStringCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().getChatRoomEntry(chatRoomId, key, callback, nativeObject);
            } else if (methodKey.equals("getAllChatRoomEntries")) {
                String chatRoomId = (String)param.get("chatRoomId");
                IDataByBatchListener callback = IDataByBatchListener.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().getAllChatRoomEntries(chatRoomId, callback, nativeObject);
            } else if (methodKey.equals("setKvStatusListener")) {
                KVStatusDataByBatchListener callback = KVStatusDataByBatchListener.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().setKvStatusListener(callback);
            } else if (methodKey.equals("getChatRoomInfo")) {
                String id = (String)param.get("id");
                int count = (Integer)param.get("count");
                int order = (Integer)param.get("order");
                IResultCallback callback = IResultCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().getChatRoomInfo(id, count, order, callback, nativeObject);
            } else if (methodKey.equals("getChatroomHistoryMessages")) {
                String targetId = (String)param.get("targetId");
                long recordTime = (Long)param.get("recordTime");
                int count = (Integer)param.get("count");
                int order = (Integer)param.get("order");
                IChatRoomHistoryMessageCallback callback = IChatRoomHistoryMessageCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().getChatRoomHistoryMessages(targetId, recordTime, count, order, callback, nativeObject);
            } else if (methodKey.equals("setChatRoomEventListener")) {
                IChatRoomEventListener listener = IChatRoomEventListener.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().setChatRoomEventListener(listener);
            } else if (methodKey.equals("setChatRoomEntries")) {
                String chatRoomId = (String)param.get("chatRoomId");
                Map chatRoomEntryMap = (Map)param.get("chatRoomEntries");
                boolean autoDelete = (Boolean)param.get("autoDelete");
                boolean overWrite = (Boolean)param.get("overWrite");
                ISetChatRoomKVCallbackListener callback = ISetChatRoomKVCallbackListener.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().setChatRoomEntries(chatRoomId, chatRoomEntryMap, autoDelete, overWrite, callback, nativeObject);
            } else if (methodKey.equals("deleteChatRoomEntries")) {
                String chatRoomId = (String)param.get("chatRoomId");
                boolean force = (Boolean)param.get("overWrite");
                List chatRoomEntryList = (List)param.get("chatRoomEntries");
                ISetChatRoomKVCallbackListener callback = ISetChatRoomKVCallbackListener.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
                ChatRoomNativeClient.getInstance().deleteChatRoomEntries(chatRoomId, chatRoomEntryList, force, callback, nativeObject);
            } else if (methodKey.equals("clearChatRoomMessagesAndKV")) {
                String chatRoomId = (String)param.get("chatRoomId");
                ChatRoomNativeClient.getInstance().clearChatRoomMessagesAndKV(chatRoomId, nativeObject);
            }
        }
        return null;
    }

    private static class SingletonHolder {
        static ChatRoomExtensionIPCModule sInstance = new ChatRoomExtensionIPCModule();

        private SingletonHolder() {
        }
    }
}

