/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.base;

import android.content.Context;
import io.rong.imlib.IHandler;
import io.rong.imlib.IMLibExtensionModule;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.chatroom.base.RongChatRoomClient;
import io.rong.imlib.chatroom.base.RongChatRoomClientImpl;
import io.rong.imlib.chatroom.message.ChatRoomKVNotiMessage;
import io.rong.imlib.chatroom.message.ChatRoomMemberActionMessage;
import io.rong.imlib.common.ExecutorFactory;
import io.rong.imlib.model.ChatRoomMemberAction;
import io.rong.imlib.model.HardwareResource;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.List;

public class ChatRoomExtensionModule
implements IMLibExtensionModule {
    private static final String TAG = "ChatRoomExtensionModuleManager";

    public static ChatRoomExtensionModule getInstance() {
        return SingletonHolder.sInstance;
    }

    private ChatRoomExtensionModule() {
    }

    public void onCreate(Context context, String appKey) {
    }

    public void onLogin(String userId, String token) {
    }

    public boolean onReceiveMessage(final Message message, int left, boolean offline, int cmdLeft) {
        if (message.getContent() instanceof ChatRoomMemberActionMessage) {
            if (RongChatRoomClient.getChatRoomMemberListener() == null) {
                return true;
            }
            ChatRoomMemberActionMessage memberChangeMessage = (ChatRoomMemberActionMessage)message.getContent();
            final List<ChatRoomMemberAction> chatRoomMemberActions = memberChangeMessage.getChatRoomMembers();
            if (chatRoomMemberActions == null || chatRoomMemberActions.isEmpty()) {
                return true;
            }
            ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                @Override
                public void run() {
                    RongChatRoomClient.getChatRoomMemberListener().onMemberChange(chatRoomMemberActions, message.getTargetId());
                }
            });
            return true;
        }
        return false;
    }

    public List<Class<? extends MessageContent>> getMessageContentList() {
        ArrayList<Class<? extends MessageContent>> messageContentList = new ArrayList<Class<? extends MessageContent>>();
        messageContentList.add(ChatRoomKVNotiMessage.class);
        messageContentList.add(ChatRoomMemberActionMessage.class);
        return messageContentList;
    }

    public List<Class<? extends MessageContent>> getCmdMessageContentList() {
        ArrayList<Class<? extends MessageContent>> messageContentList = new ArrayList<Class<? extends MessageContent>>();
        messageContentList.add(ChatRoomMemberActionMessage.class);
        return messageContentList;
    }

    public void onConnectStatusChanged(IRongCoreListener.ConnectionStatusListener.ConnectionStatus status) {
        if (status.equals((Object)IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
            ((RongChatRoomClientImpl)RongChatRoomClient.getInstance()).reJoinChatRoomWithCache();
        }
    }

    public void onLogout() {
        ((RongChatRoomClientImpl)RongChatRoomClient.getInstance()).onDisconnect();
    }

    public void onDisconnect() {
        ((RongChatRoomClientImpl)RongChatRoomClient.getInstance()).onDisconnect();
    }

    public void onDestroy() {
    }

    public boolean onRequestHardwareResource(HardwareResource.ResourceType resourceType) {
        return false;
    }

    public void onServiceConnected(Context context, IHandler stub, IRongCoreListener.OnReceiveMessageListener listener) {
        RongChatRoomClientImpl.getInstanceForInterior().init();
    }

    private static class SingletonHolder {
        static ChatRoomExtensionModule sInstance = new ChatRoomExtensionModule();

        private SingletonHolder() {
        }
    }
}

