/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.base;

import android.os.RemoteException;
import io.rong.imlib.IChatRoomEventListener;
import io.rong.imlib.IChatRoomHistoryMessageCallback;
import io.rong.imlib.IChatRoomOperationCallback;
import io.rong.imlib.IDataByBatchListener;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.ISetChatRoomKVCallbackListener;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.KVStatusDataByBatchListener;
import io.rong.imlib.RongCoreClient;
import io.rong.imlib.chatroom.base.ChatRoomExtensionIPCModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ChatRoomHelper {
    private ChatRoomHelper() {
    }

    public static ChatRoomHelper getInstance() {
        return SingletonHolder.sInstance;
    }

    public void joinExistChatRoom(String id, int defMessageCount, IChatRoomOperationCallback callback, boolean keepMsg, int joinMode) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("defMessageCount", defMessageCount);
        param.put("callback", callback);
        param.put("keepMsg", keepMsg);
        param.put("joinMode", joinMode);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "joinExistChatRoom", param);
    }

    public void reJoinChatRoom(String id, int defMessageCount, IChatRoomOperationCallback callback, int joinMode) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("defMessageCount", defMessageCount);
        param.put("callback", callback);
        param.put("joinMode", joinMode);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "reJoinChatRoom", param);
    }

    public void joinChatRoom(String id, int defMessageCount, IChatRoomOperationCallback callback, int joinMode) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("defMessageCount", defMessageCount);
        param.put("callback", callback);
        param.put("joinMode", joinMode);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "joinChatRoom", param);
    }

    public void bindChatRoomWithRTCRoom(String chatRoom, String rtcRoom, IChatRoomOperationCallback callback) throws RemoteException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("chatRoomId", chatRoom);
        param.put("rtcRoomId", rtcRoom);
        param.put("callback", (String)callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "bindChatRoom4RTCRoom", param);
    }

    public boolean getJoinMultiChatRoomEnable() throws RemoteException {
        HashMap param = new HashMap();
        Map resultMap = RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "getJoinMultiChatRoomEnable", param);
        boolean result = false;
        if (resultMap != null) {
            result = (Boolean)resultMap.get("result");
        }
        return result;
    }

    public void quitChatRoom(String id, IOperationCallback callback) throws RemoteException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", id);
        param.put("callback", (String)callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "quitChatRoom", param);
    }

    public void deleteChatRoomEntry(String key, String value, String chatRoomId, boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, IOperationCallback callback) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("key", key);
        param.put("value", value);
        param.put("chatRoomId", chatRoomId);
        param.put("sendNotification", sendNotification);
        param.put("notificationExtra", notificationExtra);
        param.put("autoDelete", autoDelete);
        param.put("isOverWrite", isOverWrite);
        param.put("callback", callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "deleteChatRoomEntry", param);
    }

    public void setChatRoomEntry(String key, String value, String chatRoomId, boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, IOperationCallback callback) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("key", key);
        param.put("value", value);
        param.put("chatRoomId", chatRoomId);
        param.put("sendNotification", sendNotification);
        param.put("notificationExtra", notificationExtra);
        param.put("autoDelete", autoDelete);
        param.put("isOverWrite", isOverWrite);
        param.put("callback", callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "setChatRoomEntry", param);
    }

    public void getChatRoomEntry(String chatRoomId, String key, IStringCallback callback) throws RemoteException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("key", key);
        param.put("chatRoomId", chatRoomId);
        param.put("callback", (String)callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "getChatRoomEntry", param);
    }

    public void getAllChatRoomEntries(String chatRoomId, IDataByBatchListener callback) throws RemoteException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("chatRoomId", chatRoomId);
        param.put("callback", (String)callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "getAllChatRoomEntries", param);
    }

    public void setKvStatusListener(KVStatusDataByBatchListener callback) throws RemoteException {
        HashMap<String, KVStatusDataByBatchListener> param = new HashMap<String, KVStatusDataByBatchListener>();
        param.put("callback", callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "setKvStatusListener", param);
    }

    public void getChatRoomInfo(String id, int count, int order, IResultCallback callback) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("count", count);
        param.put("order", order);
        param.put("callback", callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "getChatRoomInfo", param);
    }

    public void getChatroomHistoryMessages(String targetId, long recordTime, int count, int order, IChatRoomHistoryMessageCallback callback) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("targetId", targetId);
        param.put("recordTime", recordTime);
        param.put("count", count);
        param.put("order", order);
        param.put("callback", callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "getChatroomHistoryMessages", param);
    }

    public void setChatRoomEventListener(IChatRoomEventListener listener) throws RemoteException {
        HashMap<String, IChatRoomEventListener> param = new HashMap<String, IChatRoomEventListener>();
        param.put("callback", listener);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "setChatRoomEventListener", param);
    }

    public void setChatRoomEntries(String chatRoomId, Map<String, String> chatRoomEntryMap, boolean autoDelete, boolean overWrite, ISetChatRoomKVCallbackListener callback) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("chatRoomId", chatRoomId);
        param.put("chatRoomEntries", chatRoomEntryMap);
        param.put("autoDelete", autoDelete);
        param.put("overWrite", overWrite);
        param.put("callback", callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "setChatRoomEntries", param);
    }

    public void deleteChatRoomEntries(String roomId, List<String> chatRoomEntryList, boolean force, ISetChatRoomKVCallbackListener.Stub callback) throws RemoteException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("chatRoomId", roomId);
        param.put("chatRoomEntries", chatRoomEntryList);
        param.put("overWrite", force);
        param.put("callback", callback);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "deleteChatRoomEntries", param);
    }

    public void clearChatRoomMessagesAndKV(String roomId) throws RemoteException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("chatRoomId", roomId);
        RongCoreClient.getInstance().doMethod(ChatRoomExtensionIPCModule.class.getName(), "clearChatRoomMessagesAndKV", param);
    }

    private static class SingletonHolder {
        static ChatRoomHelper sInstance = new ChatRoomHelper();

        private SingletonHolder() {
        }
    }
}

