/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.SystemUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.common.fwlog.FwLogUtil;
import io.rong.imlib.IChatRoomEventListener;
import io.rong.imlib.IChatRoomHistoryMessageCallback;
import io.rong.imlib.IChatRoomOperationCallback;
import io.rong.imlib.IDataByBatchListener;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.ISetChatRoomKVCallbackListener;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.KVStatusDataByBatchListener;
import io.rong.imlib.MessageTag;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongRuntimeException;
import io.rong.imlib.chatroom.message.ChatRoomKVNotiMessage;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.ChatRoomMemberInfo;
import io.rong.imlib.model.ChatroomStatus;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.RemoteModelWrap;
import io.rong.imlib.model.RongListWrap;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationClient;
import io.rong.imlib.navigation.NetDetection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class ChatRoomNativeClient {
    private static final String TAG = "ChatRoomNativeClient";
    private ConcurrentHashMap<String, Boolean> chatRoomStatusMap;
    private ScheduledThreadPoolExecutor executorService;
    private KVStatusListener mKVStatusListener;
    private IChatRoomEventListener mChatRoomEventListener;
    private Context mContext;

    ChatRoomNativeClient() {
    }

    public static ChatRoomNativeClient getInstance() {
        return NativeClientHolder.client;
    }

    public void init(Context context, NativeObject nativeObject) {
        this.chatRoomStatusMap = new ConcurrentHashMap();
        this.mContext = context;
        this.initThreadPool();
        this.setChatRoomStatusNotificationListener(nativeObject);
        this.initChatRoomEventListener(nativeObject);
    }

    private void initThreadPool() {
        this.executorService = new ScheduledThreadPoolExecutor(1, NativeClient.threadFactory((String)"Get ChatRoomEntry", (boolean)false));
        this.executorService.setKeepAliveTime(60L, TimeUnit.SECONDS);
        this.executorService.allowCoreThreadTimeOut(true);
    }

    private void setChatRoomStatusNotificationListener(final NativeObject nativeObject) {
        if (nativeObject == null) {
            throw new RongRuntimeException("NativeClient has not been initialized yet!");
        }
        nativeObject.SetChatRoomStatusNotificationListener(new NativeObject.StatusNotificationListener(){

            public void OnStatusChanged(final String roomId) {
                ChatRoomNativeClient.this.chatRoomStatusMap.put(roomId, true);
                if (ChatRoomNativeClient.this.mKVStatusListener != null) {
                    ChatRoomNativeClient.this.mKVStatusListener.onChatRoomKVStatusSync(roomId);
                }
                ChatRoomNativeClient.this.getAllChatRoomStatus(roomId, new NativeClient.IResultCallback<HashMap<String, String>>(){

                    public void onSuccess(HashMap<String, String> stringStringHashMap) {
                        if (ChatRoomNativeClient.this.mKVStatusListener != null && stringStringHashMap != null) {
                            io.rong.common.rlog.RLog.d((String)ChatRoomNativeClient.TAG, (String)("OnKVChanged changeInfo: " + stringStringHashMap));
                            ChatRoomNativeClient.this.mKVStatusListener.onChatRoomKVStatusChange(roomId, stringStringHashMap);
                        }
                    }

                    public void onError(int code) {
                        io.rong.common.rlog.RLog.d((String)ChatRoomNativeClient.TAG, (String)("OnKVChanged sync error: " + code));
                    }
                }, nativeObject);
            }

            public void OnKVChanged(ChatroomStatus[] chatRoomStatus) {
                if (chatRoomStatus != null) {
                    io.rong.common.rlog.RLog.d((String)ChatRoomNativeClient.TAG, (String)("OnKVChanged changeInfo: " + Arrays.toString(chatRoomStatus)));
                    if (ChatRoomNativeClient.this.mKVStatusListener != null) {
                        HashMap<String, String> changeMap = new HashMap<String, String>();
                        HashMap<String, String> removeMap = new HashMap<String, String>();
                        for (ChatroomStatus status : chatRoomStatus) {
                            if (status.getIsDelete()) {
                                removeMap.put(status.getKey(), status.getValue());
                                continue;
                            }
                            changeMap.put(status.getKey(), status.getValue());
                        }
                        String roomId = chatRoomStatus[0].getRoomId();
                        if (changeMap.size() > 0) {
                            ChatRoomNativeClient.this.mKVStatusListener.onChatRoomKVStatusChange(roomId, changeMap);
                        }
                        if (removeMap.size() > 0) {
                            ChatRoomNativeClient.this.mKVStatusListener.onChatRoomKVStatusRemove(roomId, removeMap);
                        }
                    }
                }
            }
        });
    }

    public void joinExistChatRoom(final String id, int defMessageCount, final IChatRoomOperationCallback callback, boolean keepMsg, NativeObject nativeObject, int joinMode) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_JOIN_CHATROOM_T.getTag(), (String)"room_id|existed", (Object[])new Object[]{id, true});
        try {
            if (nativeObject == null) {
                return;
            }
            if (this.chatRoomStatusMap.get(id) == null) {
                this.chatRoomStatusMap.put(id, false);
            }
            nativeObject.JoinExistingChatroom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback != null) {
                        try {
                            if (code == IRongCoreEnum.CoreErrorCode.RC_CHATROOM_RESET.code && ChatRoomNativeClient.this.chatRoomStatusMap != null && ChatRoomNativeClient.this.chatRoomStatusMap.containsKey(id)) {
                                ChatRoomNativeClient.this.chatRoomStatusMap.put(id, false);
                            }
                            if (code == 0 || code == IRongCoreEnum.CoreErrorCode.RC_CHATROOM_RESET.code) {
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{code, id});
                                callback.onComplete(code);
                            } else {
                                ChatRoomNativeClient.this.detectNaviIfNeedByChatroom(code);
                                FwLog.write((int)1, (int)1, (String)FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{code, id});
                                callback.onFailure(code);
                            }
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            }, keepMsg, joinMode);
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void reJoinChatRoom(final String id, int defMessageCount, final IChatRoomOperationCallback callback, NativeObject nativeObject, int joinMode) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_REJOIN_CHATROOM_T.getTag(), (String)"room_id", (Object[])new Object[]{id});
        try {
            if (this.chatRoomStatusMap.get(id) == null) {
                this.chatRoomStatusMap.put(id, false);
            }
            nativeObject.JoinChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, true, new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback != null) {
                        try {
                            if (code == IRongCoreEnum.CoreErrorCode.RC_CHATROOM_RESET.code && ChatRoomNativeClient.this.chatRoomStatusMap != null && ChatRoomNativeClient.this.chatRoomStatusMap.containsKey(id)) {
                                ChatRoomNativeClient.this.chatRoomStatusMap.put(id, false);
                            }
                            if (code == 0 || code == IRongCoreEnum.CoreErrorCode.RC_CHATROOM_RESET.code) {
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_REJOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{code, id});
                                io.rong.common.rlog.RLog.d((String)ChatRoomNativeClient.TAG, (String)("reJoinChatRoom " + id));
                                callback.onComplete(code);
                            } else {
                                ChatRoomNativeClient.this.detectNaviIfNeedByChatroom(code);
                                FwLog.write((int)1, (int)1, (String)FwLog.LogTag.L_REJOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{code, id});
                                io.rong.common.rlog.RLog.e((String)ChatRoomNativeClient.TAG, (String)("reJoinChatRoom " + code));
                                callback.onFailure(code);
                            }
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            }, joinMode);
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void joinChatRoom(final String id, int defMessageCount, final IChatRoomOperationCallback callback, NativeObject nativeObject, int joinMode) {
        RLog.d((String)TAG, (String)("joinChatRoom. id:" + id));
        try {
            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_JOIN_CHATROOM_T.getTag(), (String)"room_id|existed", (Object[])new Object[]{id, false});
            if (this.chatRoomStatusMap.get(id) == null) {
                this.chatRoomStatusMap.put(id, false);
            }
            nativeObject.JoinChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, false, new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback != null) {
                        try {
                            if (code == IRongCoreEnum.CoreErrorCode.RC_CHATROOM_RESET.code && ChatRoomNativeClient.this.chatRoomStatusMap != null && ChatRoomNativeClient.this.chatRoomStatusMap.containsKey(id)) {
                                ChatRoomNativeClient.this.chatRoomStatusMap.put(id, false);
                            }
                            if (code == 0 || code == IRongCoreEnum.CoreErrorCode.RC_CHATROOM_RESET.code) {
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{code, id});
                                callback.onComplete(code);
                            } else {
                                ChatRoomNativeClient.this.detectNaviIfNeedByChatroom(code);
                                FwLog.write((int)1, (int)1, (String)FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{code, id});
                                callback.onFailure(code);
                            }
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            }, joinMode);
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void bindChatRoom4RTCRoom(final String chatRoom, final String rtcRoom, final IChatRoomOperationCallback callback, NativeObject nativeObject) {
        RLog.d((String)TAG, (String)("bindChatRoom4RTCRoom. id:" + chatRoom + " rtcRoomId:" + rtcRoom));
        try {
            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_BIND_CHATROOM_4_RTC_ROOM_T.getTag(), (String)"room_id|rtc_room_id", (Object[])new Object[]{chatRoom, rtcRoom});
            if (this.chatRoomStatusMap.get(chatRoom) == null) {
                this.chatRoomStatusMap.put(chatRoom, false);
            }
            nativeObject.BindRTCRoomForChatroom(chatRoom, rtcRoom, new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback != null) {
                        try {
                            if (code == 0) {
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_BIND_CHATROOM_4_RTC_ROOM_R.getTag(), (String)"room_id|rtc_room_id", (Object[])new Object[]{chatRoom, rtcRoom});
                                callback.onComplete(code);
                            } else {
                                FwLog.write((int)1, (int)1, (String)FwLog.LogTag.L_BIND_CHATROOM_4_RTC_ROOM_R.getTag(), (String)"room_id|rtc_room_id|failed code", (Object[])new Object[]{chatRoom, rtcRoom, code});
                                callback.onFailure(code);
                            }
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public Map getJoinMultiChatRoomEnable() {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        try {
            boolean result = NavigationCacheHelper.isJoinMChatroomEnabled((Context)NativeClient.getApplicationContext());
            resultMap.put("result", result);
            return resultMap;
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
            resultMap.put("result", false);
            return resultMap;
        }
    }

    public void quitChatRoom(final String id, final IOperationCallback callback, NativeObject nativeObject) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_QUIT_CHATROOM_T.getTag(), (String)"room_id", (Object[])new Object[]{id});
        try {
            io.rong.common.rlog.RLog.d((String)TAG, (String)("quitChatRoom id: " + id));
            this.chatRoomStatusMap.remove(id);
            nativeObject.QuitChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback != null) {
                        try {
                            if (code == 0) {
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_QUIT_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{0, id});
                                callback.onComplete();
                            } else {
                                FwLog.write((int)1, (int)1, (String)FwLog.LogTag.L_QUIT_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{code, id});
                                callback.onFailure(code);
                            }
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            });
            this.clearMessages(Conversation.ConversationType.CHATROOM, id, nativeObject);
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void deleteChatRoomEntry(final String key, String value, final String chatRoomId, boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, final IOperationCallback callback, NativeObject nativeObject) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_REMOVE_CHATROOM_KV_T.getTag(), (String)"roomId|key|value|notify|auto_del|isOverWrite", (Object[])new Object[]{chatRoomId, key, value, sendNotification, autoDelete, isOverWrite});
        try {
            if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
                FwLog.write((int)2, (int)1, (String)FwLog.LogTag.L_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
                if (callback != null) {
                    try {
                        callback.onFailure(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code);
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
                return;
            }
            if (!NavigationCacheHelper.isKvStorageEnabled((Context)NativeClient.getApplicationContext())) {
                FwLog.write((int)2, (int)1, (String)FwLog.LogTag.L_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.code});
                if (callback != null) {
                    try {
                        callback.onFailure(IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.getValue());
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
                return;
            }
            NativeObject.StatusData statusData = new NativeObject.StatusData();
            statusData.setKey(key);
            statusData.setValue(value);
            statusData.setAutoDelete(autoDelete);
            statusData.setOverwrite(isOverWrite);
            NativeObject.StatusNotification statusNotification = new NativeObject.StatusNotification();
            statusNotification.setAttributeFlag(0);
            statusNotification.setConversationType(Conversation.ConversationType.CHATROOM.getValue());
            statusNotification.setMessageContent(new String(ChatRoomKVNotiMessage.obtain(key, value, ChatRoomKVNotiMessage.NotificationType.TYPE_DELETE_KEY, notificationExtra).encode()));
            statusNotification.setNotifyAll(sendNotification);
            statusNotification.setObjectName(ChatRoomKVNotiMessage.class.getAnnotation(MessageTag.class).value());
            nativeObject.DeleteChatRoomStatus(chatRoomId, statusData, statusNotification, new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long sendTime) {
                    if (callback != null) {
                        try {
                            if (code == 0) {
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, 0});
                                callback.onComplete();
                            } else {
                                FwLog.write((int)2, (int)1, (String)FwLog.LogTag.L_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, code});
                                callback.onFailure(code);
                            }
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            io.rong.common.rlog.RLog.e((String)TAG, (String)"deleteChatRoomEntry ", (Throwable)e);
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void setChatRoomEntry(final String key, String value, final String chatRoomId, boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, final IOperationCallback callback, NativeObject nativeObject) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_SET_CHATROOM_KV_T.getTag(), (String)"roomId|key|value|notify|auto_del|isOverWrite", (Object[])new Object[]{chatRoomId, key, value, sendNotification, autoDelete, isOverWrite});
        try {
            if (!NavigationCacheHelper.isKvStorageEnabled((Context)NativeClient.getApplicationContext())) {
                FwLog.write((int)2, (int)1, (String)FwLog.LogTag.L_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.code});
                if (callback != null) {
                    try {
                        callback.onFailure(IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.getValue());
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                    return;
                }
            }
            NativeObject.StatusData statusData = new NativeObject.StatusData();
            statusData.setKey(key);
            statusData.setValue(value);
            statusData.setAutoDelete(autoDelete);
            statusData.setOverwrite(isOverWrite);
            NativeObject.StatusNotification statusNotification = new NativeObject.StatusNotification();
            statusNotification.setAttributeFlag(0);
            statusNotification.setConversationType(Conversation.ConversationType.CHATROOM.getValue());
            statusNotification.setMessageContent(new String(ChatRoomKVNotiMessage.obtain(key, value, ChatRoomKVNotiMessage.NotificationType.TYPE_SET_KEY, notificationExtra).encode()));
            statusNotification.setNotifyAll(sendNotification);
            statusNotification.setObjectName(ChatRoomKVNotiMessage.class.getAnnotation(MessageTag.class).value());
            nativeObject.SetChatRoomStatus(chatRoomId, statusData, statusNotification, new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long sendTime) {
                    if (callback != null) {
                        try {
                            if (code == 0) {
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, code});
                                callback.onComplete();
                            } else {
                                FwLog.write((int)2, (int)1, (String)FwLog.LogTag.L_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, code});
                                callback.onFailure(code);
                            }
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            io.rong.common.rlog.RLog.e((String)TAG, (String)("setChatRoomEntry - " + e.toString()));
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void getChatRoomEntry(final String chatRoomId, final String key, final IStringCallback callback, final NativeObject nativeObject) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_KV_T.getTag(), (String)"roomId|key", (Object[])new Object[]{chatRoomId, key});
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    int code = 0;
                    String value = "";
                    if (!NavigationCacheHelper.isKvStorageEnabled((Context)NativeClient.getApplicationContext())) {
                        code = IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.getValue();
                    } else if (ChatRoomNativeClient.this.chatRoomStatusMap.get(chatRoomId) == null) {
                        code = IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_SYNC.getValue();
                    } else {
                        value = nativeObject.GetChatRoomStatusByKey(chatRoomId, key);
                        if (TextUtils.isEmpty((CharSequence)value)) {
                            code = IRongCoreEnum.CoreErrorCode.KEY_NOT_EXIST.getValue();
                        }
                    }
                    if (code == 0) {
                        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code|value", (Object[])new Object[]{chatRoomId, key, 0, value});
                        callback.onComplete(value);
                    } else {
                        FwLog.write((int)2, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, code});
                        callback.onFailure(code);
                    }
                }
                catch (RemoteException e) {
                    io.rong.common.rlog.RLog.e((String)ChatRoomNativeClient.TAG, (String)("getChatRoomEntry - " + e.toString()));
                    FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                }
            }
        });
    }

    public void getAllChatRoomEntries(final String chatRoomId, final IDataByBatchListener callback, final NativeObject nativeObject) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_ALL_KV_T.getTag(), (String)"roomId", (Object[])new Object[]{chatRoomId});
        if (callback == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            try {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_INVALID_CHATROOM.getValue());
            }
            catch (RemoteException e) {
                io.rong.common.rlog.RLog.e((String)TAG, (String)"getAllChatRoomEntries error ", (Throwable)e);
                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
            }
            return;
        }
        if (!NavigationCacheHelper.isKvStorageEnabled((Context)NativeClient.getApplicationContext())) {
            try {
                int code = IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.getValue();
                FwLog.write((int)2, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_ALL_KV_R.getTag(), (String)"roomId|code", (Object[])new Object[]{chatRoomId, code});
                callback.onError(code);
            }
            catch (RemoteException e) {
                io.rong.common.rlog.RLog.e((String)TAG, (String)"getAllChatRoomEntries error ", (Throwable)e);
                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
            }
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                boolean isSyncFinish;
                boolean bl = isSyncFinish = ChatRoomNativeClient.this.chatRoomStatusMap != null && !ChatRoomNativeClient.this.chatRoomStatusMap.isEmpty() && ChatRoomNativeClient.this.chatRoomStatusMap.get(chatRoomId) != null && (Boolean)ChatRoomNativeClient.this.chatRoomStatusMap.get(chatRoomId) != false;
                if (isSyncFinish) {
                    HashMap result = nativeObject.GetChatRoomStatus(chatRoomId);
                    ChatRoomNativeClient.this.handleChatRoomEntriesByBatch(result, chatRoomId, callback);
                } else {
                    nativeObject.GetChatRoomKV(chatRoomId, new NativeObject.ChatroomKVCallback(){

                        public void OnKVComplete(int code, ChatroomStatus[] chatroomStatus) {
                            if (code == 0) {
                                HashMap<String, String> result = new HashMap<String, String>();
                                if (chatroomStatus != null && chatroomStatus.length > 0) {
                                    for (ChatroomStatus status : chatroomStatus) {
                                        if (status == null) continue;
                                        String key = status.getKey();
                                        String value = status.getValue();
                                        result.put(key, value);
                                    }
                                }
                                ChatRoomNativeClient.this.handleChatRoomEntriesByBatch(result, chatRoomId, callback);
                            } else {
                                try {
                                    callback.onError(code);
                                }
                                catch (RemoteException e) {
                                    FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private void handleChatRoomEntriesByBatch(HashMap<String, String> result, String chatRoomId, IDataByBatchListener callback) {
        try {
            if (result != null && !result.isEmpty()) {
                HashMap<String, String> transferMap = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : result.entrySet()) {
                    transferMap.put(entry.getKey(), entry.getValue());
                    if (transferMap.size() % 50 != 0) continue;
                    FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_ALL_KV_S.getTag(), (String)"roomId|kv", (Object[])new Object[]{chatRoomId, SystemUtils.mapToString(transferMap)});
                    callback.onProgress(transferMap);
                    transferMap.clear();
                }
                if (transferMap.size() > 0) {
                    FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_ALL_KV_S.getTag(), (String)"roomId|kv", (Object[])new Object[]{chatRoomId, SystemUtils.mapToString(transferMap)});
                    callback.onProgress(transferMap);
                    transferMap.clear();
                }
                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_ALL_KV_R.getTag(), (String)"roomId|code|size", (Object[])new Object[]{chatRoomId, 0, result.size()});
            }
            callback.onComplete();
        }
        catch (RemoteException e) {
            io.rong.common.rlog.RLog.e((String)TAG, (String)"handleChatRoomEntriesByBatch error ", (Throwable)e);
            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    void getAllChatRoomStatus(final String roomId, final NativeClient.IResultCallback<HashMap<String, String>> callback, final NativeObject nativeObject) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (!NavigationCacheHelper.isKvStorageEnabled((Context)NativeClient.getApplicationContext())) {
                    callback.onError(IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.getValue());
                    return;
                }
                if (ChatRoomNativeClient.this.chatRoomStatusMap.get(roomId) == null) {
                    callback.onError(IRongCoreEnum.CoreErrorCode.NOT_IN_CHATROOM.getValue());
                    return;
                }
                if (Objects.equals(ChatRoomNativeClient.this.chatRoomStatusMap.get(roomId), false)) {
                    callback.onError(IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_SYNC.getValue());
                    return;
                }
                HashMap result = nativeObject.GetChatRoomStatus(roomId);
                callback.onSuccess((Object)result);
            }
        });
    }

    public void getChatRoomInfo(final String id, int count, int order, final IResultCallback callback, NativeObject nativeObject) {
        try {
            if (nativeObject == null) {
                throw new RuntimeException("NativeClient has not been initialized yet!");
            }
            if (TextUtils.isEmpty((CharSequence)id)) {
                throw new IllegalArgumentException("Chatroom Id Parameter exception\u3002");
            }
            nativeObject.QueryChatroomInfo(id, count, order, new NativeObject.ChatroomInfoListener(){

                public void OnSuccess(int members, NativeObject.UserInfo[] users) {
                    ArrayList<ChatRoomMemberInfo> list = new ArrayList<ChatRoomMemberInfo>();
                    if (users != null) {
                        for (NativeObject.UserInfo user : users) {
                            ChatRoomMemberInfo info = new ChatRoomMemberInfo();
                            info.setUserId(user.getUserId());
                            info.setJoinTime(user.getJoinTime());
                            list.add(info);
                        }
                    }
                    ChatRoomInfo info = new ChatRoomInfo();
                    info.setChatRoomId(id);
                    info.setTotalMemberCount(members);
                    info.setMemberInfo(list);
                    if (callback != null) {
                        try {
                            RemoteModelWrap result = new RemoteModelWrap((Parcelable)info);
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }

                public void OnError(int status) {
                    if (callback != null) {
                        try {
                            callback.onFailure(status);
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void getChatRoomHistoryMessages(String targetId, long recordTime, int count, int order, final IChatRoomHistoryMessageCallback callback, NativeObject nativeObject) {
        try {
            io.rong.common.rlog.RLog.i((String)TAG, (String)("getChatroomHistoryMessages. targetId:" + targetId + "; recordTime:" + recordTime));
            if (NavigationClient.getInstance().isChatroomHistoryEnabled(NativeClient.getApplicationContext())) {
                nativeObject.GetChatroomHistoryMessage(targetId, recordTime, count, order, new NativeObject.HistoryMessageListener(){

                    public void onReceived(NativeObject.Message[] messages, long timestamp, boolean hasMsg) {
                        ArrayList<Message> list = new ArrayList<Message>();
                        if (messages != null && messages.length > 0) {
                            for (NativeObject.Message item : messages) {
                                Message msg = new Message(item);
                                msg.setContent(NativeClient.getInstance().renderMessageContent(item.getObjectName(), item.getContent(), msg));
                                list.add(msg);
                            }
                        }
                        if (callback != null) {
                            try {
                                if (list == null || list.size() == 0) {
                                    callback.onComplete(null, timestamp);
                                } else {
                                    callback.onComplete(new RemoteModelWrap((Parcelable)RongListWrap.obtain(list, Message.class)), timestamp);
                                }
                            }
                            catch (RemoteException e) {
                                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                            }
                        }
                    }

                    public void onError(int status) {
                        if (callback != null) {
                            try {
                                callback.onFailure(status);
                            }
                            catch (RemoteException e) {
                                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                            }
                        }
                    }
                }, "");
            } else if (callback != null) {
                try {
                    callback.onFailure(23414);
                }
                catch (RemoteException e) {
                    FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                }
            }
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void setKvStatusListener(final KVStatusDataByBatchListener kVStatusListener) {
        this.mKVStatusListener = new KVStatusListener(){

            @Override
            public void onChatRoomKVStatusSync(String roomId) {
                if (kVStatusListener != null) {
                    try {
                        kVStatusListener.onDataSync(roomId);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onChatRoomKVStatusChange(String roomId, Map<String, String> chatRoomKvMap) {
                if (kVStatusListener != null) {
                    try {
                        HashMap<String, String> transferMap = new HashMap<String, String>();
                        if (chatRoomKvMap != null && chatRoomKvMap.size() > 0) {
                            for (Map.Entry<String, String> entry : chatRoomKvMap.entrySet()) {
                                transferMap.put(entry.getKey(), entry.getValue());
                                if (transferMap.size() % 50 != 0) continue;
                                kVStatusListener.onProgressDataChange(transferMap);
                                transferMap.clear();
                            }
                            if (transferMap.size() > 0) {
                                kVStatusListener.onProgressDataChange(transferMap);
                                transferMap.clear();
                            }
                        }
                        kVStatusListener.onCompleteDataChange(roomId);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e((String)ChatRoomNativeClient.TAG, (String)"setKvStatusListener StatusDidChange Exception ", (Throwable)e);
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
            }

            @Override
            public void onChatRoomKVStatusRemove(String roomId, Map<String, String> chatRoomKvMap) {
                if (kVStatusListener != null) {
                    try {
                        HashMap<String, String> transferMap = new HashMap<String, String>();
                        if (chatRoomKvMap != null && chatRoomKvMap.size() > 0) {
                            for (Map.Entry<String, String> entry : chatRoomKvMap.entrySet()) {
                                String valueLimitedLength = entry.getValue();
                                if (valueLimitedLength != null && valueLimitedLength.length() > 4096) {
                                    valueLimitedLength = entry.getValue().substring(0, 4096);
                                }
                                transferMap.put(entry.getKey(), valueLimitedLength);
                                if (transferMap.size() % 50 != 0) continue;
                                kVStatusListener.onProgressDataRemove(transferMap);
                                transferMap.clear();
                            }
                            if (transferMap.size() > 0) {
                                kVStatusListener.onProgressDataRemove(transferMap);
                                transferMap.clear();
                            }
                        }
                        kVStatusListener.onCompleteDataRemove(roomId);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e((String)ChatRoomNativeClient.TAG, (String)"setKvStatusListener StatusDidRemove Exception ", (Throwable)e);
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
            }
        };
    }

    private boolean clearMessages(Conversation.ConversationType conversationType, String targetId, NativeObject nativeObject) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("Abnormal conversationType or targetId parameter\u3002");
        }
        return nativeObject.ClearMessages(conversationType.getValue(), targetId, false, "");
    }

    public void initChatRoomEventListener(NativeObject nativeObject) {
        if (nativeObject == null) {
            throw new RuntimeException("NativeClient has not been initialized yet!");
        }
        nativeObject.SetChatroomEventListener(new NativeObject.ChatroomEventListener(){

            public void OnChatroomDestroyed(String roomId, int type) {
                if (ChatRoomNativeClient.this.mChatRoomEventListener != null) {
                    try {
                        if (ChatRoomNativeClient.this.chatRoomStatusMap != null) {
                            ChatRoomNativeClient.this.chatRoomStatusMap.remove(roomId);
                        }
                        ChatRoomNativeClient.this.mChatRoomEventListener.onDestroyed(roomId, type);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e((String)ChatRoomNativeClient.TAG, (String)"setChatRoomEventListener", (Throwable)e);
                    }
                }
            }
        });
    }

    public void setChatRoomEventListener(IChatRoomEventListener listener) {
        this.mChatRoomEventListener = listener;
    }

    private void detectNaviIfNeedByChatroom(final int error) {
        if (IRongCoreEnum.CoreErrorCode.KICKED_FROM_CHATROOM.getValue() == error || IRongCoreEnum.CoreErrorCode.RC_CHATROOM_NOT_EXIST.getValue() == error || IRongCoreEnum.CoreErrorCode.RC_CHATROOM_IS_FULL.getValue() == error || IRongCoreEnum.CoreErrorCode.PARAMETER_INVALID_CHATROOM.getValue() == error || IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.getValue() == error) {
            return;
        }
        NetDetection.detectNavi((Context)this.mContext, (boolean)true, (NetDetection.DetectionCallback)new NetDetection.DetectionCallback(){

            public void onSuccess(String navi, String ip, String net) {
                FwLog.write((int)1, (int)1, (String)FwLog.LogTag.L_DETECT_CHATROOM_S.getTag(), (String)"code|navi|ip|net", (Object[])new Object[]{error, navi, ip, net});
            }

            public void onError() {
            }
        });
    }

    public void setChatRoomEntries(String chatRoomId, Map<String, String> chatRoomEntryMap, boolean autoDelete, boolean overWrite, final ISetChatRoomKVCallbackListener callback, NativeObject nativeObject) {
        if (callback == null) {
            return;
        }
        if (!NavigationCacheHelper.isKvStorageEnabled((Context)NativeClient.getApplicationContext())) {
            try {
                callback.onError(IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.getValue(), new HashMap());
            }
            catch (RemoteException e) {
                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
            }
            return;
        }
        if (chatRoomEntryMap == null || chatRoomEntryMap.isEmpty()) {
            try {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_INVALID_CHATROOM.getValue(), new HashMap());
            }
            catch (RemoteException e) {
                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
            }
            return;
        }
        try {
            int chatRoomEntriesSize = chatRoomEntryMap.size();
            ArrayList<NativeObject.StatusData> statusDataList = new ArrayList<NativeObject.StatusData>(chatRoomEntriesSize);
            for (Map.Entry<String, String> entry : chatRoomEntryMap.entrySet()) {
                NativeObject.StatusData statusData = new NativeObject.StatusData();
                statusData.setKey(entry.getKey());
                statusData.setValue(entry.getValue());
                statusData.setAutoDelete(autoDelete);
                statusData.setOverwrite(overWrite);
                statusDataList.add(statusData);
            }
            NativeObject.StatusData[] statusDataArray = statusDataList.toArray(new NativeObject.StatusData[chatRoomEntriesSize]);
            NativeObject.StatusNotification statusNotification = new NativeObject.StatusNotification();
            statusNotification.setNotifyAll(false);
            nativeObject.SetChatRoomKV(chatRoomId, statusDataArray, statusNotification, new NativeObject.SetChatroomKVCallback(){

                public void OnKVComplete(int code, HashMap<String, String> failedKV) {
                    try {
                        if (code == 0) {
                            callback.onSuccess();
                        } else {
                            callback.onError(code, failedKV);
                        }
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
            });
        }
        catch (RuntimeException e) {
            io.rong.common.rlog.RLog.e((String)TAG, (String)("SetChatRoomKV - " + e.toString()));
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void deleteChatRoomEntries(String chatRoomId, List<String> chatRoomEntryList, boolean force, final ISetChatRoomKVCallbackListener callback, NativeObject nativeObject) {
        if (callback == null) {
            return;
        }
        if (!NavigationCacheHelper.isKvStorageEnabled((Context)NativeClient.getApplicationContext())) {
            try {
                callback.onError(IRongCoreEnum.CoreErrorCode.KV_STORE_NOT_AVAILABLE.getValue(), new HashMap());
            }
            catch (RemoteException e) {
                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
            }
            return;
        }
        if (chatRoomEntryList == null || chatRoomEntryList.isEmpty()) {
            try {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_INVALID_CHATROOM.getValue(), new HashMap());
            }
            catch (RemoteException e) {
                FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
            }
            return;
        }
        try {
            int chatRoomEntriesSize = chatRoomEntryList.size();
            ArrayList<NativeObject.StatusData> statusDataList = new ArrayList<NativeObject.StatusData>(chatRoomEntriesSize);
            for (String key : chatRoomEntryList) {
                NativeObject.StatusData statusData = new NativeObject.StatusData();
                statusData.setKey(key);
                statusData.setOverwrite(force);
                statusDataList.add(statusData);
            }
            NativeObject.StatusData[] statusDataArray = statusDataList.toArray(new NativeObject.StatusData[chatRoomEntriesSize]);
            NativeObject.StatusNotification statusNotification = new NativeObject.StatusNotification();
            statusNotification.setNotifyAll(false);
            nativeObject.DeleteChatRoomKV(chatRoomId, statusDataArray, statusNotification, new NativeObject.SetChatroomKVCallback(){

                public void OnKVComplete(int code, HashMap<String, String> failedKV) {
                    try {
                        if (code == 0) {
                            callback.onSuccess();
                        } else {
                            callback.onError(code, failedKV);
                        }
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
            });
        }
        catch (RuntimeException e) {
            io.rong.common.rlog.RLog.e((String)TAG, (String)("deleteChatRoomEntries - " + e.toString()));
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public boolean clearChatRoomMessagesAndKV(String roomId, NativeObject nativeObject) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            return false;
        }
        boolean result = nativeObject.ClearChatroomMessageAndKV(roomId, true, true);
        io.rong.common.rlog.RLog.d((String)TAG, (String)("clearChatRoomMessagesAndKV. result:" + result));
        return result;
    }

    public static interface KVStatusListener {
        public void onChatRoomKVStatusSync(String var1);

        public void onChatRoomKVStatusChange(String var1, Map<String, String> var2);

        public void onChatRoomKVStatusRemove(String var1, Map<String, String> var2);
    }

    private static class NativeClientHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final ChatRoomNativeClient client = new ChatRoomNativeClient();

        private NativeClientHolder() {
        }
    }
}

