/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.base;

import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.chatroom.base.RongChatRoomClientImpl;
import io.rong.imlib.model.ChatRoomConfig;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.ChatRoomMemberAction;
import java.util.List;
import java.util.Map;

public abstract class RongChatRoomClient {
    private static final String TAG = "RongChatRoomClient";

    public static RongChatRoomClient getInstance() {
        return RongChatRoomClientImpl.getInstanceForInterior();
    }

    public static void setChatRoomActionListener(ChatRoomActionListener listener) {
        RongChatRoomClientImpl.setChatRoomActionListenerForInterior(listener);
    }

    public static void setChatRoomAdvancedActionListener(ChatRoomAdvancedActionListener listener) {
        RongChatRoomClientImpl.setChatRoomAdvancedActionListenerForInterior(listener);
    }

    public static ChatRoomMemberActionListener getChatRoomMemberListener() {
        return RongChatRoomClientImpl.getChatRoomMemberListenerForInterior();
    }

    public static void setChatRoomMemberListener(ChatRoomMemberActionListener listener) {
        RongChatRoomClientImpl.setChatRoomMemberListenerForInterior(listener);
    }

    public abstract void joinChatRoom(String var1, int var2, IRongCoreCallback.OperationCallback var3);

    public abstract void joinExistChatRoom(String var1, int var2, IRongCoreCallback.OperationCallback var3);

    public abstract void bindChatRoomWithRTCRoom(String var1, String var2, IRongCoreCallback.OperationCallback var3);

    public abstract void quitChatRoom(String var1, IRongCoreCallback.OperationCallback var2);

    public abstract void forceRemoveChatRoomEntry(String var1, String var2, Boolean var3, String var4, IRongCoreCallback.OperationCallback var5);

    public abstract void forceSetChatRoomEntry(String var1, String var2, String var3, boolean var4, boolean var5, String var6, IRongCoreCallback.OperationCallback var7);

    public abstract void setChatRoomEntry(String var1, String var2, String var3, boolean var4, boolean var5, String var6, IRongCoreCallback.OperationCallback var7);

    public abstract void setChatRoomEntries(String var1, Map<String, String> var2, boolean var3, boolean var4, IRongCoreCallback.SetChatRoomKVCallback var5);

    public abstract void deleteChatRoomEntries(String var1, List<String> var2, boolean var3, IRongCoreCallback.SetChatRoomKVCallback var4);

    public abstract void getChatRoomEntry(String var1, String var2, IRongCoreCallback.ResultCallback<Map<String, String>> var3);

    public abstract void getAllChatRoomEntries(String var1, IRongCoreCallback.ResultCallback<Map<String, String>> var2);

    public abstract void removeChatRoomEntry(String var1, String var2, Boolean var3, String var4, IRongCoreCallback.OperationCallback var5);

    public abstract void getChatRoomInfo(String var1, int var2, ChatRoomInfo.ChatRoomMemberOrder var3, IRongCoreCallback.ResultCallback<ChatRoomInfo> var4);

    public abstract void getChatroomHistoryMessages(String var1, long var2, int var4, IRongCoreEnum.TimestampOrder var5, IRongCoreCallback.IChatRoomHistoryMessageCallback var6);

    @Deprecated
    public abstract void setKVStatusListener(KVStatusListener var1);

    public abstract boolean addKVStatusListener(KVStatusListener var1);

    public abstract boolean removeKVStatusListener(KVStatusListener var1);

    public static ChatRoomConfig chatRoomConfig() {
        return RongChatRoomClientImpl.chatRoomConfigForInterior();
    }

    public static interface ChatRoomMemberActionListener {
        public void onMemberChange(List<ChatRoomMemberAction> var1, String var2);
    }

    public static interface ChatRoomAdvancedActionListener {
        public void onJoining(String var1);

        public void onJoined(String var1);

        public void onReset(String var1);

        public void onQuited(String var1);

        public void onDestroyed(String var1, IRongCoreEnum.ChatRoomDestroyType var2);

        public void onError(String var1, IRongCoreEnum.CoreErrorCode var2);
    }

    public static interface KVFilter {
        public void onKVSync(String var1);

        public Map<String, String> filterKVUpdateMap(String var1, Map<String, String> var2);

        public Map<String, String> filterKVRemoveMap(String var1, Map<String, String> var2);

        public Map<String, String> filterKVGetAllMap(String var1, Map<String, String> var2);
    }

    public static interface ChatRoomActionListener {
        public void onJoining(String var1);

        public void onJoined(String var1);

        public void onQuited(String var1);

        public void onError(String var1, IRongCoreEnum.CoreErrorCode var2);
    }

    public static interface KVStatusListener {
        public void onChatRoomKVSync(String var1);

        public void onChatRoomKVUpdate(String var1, Map<String, String> var2);

        public void onChatRoomKVRemove(String var1, Map<String, String> var2);
    }

    public static enum JoinMode {
        COMMON(0),
        RTC(1);

        private int value;

        private JoinMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static JoinMode setValue(int code) {
            for (JoinMode c : JoinMode.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return COMMON;
        }
    }
}

