/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.base;

import android.os.RemoteException;
import android.text.TextUtils;
import io.rong.common.SystemUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.common.rlog.RLog;
import io.rong.common.utils.StringUtils;
import io.rong.imlib.IChatRoomEventListener;
import io.rong.imlib.IChatRoomHistoryMessageCallback;
import io.rong.imlib.IChatRoomOperationCallback;
import io.rong.imlib.IDataByBatchListener;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.ISetChatRoomKVCallbackListener;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.KVStatusDataByBatchListener;
import io.rong.imlib.RongCoreClient;
import io.rong.imlib.RongCoreClientImpl;
import io.rong.imlib.chatroom.base.ChatRoomHelper;
import io.rong.imlib.chatroom.base.RongChatRoomClient;
import io.rong.imlib.common.ExecutorFactory;
import io.rong.imlib.ipc.IpcCallbackProxy;
import io.rong.imlib.model.ChatRoomConfig;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.RemoteModelWrap;
import io.rong.imlib.model.RongListWrap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class RongChatRoomClientImpl
extends RongChatRoomClient {
    private static final String TAG = "RongChatRoomClient";
    private static final int KEY_LENGTH_LIMIT = 128;
    private static final int VALUE_LENGTH_LIMIT = 4112;
    private static final int KV_MAX_NUMBER_LIMIT = 10;
    private static RongChatRoomClient.ChatRoomAdvancedActionListener sChatRoomAdvancedActionListener;
    private static final AtomicReference<RongChatRoomClient.ChatRoomActionListener> sChatRoomActionListener;
    private static final List<RongChatRoomClient.KVStatusListener> sKVStatusListeners;
    private static RongChatRoomClient.ChatRoomMemberActionListener sChatRoomMemberActionListener;
    private ChatRoomConfig chatRoomConfig = new ChatRoomConfig();
    private final HashMap<String, ChatRoomCacheRunnable> mRetryCRCache = new HashMap();
    private final HashMap<String, ChatRoomCacheRunnable> mChatRoomCache = new HashMap();
    private RongChatRoomClient.KVFilter mKVFilter;
    private Timer timer;

    private RongChatRoomClientImpl() {
    }

    static RongChatRoomClientImpl getInstanceForInterior() {
        return SingletonHolder.sInstance;
    }

    static void setChatRoomActionListenerForInterior(RongChatRoomClient.ChatRoomActionListener listener) {
        sChatRoomActionListener.set(listener);
    }

    static void setChatRoomAdvancedActionListenerForInterior(RongChatRoomClient.ChatRoomAdvancedActionListener listener) {
        sChatRoomAdvancedActionListener = listener;
    }

    static RongChatRoomClient.ChatRoomMemberActionListener getChatRoomMemberListenerForInterior() {
        return sChatRoomMemberActionListener;
    }

    static void setChatRoomMemberListenerForInterior(RongChatRoomClient.ChatRoomMemberActionListener listener) {
        sChatRoomMemberActionListener = listener;
    }

    void init() {
        this.initReceiver();
    }

    private void initReceiver() {
        try {
            ChatRoomHelper.getInstance().setKvStatusListener((KVStatusDataByBatchListener)new KVStatusDataByBatchListener.Stub(){
                final Map<String, String> resultChange = new HashMap<String, String>();
                final Map<String, String> resultRemove = new HashMap<String, String>();

                public void onDataSync(String roomId) throws RemoteException {
                    RLog.i((String)RongChatRoomClientImpl.TAG, (String)("onChatRoomKVStatusSync roomId =" + roomId));
                    for (RongChatRoomClient.KVStatusListener listener : sKVStatusListeners) {
                        listener.onChatRoomKVSync(roomId);
                    }
                    if (RongChatRoomClientImpl.this.mKVFilter != null) {
                        RongChatRoomClientImpl.this.mKVFilter.onKVSync(roomId);
                    }
                }

                public void onProgressDataChange(Map data) throws RemoteException {
                    this.resultChange.putAll(data);
                }

                public void onCompleteDataChange(String roomId) throws RemoteException {
                    RLog.i((String)RongChatRoomClientImpl.TAG, (String)("onCompleteDataChange roomId =" + roomId + " size" + this.resultChange.size()));
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    if (RongChatRoomClientImpl.this.mKVFilter != null) {
                        Map<String, String> filteredMap = RongChatRoomClientImpl.this.mKVFilter.filterKVUpdateMap(roomId, this.resultChange);
                        if (filteredMap != null) {
                            resultMap.putAll(filteredMap);
                        }
                    } else {
                        resultMap.putAll(this.resultChange);
                    }
                    if (resultMap.size() > 0) {
                        for (RongChatRoomClient.KVStatusListener listener : sKVStatusListeners) {
                            listener.onChatRoomKVUpdate(roomId, resultMap);
                        }
                    }
                    this.resultChange.clear();
                }

                public void onProgressDataRemove(Map data) throws RemoteException {
                    this.resultRemove.putAll(data);
                }

                public void onCompleteDataRemove(String roomId) throws RemoteException {
                    RLog.i((String)RongChatRoomClientImpl.TAG, (String)("onCompleteDataRemove roomId =" + roomId + " size" + this.resultRemove.size()));
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    if (RongChatRoomClientImpl.this.mKVFilter != null) {
                        Map<String, String> filteredMap = RongChatRoomClientImpl.this.mKVFilter.filterKVRemoveMap(roomId, this.resultRemove);
                        if (filteredMap != null) {
                            resultMap.putAll(filteredMap);
                        }
                    } else {
                        resultMap.putAll(this.resultRemove);
                    }
                    if (resultMap.size() > 0) {
                        for (RongChatRoomClient.KVStatusListener listener : sKVStatusListeners) {
                            listener.onChatRoomKVRemove(roomId, resultMap);
                        }
                    }
                    this.resultRemove.clear();
                }
            });
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)("set setKvStatusListener exception:" + e.toString()));
        }
        try {
            ChatRoomHelper.getInstance().setChatRoomEventListener((IChatRoomEventListener)new IChatRoomEventListener.Stub(){

                public void onDestroyed(String roomId, int type) {
                    RLog.i((String)RongChatRoomClientImpl.TAG, (String)("setChatRoomEventListener\uff1aroomId=" + roomId + " type=" + type));
                    if (sChatRoomAdvancedActionListener != null) {
                        sChatRoomAdvancedActionListener.onDestroyed(roomId, IRongCoreEnum.ChatRoomDestroyType.valueOf((int)type));
                    }
                }
            });
        }
        catch (RemoteException e) {
            RLog.e((String)TAG, (String)"setChatRoomEventListener", (Throwable)e);
        }
    }

    @Override
    public void joinChatRoom(final String chatRoomId, final int defMessageCount, final IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_T.getTag(), (String)"room_id|existed|count", (Object[])new Object[]{chatRoomId, false, defMessageCount});
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code, chatRoomId});
            callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((RongCoreClientImpl)RongCoreClient.getInstance()).getToken())) {
            RLog.e((String)TAG, (String)"joinChatRoom without connect!");
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT.code, chatRoomId});
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    RongChatRoomClient.ChatRoomActionListener listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get();
                    if (listener != null) {
                        listener.onJoining(chatRoomId);
                    }
                    if (sChatRoomAdvancedActionListener != null) {
                        sChatRoomAdvancedActionListener.onJoining(chatRoomId);
                    }
                    try {
                        if (RongChatRoomClient.chatRoomConfig().shouldClearMessagesAndKVWhenJoin() && !RongChatRoomClientImpl.this.mChatRoomCache.containsKey(chatRoomId)) {
                            ChatRoomHelper.getInstance().clearChatRoomMessagesAndKV(chatRoomId);
                        }
                        boolean joinMultiCR = ChatRoomHelper.getInstance().getJoinMultiChatRoomEnable();
                        JoinChatRoomCallback callback2 = new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, chatRoomId, defMessageCount, joinMultiCR, false, false, RongChatRoomClient.JoinMode.COMMON.getValue());
                        ChatRoomHelper.getInstance().joinChatRoom(chatRoomId, defMessageCount, (IChatRoomOperationCallback)callback2, RongChatRoomClient.JoinMode.COMMON.getValue());
                    }
                    catch (Exception e) {
                        FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id|stacks", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue(), chatRoomId, FwLog.stackToString((Throwable)e)});
                        callback.onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        if (listener != null) {
                            listener.onError(chatRoomId, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        }
                        if (sChatRoomAdvancedActionListener == null) break block6;
                        sChatRoomAdvancedActionListener.onError(chatRoomId, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    private void joinChatRoomWithJoinMode(final String chatRoomId, final int defMessageCount, final IRongCoreCallback.OperationCallback callback, final RongChatRoomClient.JoinMode joinMode) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_T.getTag(), (String)"room_id|existed|count", (Object[])new Object[]{chatRoomId, false, defMessageCount});
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code, chatRoomId});
            callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((RongCoreClientImpl)RongCoreClient.getInstance()).getToken())) {
            RLog.e((String)TAG, (String)"joinChatRoom without connect!");
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT.code, chatRoomId});
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT);
            }
            return;
        }
        if (joinMode == null) {
            RLog.e((String)TAG, (String)"joinChatRoomWithJoinMode joinMode is null!");
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code, chatRoomId});
            callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    RongChatRoomClient.ChatRoomActionListener listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get();
                    if (listener != null) {
                        listener.onJoining(chatRoomId);
                    }
                    if (sChatRoomAdvancedActionListener != null) {
                        sChatRoomAdvancedActionListener.onJoining(chatRoomId);
                    }
                    try {
                        boolean joinMultiCR = ChatRoomHelper.getInstance().getJoinMultiChatRoomEnable();
                        JoinChatRoomCallback callback2 = new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, chatRoomId, defMessageCount, joinMultiCR, false, false, joinMode.getValue());
                        ChatRoomHelper.getInstance().joinChatRoom(chatRoomId, defMessageCount, (IChatRoomOperationCallback)callback2, joinMode.getValue());
                    }
                    catch (Exception e) {
                        FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id|stacks", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue(), chatRoomId, FwLog.stackToString((Throwable)e)});
                        callback.onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        if (listener != null) {
                            listener.onError(chatRoomId, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        }
                        if (sChatRoomAdvancedActionListener == null) break block5;
                        sChatRoomAdvancedActionListener.onError(chatRoomId, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    @Override
    public void joinExistChatRoom(final String chatRoomId, final int defMessageCount, IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_T.getTag(), (String)"room_id|existed|count", (Object[])new Object[]{chatRoomId, true, defMessageCount});
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code, chatRoomId});
            RLog.e((String)TAG, (String)"id is null");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((RongCoreClientImpl)RongCoreClient.getInstance()).getToken())) {
            RLog.e((String)TAG, (String)"joinExitChatRoom without connect!");
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT.code, chatRoomId});
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                boolean joinMultiCR = false;
                try {
                    joinMultiCR = ChatRoomHelper.getInstance().getJoinMultiChatRoomEnable();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                JoinChatRoomCallback callback = new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, chatRoomId, defMessageCount, joinMultiCR, true, false, RongChatRoomClient.JoinMode.COMMON.getValue());
                RongChatRoomClient.ChatRoomActionListener listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get();
                if (listener != null) {
                    listener.onJoining(chatRoomId);
                }
                if (sChatRoomAdvancedActionListener != null) {
                    sChatRoomAdvancedActionListener.onJoining(chatRoomId);
                }
                try {
                    if (RongChatRoomClient.chatRoomConfig().shouldClearMessagesAndKVWhenJoin() && !RongChatRoomClientImpl.this.mChatRoomCache.containsKey(chatRoomId)) {
                        ChatRoomHelper.getInstance().clearChatRoomMessagesAndKV(chatRoomId);
                    }
                    ChatRoomHelper.getInstance().joinExistChatRoom(chatRoomId, defMessageCount, (IChatRoomOperationCallback)new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, chatRoomId, defMessageCount, joinMultiCR, true, false, RongChatRoomClient.JoinMode.COMMON.getValue()), false, RongChatRoomClient.JoinMode.COMMON.getValue());
                }
                catch (Exception e) {
                    FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id|stacks", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue(), chatRoomId, FwLog.stackToString((Throwable)e)});
                    RLog.e((String)RongChatRoomClientImpl.TAG, (String)"joinExistChatRoom", (Throwable)e);
                    callback.onFailure(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue());
                }
            }
        });
    }

    @Override
    public void bindChatRoomWithRTCRoom(final String chatRoomId, final String RTCRoomId, final IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_BIND_CHATROOM_4_RTC_ROOM_T.getTag(), (String)"room_id|rtc_room", (Object[])new Object[]{chatRoomId, RTCRoomId});
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_BIND_CHATROOM_4_RTC_ROOM_T.getTag(), (String)"room_id|rtc_room", (Object[])new Object[]{chatRoomId, RTCRoomId});
            RLog.e((String)TAG, (String)"id is null");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((RongCoreClientImpl)RongCoreClient.getInstance()).getToken())) {
            RLog.e((String)TAG, (String)"joinExitChatRoom without connect!");
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_BIND_CHATROOM_4_RTC_ROOM_R.getTag(), (String)"room_id|rtc_room", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT.code, chatRoomId});
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomHelper.getInstance().bindChatRoomWithRTCRoom(chatRoomId, RTCRoomId, (IChatRoomOperationCallback)new MyBindResultCallback(chatRoomId, RTCRoomId, (IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_BIND_CHATROOM_4_RTC_ROOM_R.getTag(), (String)"code|room_id|rtc_room|stacks", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue(), chatRoomId, RTCRoomId, FwLog.stackToString((Throwable)e)});
                    RLog.e((String)RongChatRoomClientImpl.TAG, (String)"joinExistChatRoom", (Throwable)e);
                    callback.onError(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                }
            }
        });
    }

    private void joinExistChatRoomWithJoinMode(final String chatRoomId, final int defMessageCount, IRongCoreCallback.OperationCallback callback, final RongChatRoomClient.JoinMode joinMode) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_T.getTag(), (String)"room_id|existed|count", (Object[])new Object[]{chatRoomId, true, defMessageCount});
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code, chatRoomId});
            RLog.e((String)TAG, (String)"id is null");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((RongCoreClientImpl)RongCoreClient.getInstance()).getToken())) {
            RLog.e((String)TAG, (String)"joinExitChatRoom without connect!");
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT.code, chatRoomId});
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.APP_NOT_CONNECT);
            }
            return;
        }
        if (joinMode == null) {
            RLog.e((String)TAG, (String)"joinExistChatRoomWithJoinMode joinMode is null!");
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code, chatRoomId});
            callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JoinChatRoomCallback callback = new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, chatRoomId, defMessageCount, false, true, false, joinMode.getValue());
                RongChatRoomClient.ChatRoomActionListener listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get();
                if (listener != null) {
                    listener.onJoining(chatRoomId);
                }
                if (sChatRoomAdvancedActionListener != null) {
                    sChatRoomAdvancedActionListener.onJoining(chatRoomId);
                }
                try {
                    boolean joinMultiCR = ChatRoomHelper.getInstance().getJoinMultiChatRoomEnable();
                    ChatRoomHelper.getInstance().joinExistChatRoom(chatRoomId, defMessageCount, (IChatRoomOperationCallback)new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, chatRoomId, defMessageCount, joinMultiCR, true, false, joinMode.getValue()), false, joinMode.getValue());
                }
                catch (Exception e) {
                    FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), (String)"code|room_id|stacks", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue(), chatRoomId, FwLog.stackToString((Throwable)e)});
                    RLog.e((String)RongChatRoomClientImpl.TAG, (String)"joinExistChatRoom", (Throwable)e);
                    callback.onFailure(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue());
                }
            }
        });
    }

    @Override
    public void quitChatRoom(final String chatRoomId, IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_QUIT_CHATROOM_T.getTag(), (String)"room_id", (Object[])new Object[]{chatRoomId});
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code, chatRoomId});
            RLog.e((String)TAG, (String)"id is null!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    RongChatRoomClient.ChatRoomActionListener listener;
                    RongChatRoomClientImpl.this.mChatRoomCache.remove(chatRoomId);
                    Runnable runnable = (Runnable)RongChatRoomClientImpl.this.mRetryCRCache.remove(chatRoomId);
                    if (runnable != null) {
                        ExecutorFactory.getInstance().getWorkExecutor().remove(runnable);
                    }
                    if ((listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get()) != null) {
                        listener.onQuited(chatRoomId);
                    }
                    if (sChatRoomAdvancedActionListener != null) {
                        sChatRoomAdvancedActionListener.onQuited(chatRoomId);
                    }
                    try {
                        ChatRoomHelper.getInstance().quitChatRoom(chatRoomId, (IOperationCallback)new IRongCoreCallback.DefaultOperationCallback(ipcCallbackProxy){

                            public void onComplete() {
                                super.onComplete();
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{0, chatRoomId});
                            }

                            public void onFailure(int errorCode) {
                                super.onFailure(errorCode);
                                FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), (String)"code|room_id", (Object[])new Object[]{errorCode, chatRoomId});
                            }
                        });
                    }
                    catch (Exception e) {
                        FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), (String)"code|room_id|stacks", (Object[])new Object[]{-1000, chatRoomId, FwLog.stackToString((Throwable)e)});
                        RLog.e((String)RongChatRoomClientImpl.TAG, (String)"quitChatRoom", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block5;
                        ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    @Override
    public void forceRemoveChatRoomEntry(final String chatRoomId, final String key, final Boolean sendNotification, final String notificationExtra, IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_FORCE_REMOVE_CHATROOM_KV_T.getTag(), (String)"roomId|key|notify", (Object[])new Object[]{chatRoomId, key, sendNotification});
        if (TextUtils.isEmpty((CharSequence)chatRoomId) || TextUtils.isEmpty((CharSequence)key)) {
            RLog.e((String)TAG, (String)"forceRemoveChatRoomEntry chatRoomId or key is empty!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomHelper.getInstance().deleteChatRoomEntry(key, null, chatRoomId, sendNotification, notificationExtra, false, true, (IOperationCallback)new IOperationCallback.Stub(){

                        public void onComplete() throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onCallback();
                                ipcCallbackProxy.callback = null;
                            }
                            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_FORCE_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, 0});
                        }

                        public void onFailure(int coreErrorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(coreErrorCode);
                                ipcCallbackProxy.callback = null;
                            }
                            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, coreErrorCode});
                        }
                    });
                }
                catch (Exception e) {
                    if (ipcCallbackProxy.callback != null) {
                        ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.code});
                }
            }
        });
    }

    @Override
    public void forceSetChatRoomEntry(final String chatRoomId, final String key, final String value, final boolean sendNotification, final boolean autoDelete, final String notificationExtra, IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_FORCE_SET_CHATROOM_KV_T.getTag(), (String)"roomId|key|value|notify|auto_del", (Object[])new Object[]{chatRoomId, key, value, sendNotification, autoDelete});
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value) || TextUtils.isEmpty((CharSequence)chatRoomId) || !key.matches("^[A-Za-z0-9+_=-]+$")) {
            RLog.e((String)TAG, (String)"forceSetChatRoomEntry chatRoomId or key or value is empty or key contains illegal characters!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        if (key.length() > 128) {
            RLog.e((String)TAG, (String)"The key length limit is 128.");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        if (value.length() > 4112) {
            RLog.e((String)TAG, (String)"The value length limit is 4096.");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomHelper.getInstance().setChatRoomEntry(key, value, chatRoomId, sendNotification, notificationExtra, autoDelete, true, (IOperationCallback)new IOperationCallback.Stub(){

                        public void onComplete() throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onCallback();
                                ipcCallbackProxy.callback = null;
                            }
                            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_FORCE_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, 0});
                        }

                        public void onFailure(int coreErrorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(coreErrorCode);
                                ipcCallbackProxy.callback = null;
                            }
                            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, coreErrorCode});
                        }
                    });
                }
                catch (Exception e) {
                    if (ipcCallbackProxy.callback != null) {
                        ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_FORCE_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.code});
                }
            }
        });
    }

    @Override
    public void setChatRoomEntry(final String chatRoomId, final String key, final String value, final boolean sendNotification, final boolean autoDelete, final String notificationExtra, IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_SET_CHATROOM_KV_T.getTag(), (String)"roomId|key|value|notify|auto_del", (Object[])new Object[]{chatRoomId, key, value, sendNotification, autoDelete});
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value) || TextUtils.isEmpty((CharSequence)chatRoomId) || !key.matches("^[A-Za-z0-9+_=-]+$")) {
            RLog.e((String)TAG, (String)"setChatRoomEntry chatRoomId or key or value is empty or key contains illegal characters!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        if (key.length() > 128) {
            RLog.e((String)TAG, (String)"The key length limit is 128.");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        if (value.length() > 4112) {
            RLog.e((String)TAG, (String)"The value length limit is 4096.");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ChatRoomHelper.getInstance().setChatRoomEntry(key, value, chatRoomId, sendNotification, notificationExtra, autoDelete, false, (IOperationCallback)new IOperationCallback.Stub(){

                            public void onComplete() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onCallback();
                                    ipcCallbackProxy.callback = null;
                                }
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, 0});
                            }

                            public void onFailure(int coreErrorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(coreErrorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                                FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, coreErrorCode});
                            }
                        });
                    }
                    catch (Exception e) {
                        FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_SET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.code});
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    @Override
    public void setChatRoomEntries(final String chatRoomId, final Map<String, String> chatRoomEntryMap, final boolean autoDelete, final boolean overWrite, IRongCoreCallback.SetChatRoomKVCallback callback) {
        if (chatRoomEntryMap == null || chatRoomEntryMap.isEmpty()) {
            RLog.e((String)TAG, (String)"setChatRoomEntries: The chatRoomEntryMap is null or empty!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR, null);
            }
            return;
        }
        if (chatRoomEntryMap.size() > 10) {
            RLog.e((String)TAG, (String)"setChatRoomEntries: The maximum map size is 10");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.KV_STORE_OUT_OF_LIMIT, null);
            }
            return;
        }
        HashMap<String, IRongCoreEnum.CoreErrorCode> failMap = new HashMap<String, IRongCoreEnum.CoreErrorCode>();
        for (Map.Entry<String, String> entry : chatRoomEntryMap.entrySet()) {
            String entryKey = entry.getKey();
            String entryValue = entry.getValue();
            if (!TextUtils.isEmpty((CharSequence)entryKey) && !TextUtils.isEmpty((CharSequence)entryValue) && entryKey.matches("^[A-Za-z0-9+_=-]+$")) continue;
            failMap.put(entryKey, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
        }
        if (!failMap.isEmpty()) {
            RLog.e((String)TAG, (String)"setChatRoomEntries: The chatRoomEntryMap contains empty or invalid keys and values!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR, failMap);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            RLog.e((String)TAG, (String)"setChatRoomEntries: The chatRoomId is empty!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR, null);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ChatRoomHelper.getInstance().setChatRoomEntries(chatRoomId, chatRoomEntryMap, autoDelete, overWrite, (ISetChatRoomKVCallbackListener)new ISetChatRoomKVCallbackListener.Stub(){

                            public void onSuccess() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.SetChatRoomKVCallback)ipcCallbackProxy.callback).onCallback();
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            public void onError(int coreErrorCode, Map failKV) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.SetChatRoomKVCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.valueOf((int)coreErrorCode), RongChatRoomClientImpl.this.obtainResultFailMap(failKV));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.SetChatRoomKVCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT, null);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    @Override
    public void deleteChatRoomEntries(final String roomId, final List<String> chatRoomEntryList, final boolean force, IRongCoreCallback.SetChatRoomKVCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e((String)TAG, (String)"deleteChatRoomEntries: chatRoomId is empty!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR, null);
            }
            return;
        }
        if (chatRoomEntryList == null || chatRoomEntryList.isEmpty()) {
            RLog.e((String)TAG, (String)"deleteChatRoomEntries: chatRoomEntryList is null or empty!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR, null);
            }
            return;
        }
        if (chatRoomEntryList.size() > 10) {
            RLog.e((String)TAG, (String)"deleteChatRoomEntries: The maximum map size is 10");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.KV_STORE_OUT_OF_LIMIT, null);
            }
            return;
        }
        HashMap<String, IRongCoreEnum.CoreErrorCode> failMap = new HashMap<String, IRongCoreEnum.CoreErrorCode>();
        for (String key : chatRoomEntryList) {
            if (!TextUtils.isEmpty((CharSequence)key) && key.matches("^[A-Za-z0-9+_=-]+$")) continue;
            failMap.put(key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
        }
        if (!failMap.isEmpty()) {
            RLog.e((String)TAG, (String)"deleteChatRoomEntries: The chatRoomEntryList contains empty or invalid keys!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR, failMap);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ChatRoomHelper.getInstance().deleteChatRoomEntries(roomId, chatRoomEntryList, force, new ISetChatRoomKVCallbackListener.Stub(){

                            public void onSuccess() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.SetChatRoomKVCallback)ipcCallbackProxy.callback).onCallback();
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            public void onError(int coreErrorCode, Map failKV) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.SetChatRoomKVCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.valueOf((int)coreErrorCode), RongChatRoomClientImpl.this.obtainResultFailMap(failKV));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.SetChatRoomKVCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT, null);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    private Map<String, IRongCoreEnum.CoreErrorCode> obtainResultFailMap(Map failKV) {
        HashMap<String, IRongCoreEnum.CoreErrorCode> resultFailKV = new HashMap<String, IRongCoreEnum.CoreErrorCode>();
        if (failKV != null && !failKV.isEmpty()) {
            Map failKVMap = failKV;
            for (Map.Entry entry : failKVMap.entrySet()) {
                if (!StringUtils.isWholeNumber((String)((String)entry.getValue()))) {
                    resultFailKV.put((String)entry.getKey(), IRongCoreEnum.CoreErrorCode.UNKNOWN);
                    continue;
                }
                resultFailKV.put((String)entry.getKey(), IRongCoreEnum.CoreErrorCode.valueOf((int)Integer.parseInt((String)entry.getValue())));
            }
        }
        return resultFailKV;
    }

    @Override
    public void getChatRoomEntry(final String chatRoomId, final String key, final IRongCoreCallback.ResultCallback<Map<String, String>> callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_KV_T.getTag(), (String)"roomId|key", (Object[])new Object[]{chatRoomId, key});
        if (TextUtils.isEmpty((CharSequence)chatRoomId) || TextUtils.isEmpty((CharSequence)key)) {
            RLog.e((String)TAG, (String)"getChatRoomEntry Parameter  chatRoomId or key is empty!");
            callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomHelper.getInstance().getChatRoomEntry(chatRoomId, key, (IStringCallback)new IStringCallback.Stub(){

                        public void onComplete(String value) {
                            HashMap<String, String> result = new HashMap<String, String>();
                            result.put(key, value);
                            callback.onSuccess(result);
                            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code|kv", (Object[])new Object[]{chatRoomId, key, 0, SystemUtils.mapToString(result)});
                        }

                        public void onFailure(int errorCode) {
                            callback.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode));
                            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, errorCode});
                        }
                    });
                }
                catch (Exception e) {
                    callback.onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                    FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.code});
                }
            }
        });
    }

    @Override
    public void getAllChatRoomEntries(final String chatRoomId, final IRongCoreCallback.ResultCallback<Map<String, String>> callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_ALL_KV_T.getTag(), (String)"roomId", (Object[])new Object[]{chatRoomId});
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            RLog.e((String)TAG, (String)"getAllChatRoomEntries chatRoomId  is empty!");
            callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_ALL_KV_R.getTag(), (String)"roomId|code", (Object[])new Object[]{chatRoomId, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomHelper.getInstance().getAllChatRoomEntries(chatRoomId, (IDataByBatchListener)new IDataByBatchListener.Stub(){
                        Map<String, String> result = new HashMap<String, String>();

                        public void onProgress(Map data) {
                            this.result.putAll(data);
                        }

                        public void onComplete() {
                            RLog.i((String)RongChatRoomClientImpl.TAG, (String)("getAllChatRoomEntries size =" + this.result.size()));
                            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_ALL_KV_R.getTag(), (String)"roomId|code|size|kv", (Object[])new Object[]{chatRoomId, 0, this.result.size(), SystemUtils.mapToString(this.result)});
                            if (RongChatRoomClientImpl.this.mKVFilter != null) {
                                int beforeCount = this.result.size();
                                Map<String, String> filteredMap = RongChatRoomClientImpl.this.mKVFilter.filterKVGetAllMap(chatRoomId, this.result);
                                if (filteredMap != null) {
                                    HashMap<String, String> tempMap = new HashMap<String, String>(filteredMap);
                                    this.result.clear();
                                    this.result.putAll(tempMap);
                                } else {
                                    this.result.clear();
                                }
                                FwLog.write((int)3, (int)1, (String)FwLog.LogTag.L_GET_CHATROOM_FILTER_ALL_KV.getTag(), (String)"roomId|before|after", (Object[])new Object[]{chatRoomId, beforeCount, this.result.size()});
                            }
                            if (callback != null) {
                                callback.onSuccess(this.result);
                            }
                        }

                        public void onError(int status) {
                            if (callback != null) {
                                callback.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)status));
                            }
                            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_ALL_KV_R.getTag(), (String)"roomId|code", (Object[])new Object[]{chatRoomId, status});
                        }
                    });
                }
                catch (Exception e) {
                    callback.onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                    FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_GET_CHATROOM_ALL_KV_R.getTag(), (String)"roomId|code", (Object[])new Object[]{chatRoomId, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.code});
                }
            }
        });
    }

    @Override
    public void removeChatRoomEntry(final String chatRoomId, final String key, final Boolean sendNotification, final String notificationExtra, IRongCoreCallback.OperationCallback callback) {
        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_REMOVE_CHATROOM_KV_T.getTag(), (String)"roomId|key|notify", (Object[])new Object[]{chatRoomId, key, sendNotification});
        if (TextUtils.isEmpty((CharSequence)chatRoomId) || TextUtils.isEmpty((CharSequence)key)) {
            RLog.e((String)TAG, (String)"removeChatRoomEntry chatRoomId or key is empty!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR.code});
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomHelper.getInstance().deleteChatRoomEntry(key, null, chatRoomId, sendNotification, notificationExtra, false, false, (IOperationCallback)new IOperationCallback.Stub(){

                        public void onComplete() throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onCallback();
                                ipcCallbackProxy.callback = null;
                            }
                            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, 0});
                        }

                        public void onFailure(int coreErrorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(coreErrorCode);
                                ipcCallbackProxy.callback = null;
                            }
                            FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, coreErrorCode});
                        }
                    });
                }
                catch (Exception e) {
                    if (ipcCallbackProxy.callback != null) {
                        ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    FwLog.write((int)2, (int)1, (String)FwLog.LogTag.A_REMOVE_CHATROOM_KV_R.getTag(), (String)"roomId|key|code", (Object[])new Object[]{chatRoomId, key, IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.code});
                }
            }
        });
    }

    @Override
    public void getChatRoomInfo(final String chatRoomId, final int defMemberCount, final ChatRoomInfo.ChatRoomMemberOrder order, IRongCoreCallback.ResultCallback<ChatRoomInfo> callback) {
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            RLog.e((String)TAG, (String)"'chatRoomId' in getChatRoomInfo() should not be null or empty!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (order == null) {
            RLog.e((String)TAG, (String)"'order' in getChatRoomInfo() should not be null!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy(callback);
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ChatRoomHelper.getInstance().getChatRoomInfo(chatRoomId, defMemberCount, order.getValue(), (IResultCallback)new IResultCallback.Stub(){

                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                ChatRoomInfo info = null;
                                if (model != null) {
                                    info = (ChatRoomInfo)model.getContent();
                                    info.setMemberOrder(order);
                                }
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onCallback((Object)info);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e((String)RongChatRoomClientImpl.TAG, (String)"getChatRoomInfo", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    @Override
    public void getChatroomHistoryMessages(final String targetId, final long recordTime, final int count, final IRongCoreEnum.TimestampOrder order, IRongCoreCallback.IChatRoomHistoryMessageCallback callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || order == null) {
            RLog.e((String)TAG, (String)"the parameter of targetId or order is null !");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (!this.mChatRoomCache.containsKey(targetId)) {
            RLog.e((String)TAG, (String)"targetId does not exist in the joined chatroom list");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ChatRoomHelper.getInstance().getChatroomHistoryMessages(targetId, recordTime, count, order.ordinal(), (IChatRoomHistoryMessageCallback)new IChatRoomHistoryMessageCallback.Stub(){

                            public void onComplete(final RemoteModelWrap model, final long syncTime) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (model != null) {
                                                RongListWrap rongListWrap = (RongListWrap)model.getContent();
                                                ((IRongCoreCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onSuccess(rongListWrap.getList(), syncTime);
                                            } else {
                                                ((IRongCoreCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onSuccess(null, syncTime);
                                            }
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            public void onFailure(final int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCoreCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e((String)RongChatRoomClientImpl.TAG, (String)"getChatroomHistoryMessages", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCoreCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onError(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    @Deprecated
    public void setKVStatusListener(RongChatRoomClient.KVStatusListener listener) {
        this.addKVStatusListener(listener);
    }

    @Override
    public boolean addKVStatusListener(RongChatRoomClient.KVStatusListener listener) {
        if (listener == null) {
            return false;
        }
        return sKVStatusListeners.add(listener);
    }

    @Override
    public boolean removeKVStatusListener(RongChatRoomClient.KVStatusListener listener) {
        return sKVStatusListeners.remove(listener);
    }

    private void setKVFilter(RongChatRoomClient.KVFilter filter) {
        this.mKVFilter = filter;
    }

    void reJoinChatRoomWithCache() {
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                int size = RongChatRoomClientImpl.this.mRetryCRCache.size();
                if (size > 0) {
                    RLog.d((String)RongChatRoomClientImpl.TAG, (String)("clear retry chatroom cache after connectivity available, cached size = " + size));
                    for (ChatRoomCacheRunnable runnable : RongChatRoomClientImpl.this.mRetryCRCache.values()) {
                        ExecutorFactory.getInstance().getWorkExecutor().remove(runnable);
                    }
                    RongChatRoomClientImpl.this.mRetryCRCache.clear();
                }
                if ((size = RongChatRoomClientImpl.this.mChatRoomCache.size()) > 0) {
                    RLog.d((String)RongChatRoomClientImpl.TAG, (String)("re-join chatroom after connectivity available, cached size = " + size));
                    for (ChatRoomCacheRunnable runnable : RongChatRoomClientImpl.this.mChatRoomCache.values()) {
                        ExecutorFactory.getInstance().getWorkExecutor().execute(runnable);
                    }
                }
            }
        });
    }

    void onDisconnect() {
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                RongChatRoomClientImpl.this.mChatRoomCache.clear();
                for (ChatRoomCacheRunnable runnable : RongChatRoomClientImpl.this.mRetryCRCache.values()) {
                    ExecutorFactory.getInstance().getWorkExecutor().remove(runnable);
                }
                RongChatRoomClientImpl.this.mRetryCRCache.clear();
            }
        });
    }

    static ChatRoomConfig chatRoomConfigForInterior() {
        return RongChatRoomClientImpl.getInstanceForInterior().chatRoomConfig;
    }

    static {
        sChatRoomActionListener = new AtomicReference();
        sKVStatusListeners = new CopyOnWriteArrayList<RongChatRoomClient.KVStatusListener>();
    }

    class MyBindResultCallback
    extends IRongCoreCallback.DefaultResultCallback {
        private final String chatRoomId;
        protected final String RTCRoomId;

        public MyBindResultCallback(String chatRoomId, String RTCRoomId, IpcCallbackProxy<IRongCoreCallback.OperationCallback> ipcCallbackProxy) {
            super(ipcCallbackProxy);
            this.chatRoomId = chatRoomId;
            this.RTCRoomId = RTCRoomId;
        }

        public void onComplete(int code) {
            FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_BIND_CHATROOM_4_RTC_ROOM_R.getTag(), (String)"code|room_id|rtc_room", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue(), this.chatRoomId, this.RTCRoomId});
            super.onComplete(code);
        }

        public void onFailure(int errorCode) {
            FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_BIND_CHATROOM_4_RTC_ROOM_R.getTag(), (String)"code|room_id|rtc_room|errorCode", (Object[])new Object[]{IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT.getValue(), this.chatRoomId, this.RTCRoomId, errorCode});
            super.onFailure(errorCode);
        }
    }

    private class JoinChatRoomCallback
    extends IRongCoreCallback.DefaultResultCallback {
        private final String chatRoomId;
        private final int count;
        private final boolean chatRoomIdExist;
        private final boolean isRejoin;
        private final int joinMode;

        JoinChatRoomCallback(IpcCallbackProxy<IRongCoreCallback.OperationCallback> ipcCallbackProxy, String chatRoomId, int count, boolean joinMultiCR, boolean chatRoomIdExist, boolean isRejoin, int joinMode) {
            super(ipcCallbackProxy);
            this.chatRoomId = chatRoomId;
            this.count = count;
            this.chatRoomIdExist = chatRoomIdExist;
            this.isRejoin = isRejoin;
            this.joinMode = joinMode;
            if (!joinMultiCR) {
                RongChatRoomClientImpl.this.mChatRoomCache.clear();
            }
            RongChatRoomClientImpl.this.mChatRoomCache.put(chatRoomId, new ChatRoomCacheRunnable(chatRoomId, count, chatRoomIdExist, joinMode));
            RLog.d((String)RongChatRoomClientImpl.TAG, (String)((Object)((Object)this) + "; joinMultiCR = " + joinMultiCR));
        }

        public void onComplete(int code) {
            ChatRoomCacheRunnable runnable;
            super.onComplete(code);
            FwLog.write((int)3, (int)1, (String)(this.isRejoin ? FwLog.LogTag.A_REJOIN_CHATROOM_R.getTag() : FwLog.LogTag.A_JOIN_CHATROOM_R.getTag()), (String)"code|room_id", (Object[])new Object[]{0, this.chatRoomId});
            RLog.d((String)RongChatRoomClientImpl.TAG, (String)("onComplete: " + (Object)((Object)this)));
            RongChatRoomClient.ChatRoomActionListener listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get();
            if (code == IRongCoreEnum.CoreErrorCode.RC_CHATROOM_RESET.code) {
                RLog.i((String)RongChatRoomClientImpl.TAG, (String)("Chat room reset,chatRoomId=" + this.chatRoomId));
                if (sChatRoomAdvancedActionListener != null) {
                    sChatRoomAdvancedActionListener.onReset(this.chatRoomId);
                }
            }
            if ((runnable = (ChatRoomCacheRunnable)RongChatRoomClientImpl.this.mChatRoomCache.get(this.chatRoomId)) != null) {
                runnable.onceSuccess = true;
            }
            if (listener != null) {
                listener.onJoined(this.chatRoomId);
            }
            if (sChatRoomAdvancedActionListener != null) {
                sChatRoomAdvancedActionListener.onJoined(this.chatRoomId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(int errorCode) {
            super.onFailure(errorCode);
            FwLog.write((int)1, (int)1, (String)(this.isRejoin ? FwLog.LogTag.A_REJOIN_CHATROOM_R.getTag() : FwLog.LogTag.A_JOIN_CHATROOM_R.getTag()), (String)"code|room_id", (Object[])new Object[]{errorCode, this.chatRoomId});
            IRongCoreEnum.CoreErrorCode ec = IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode);
            if (!(ec.equals((Object)IRongCoreEnum.CoreErrorCode.RC_CHATROOM_NOT_EXIST) || ec.equals((Object)IRongCoreEnum.CoreErrorCode.RC_CHATROOM_IS_FULL) || ec.equals((Object)IRongCoreEnum.CoreErrorCode.RC_OPERATION_BLOCKED) || ec.equals((Object)IRongCoreEnum.CoreErrorCode.KICKED_FROM_CHATROOM))) {
                RLog.e((String)RongChatRoomClientImpl.TAG, (String)("join chatroom " + this.chatRoomId + " error: " + errorCode + ", re-join after 2s"));
                final ChatRoomCacheRunnable runnable = new ChatRoomCacheRunnable(this.chatRoomId, this.count, this.chatRoomIdExist, this.joinMode);
                RongChatRoomClientImpl.this.mRetryCRCache.put(this.chatRoomId, runnable);
                long interval = 2000L;
                FwLog.write((int)4, (int)1, (String)FwLog.LogTag.A_REJOIN_CHATROOM_S.getTag(), (String)"retry_after", (Object[])new Object[]{interval});
                JoinChatRoomCallback joinChatRoomCallback = this;
                synchronized (joinChatRoomCallback) {
                    if (RongChatRoomClientImpl.this.timer == null) {
                        RongChatRoomClientImpl.this.timer = new Timer("CHATROOM");
                    }
                }
                RongChatRoomClientImpl.this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ExecutorFactory.getInstance().getWorkExecutor().execute(runnable);
                    }
                }, interval);
            } else {
                RLog.e((String)RongChatRoomClientImpl.TAG, (String)("join chatroom " + this.chatRoomId + " error : " + ec));
            }
            RongChatRoomClient.ChatRoomActionListener listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get();
            if (listener != null) {
                listener.onError(this.chatRoomId, IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode));
            }
            if (sChatRoomAdvancedActionListener != null) {
                sChatRoomAdvancedActionListener.onError(this.chatRoomId, IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode));
            }
        }

        public String toString() {
            return "JoinChatRoomCallback{chatRoomId='" + this.chatRoomId + '\'' + ", count=" + this.count + ", chatRoomIdExist=" + this.chatRoomIdExist + '}';
        }
    }

    private class ChatRoomCacheRunnable
    implements Runnable {
        String chatRoomId;
        int count;
        boolean onceSuccess;
        boolean chatRoomIdExist;
        int joinMode;

        ChatRoomCacheRunnable(String chatRoomId, int count, boolean chatRoomIdExist, int joinMode) {
            this.count = count;
            this.chatRoomId = chatRoomId;
            this.chatRoomIdExist = chatRoomIdExist;
            this.joinMode = joinMode;
        }

        @Override
        public void run() {
            block7: {
                RLog.d((String)RongChatRoomClientImpl.TAG, (String)("re-join chatroom " + this));
                RongChatRoomClientImpl.this.mRetryCRCache.remove(this.chatRoomId);
                if (RongCoreClient.getInstance().getCurrentConnectionStatus().equals((Object)IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
                    try {
                        IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy(null);
                        RongChatRoomClient.ChatRoomActionListener listener = (RongChatRoomClient.ChatRoomActionListener)sChatRoomActionListener.get();
                        if (listener != null) {
                            listener.onJoining(this.chatRoomId);
                        }
                        if (sChatRoomAdvancedActionListener != null) {
                            sChatRoomAdvancedActionListener.onJoining(this.chatRoomId);
                        }
                        FwLog.write((int)3, (int)1, (String)FwLog.LogTag.A_REJOIN_CHATROOM_T.getTag(), (String)"room_id|existed|count", (Object[])new Object[]{this.chatRoomId, this.chatRoomIdExist, this.onceSuccess ? -1 : this.count});
                        if (this.chatRoomIdExist) {
                            ChatRoomHelper.getInstance().joinExistChatRoom(this.chatRoomId, this.onceSuccess ? -1 : this.count, (IChatRoomOperationCallback)new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, this.chatRoomId, this.count, ChatRoomHelper.getInstance().getJoinMultiChatRoomEnable(), this.chatRoomIdExist, true, this.joinMode), true, this.joinMode);
                            break block7;
                        }
                        ChatRoomHelper.getInstance().reJoinChatRoom(this.chatRoomId, this.onceSuccess ? -1 : this.count, (IChatRoomOperationCallback)new JoinChatRoomCallback((IpcCallbackProxy<IRongCoreCallback.OperationCallback>)ipcCallbackProxy, this.chatRoomId, this.count, ChatRoomHelper.getInstance().getJoinMultiChatRoomEnable(), this.chatRoomIdExist, true, this.joinMode), this.joinMode);
                    }
                    catch (Exception e) {
                        FwLog.write((int)1, (int)1, (String)FwLog.LogTag.A_REJOIN_CHATROOM_R.getTag(), (String)"code|room_id|stacks", (Object[])new Object[]{-1, this.chatRoomId, FwLog.stackToString((Throwable)e)});
                        RLog.e((String)RongChatRoomClientImpl.TAG, (String)"ChatRoomCacheRunnable", (Throwable)e);
                        RLog.e((String)RongChatRoomClientImpl.TAG, (String)"re-join chatroom exception");
                    }
                } else {
                    RLog.e((String)RongChatRoomClientImpl.TAG, (String)("re-join chatroom error : " + RongCoreClient.getInstance().getCurrentConnectionStatus()));
                }
            }
        }

        public String toString() {
            return "ChatRoomCacheRunnable{chatRoomId='" + this.chatRoomId + '\'' + ", count=" + this.count + ", onceSuccess=" + this.onceSuccess + ", chatRoomIdExist=" + this.chatRoomIdExist + ", state='" + RongCoreClient.getInstance().getCurrentConnectionStatus() + '\'' + '}';
        }
    }

    private static class SingletonHolder {
        static RongChatRoomClientImpl sInstance = new RongChatRoomClientImpl();

        private SingletonHolder() {
        }
    }
}

