/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:chrmKVNotiMsg", flag=0)
public class ChatRoomKVNotiMessage
extends MessageContent {
    private static final String TAG = "ChatRoomKVNotiMessage";
    private String key;
    private String value;
    private int type;
    public static final Parcelable.Creator<ChatRoomKVNotiMessage> CREATOR = new Parcelable.Creator<ChatRoomKVNotiMessage>(){

        public ChatRoomKVNotiMessage createFromParcel(Parcel source) {
            return new ChatRoomKVNotiMessage(source);
        }

        public ChatRoomKVNotiMessage[] newArray(int size) {
            return new ChatRoomKVNotiMessage[size];
        }
    };

    public int getType() {
        return this.type;
    }

    public void setType(NotificationType type) {
        this.type = type.value;
    }

    @Deprecated
    public void setType(int type) {
        this.type = type;
    }

    public static String getTAG() {
        return TAG;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ChatRoomKVNotiMessage(Parcel in) {
        this.key = ParcelUtils.readFromParcel((Parcel)in);
        this.value = ParcelUtils.readFromParcel((Parcel)in);
        this.setExtra(ParcelUtils.readFromParcel((Parcel)in));
        this.type = ParcelUtils.readIntFromParcel((Parcel)in);
    }

    public ChatRoomKVNotiMessage(byte[] data) {
        String jsonStr = new String(data, StandardCharsets.UTF_8);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.setKey(jsonObj.optString("key"));
            this.setValue(jsonObj.optString("value"));
            this.setExtra(jsonObj.optString("extra"));
            this.setType(NotificationType.valueOf(jsonObj.optInt("type")));
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    @Deprecated
    public static ChatRoomKVNotiMessage obtain(String key, String value, int type, String extra) {
        if (type != NotificationType.TYPE_SET_KEY.value || type != NotificationType.TYPE_DELETE_KEY.value) {
            throw new IllegalArgumentException("type value should be 1 or 2.");
        }
        ChatRoomKVNotiMessage obj = new ChatRoomKVNotiMessage();
        obj.key = key;
        obj.value = value;
        obj.setExtra(extra);
        obj.type = type;
        return obj;
    }

    public static ChatRoomKVNotiMessage obtain(String key, String value, NotificationType type, String extra) {
        ChatRoomKVNotiMessage obj = new ChatRoomKVNotiMessage();
        obj.key = key;
        obj.value = value;
        obj.setExtra(extra);
        obj.type = type.value;
        return obj;
    }

    private ChatRoomKVNotiMessage() {
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("key", (Object)this.key);
            jsonObj.put("value", (Object)this.value);
            jsonObj.put("extra", (Object)this.getExtra());
            jsonObj.put("type", this.type);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
        return jsonObj.toString().getBytes(StandardCharsets.UTF_8);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.key);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.value);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.getExtra());
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.type);
    }

    public static enum NotificationType {
        TYPE_SET_KEY(1),
        TYPE_DELETE_KEY(2);

        int value;

        private NotificationType(int value) {
            this.value = value;
        }

        public static NotificationType valueOf(int value) {
            if (value == NotificationType.TYPE_SET_KEY.value) {
                return TYPE_SET_KEY;
            }
            if (value == NotificationType.TYPE_DELETE_KEY.value) {
                return TYPE_DELETE_KEY;
            }
            RLog.e((String)ChatRoomKVNotiMessage.TAG, (String)"Invalid value. Transfer to default type TYPE_SET_KEY");
            return TYPE_SET_KEY;
        }
    }
}

