/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.chatroom.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.ChatRoomMemberAction;
import io.rong.imlib.model.MessageContent;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

@MessageTag(value="RC:ChrmMemChange", flag=16)
public class ChatRoomMemberActionMessage
extends MessageContent {
    private static final String TAG = "ChatRoomMemberChangeMessage";
    private static final String JSON_FIELD_USER_LIST = "userList";
    private List<ChatRoomMemberAction> chatRoomMemberActions;
    public static final Parcelable.Creator<ChatRoomMemberActionMessage> CREATOR = new Parcelable.Creator<ChatRoomMemberActionMessage>(){

        public ChatRoomMemberActionMessage createFromParcel(Parcel source) {
            return new ChatRoomMemberActionMessage(source);
        }

        public ChatRoomMemberActionMessage[] newArray(int size) {
            return new ChatRoomMemberActionMessage[size];
        }
    };

    protected ChatRoomMemberActionMessage() {
    }

    public ChatRoomMemberActionMessage(byte[] data) {
        if (data == null) {
            RLog.e((String)TAG, (String)"data is null ");
            return;
        }
        String jsonStr = new String(data, StandardCharsets.UTF_8);
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            RLog.e((String)TAG, (String)"jsonStr is null or empty!");
            return;
        }
        try {
            JSONArray jsonArray;
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has(JSON_FIELD_USER_LIST) && (jsonArray = jsonObj.optJSONArray(JSON_FIELD_USER_LIST)) != null) {
                ArrayList<ChatRoomMemberAction> chatRoomMemberActions = new ArrayList<ChatRoomMemberAction>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject userJSONObject = jsonArray.getJSONObject(i);
                    String userId = userJSONObject.optString("userId");
                    int status = userJSONObject.optInt("status");
                    ChatRoomMemberAction chatRoomMemberAction = new ChatRoomMemberAction(userId, ChatRoomMemberAction.ChatRoomMemberActionType.valueOf(status));
                    chatRoomMemberActions.add(chatRoomMemberAction);
                }
                this.setChatRoomMembers(chatRoomMemberActions);
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.optString("extra"));
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public byte[] encode() {
        if (this.chatRoomMemberActions == null || this.chatRoomMemberActions.isEmpty()) {
            return new byte[0];
        }
        JSONObject jsonObj = new JSONObject();
        try {
            JSONArray userJSONArray = new JSONArray();
            for (int i = 0; i < this.chatRoomMemberActions.size(); ++i) {
                JSONObject userISONObject = new JSONObject();
                if (this.chatRoomMemberActions.get(i) == null) continue;
                userISONObject.put("userId", (Object)this.chatRoomMemberActions.get(i).getUserId());
                ChatRoomMemberAction.ChatRoomMemberActionType chatRoomMemberActionType = this.chatRoomMemberActions.get(i).getChatRoomMemberAction();
                userISONObject.put("status", chatRoomMemberActionType == null ? ChatRoomMemberAction.ChatRoomMemberActionType.UNKNOWN.getValue() : chatRoomMemberActionType.getValue());
                userJSONArray.put((Object)userISONObject);
            }
            jsonObj.put(JSON_FIELD_USER_LIST, (Object)userJSONArray);
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
        return jsonObj.toString().getBytes(StandardCharsets.UTF_8);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeListToParcel((Parcel)dest, this.getChatRoomMembers());
    }

    public ChatRoomMemberActionMessage(Parcel in) {
        this.setChatRoomMembers(ParcelUtils.readListFromParcel((Parcel)in, ChatRoomMemberAction.class));
    }

    public List<ChatRoomMemberAction> getChatRoomMembers() {
        return this.chatRoomMemberActions;
    }

    public void setChatRoomMembers(List<ChatRoomMemberAction> chatRoomMemberActions) {
        this.chatRoomMemberActions = chatRoomMemberActions;
    }
}

