/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.cs.base;

import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.cs.CustomServiceConfig;
import io.rong.imlib.cs.CustomServiceManager;
import io.rong.imlib.cs.ICustomServiceListener;
import io.rong.imlib.cs.model.CSCustomServiceInfo;
import java.util.Map;

public class RongCustomServiceClient {
    private static final String TAG = "RongCustomServiceClient";

    private RongCustomServiceClient() {
    }

    public static RongCustomServiceClient getInstance() {
        return SingletonHolder.sInstance;
    }

    public void startCustomService(String kefuId, ICustomServiceListener listener, CSCustomServiceInfo customServiceInfo) {
        CustomServiceManager.getInstance().startCustomService(kefuId, listener, customServiceInfo);
    }

    public void selectCustomServiceGroup(String kefuId, String groupId) {
        this.sendChangeModelMessage(kefuId, groupId);
    }

    private void sendChangeModelMessage(String kefuId, String groupId) {
        CustomServiceManager.getInstance().sendChangeModelMessage(kefuId, groupId);
    }

    public void switchToHumanMode(String kefuId) {
        CustomServiceManager.getInstance().switchToHumanMode(kefuId);
    }

    public void evaluateCustomService(String kefuId, boolean isRobotResolved, String knowledgeId) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, isRobotResolved, knowledgeId);
    }

    public void evaluateCustomService(String kefuId, int source, String suggest, String dialogId) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, source, CustomServiceConfig.CSEvaSolveStatus.RESOLVED, suggest, dialogId);
    }

    public void evaluateCustomService(String kefuId, int source, CustomServiceConfig.CSEvaSolveStatus resolvestatus, String tagText, String suggest, String dialogId, String extra) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, source, resolvestatus, tagText, suggest, dialogId, extra);
    }

    public void evaluateCustomService(String kefuId, int source, CustomServiceConfig.CSEvaSolveStatus solveStatus, String suggest, String dialogId) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, source, solveStatus, suggest, dialogId);
    }

    public void leaveMessageCustomService(String kefuId, Map<String, String> contentMap, IRongCoreCallback.OperationCallback operationCallback) {
        CustomServiceManager.getInstance().leaveMessageToCustomService(kefuId, contentMap, operationCallback);
    }

    public void stopCustomService(String kefuId) {
        CustomServiceManager.getInstance().stopCustomService(kefuId);
    }

    public void setCustomServiceHumanEvaluateListener(CustomServiceManager.OnHumanEvaluateListener listener) {
        CustomServiceManager.getInstance().setHumanEvaluateListener(listener);
    }

    private static class SingletonHolder {
        static RongCustomServiceClient sInstance = new RongCustomServiceClient();

        private SingletonHolder() {
        }
    }
}

