/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.cs.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.nio.charset.StandardCharsets;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:CsChaR", flag=0)
public class CSChangeModeResponseMessage
extends MessageContent {
    private static final String TAG = "CSChangeModeResponseMessage";
    private int code;
    private int status;
    private String errMsg;
    private String evaluation;
    public static final Parcelable.Creator<CSChangeModeResponseMessage> CREATOR = new Parcelable.Creator<CSChangeModeResponseMessage>(){

        public CSChangeModeResponseMessage createFromParcel(Parcel source) {
            return new CSChangeModeResponseMessage(source);
        }

        public CSChangeModeResponseMessage[] newArray(int size) {
            return new CSChangeModeResponseMessage[size];
        }
    };

    public CSChangeModeResponseMessage() {
    }

    public int getResult() {
        return this.code;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getStatus() {
        return this.status;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public CSChangeModeResponseMessage(byte[] data) {
        String jsonStr = new String(data, StandardCharsets.UTF_8);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.code = jsonObj.optInt("code");
            this.errMsg = jsonObj.optString("msg");
            if (jsonObj.has("data")) {
                jsonObj = jsonObj.getJSONObject("data");
                this.status = jsonObj.getInt("status");
                if (jsonObj.has("satisfaction")) {
                    JSONArray jsonArray = jsonObj.getJSONArray("satisfaction");
                    JSONObject evaJsonObject = new JSONObject();
                    JSONObject satisJsonObject = new JSONObject();
                    satisJsonObject.put("satisfaction", (Object)jsonArray);
                    evaJsonObject.put("evaluation", (Object)satisJsonObject);
                    this.evaluation = evaJsonObject.toString();
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static CSChangeModeResponseMessage obtain() {
        return new CSChangeModeResponseMessage();
    }

    public CSChangeModeResponseMessage(Parcel in) {
        this.code = ParcelUtils.readIntFromParcel((Parcel)in);
        this.status = ParcelUtils.readIntFromParcel((Parcel)in);
        this.errMsg = ParcelUtils.readFromParcel((Parcel)in);
        this.evaluation = ParcelUtils.readFromParcel((Parcel)in);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.code);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.status);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.errMsg);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.evaluation);
    }

    public byte[] encode() {
        return new byte[0];
    }
}

