/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.cs.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:CsUpdate", flag=0)
public class CSUpdateMessage
extends MessageContent {
    private static final String TAG = "CSUpdateMessage";
    private String sid;
    private String serviceStatus;
    public static final Parcelable.Creator<CSUpdateMessage> CREATOR = new Parcelable.Creator<CSUpdateMessage>(){

        public CSUpdateMessage createFromParcel(Parcel source) {
            return new CSUpdateMessage(source);
        }

        public CSUpdateMessage[] newArray(int size) {
            return new CSUpdateMessage[size];
        }
    };

    public CSUpdateMessage() {
    }

    public String getSid() {
        return this.sid;
    }

    public String getServiceStatus() {
        return this.serviceStatus;
    }

    public CSUpdateMessage(byte[] data) {
        String jsonStr = new String(data, StandardCharsets.UTF_8);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.sid = jsonObj.optString("sid");
            this.serviceStatus = jsonObj.optString("serviceStatus");
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public static CSUpdateMessage obtain(String sid, String serviceStatus) {
        CSUpdateMessage message = new CSUpdateMessage();
        message.sid = sid;
        message.serviceStatus = serviceStatus;
        return message;
    }

    public CSUpdateMessage(Parcel in) {
        this.sid = ParcelUtils.readFromParcel((Parcel)in);
        this.serviceStatus = ParcelUtils.readFromParcel((Parcel)in);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.sid);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.serviceStatus);
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("sid", (Object)this.sid);
            jsonObj.put("serviceStatus", (Object)this.serviceStatus);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
        return jsonObj.toString().getBytes(StandardCharsets.UTF_8);
    }
}

