/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.location;

import android.content.Context;
import android.content.res.Resources;
import android.os.Message;
import io.rong.common.RLog;
import io.rong.imlib.IHandler;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.ModuleManager;
import io.rong.imlib.RongCoreClient;
import io.rong.imlib.location.RealTimeLocation;
import io.rong.imlib.location.RealTimeLocationConstant;
import io.rong.imlib.location.RealTimeLocationObserver;
import io.rong.imlib.location.RealTimeLocationType;
import io.rong.imlib.location.message.RealTimeLocationJoinMessage;
import io.rong.imlib.location.message.RealTimeLocationQuitMessage;
import io.rong.imlib.location.message.RealTimeLocationStartMessage;
import io.rong.imlib.location.message.RealTimeLocationStatusMessage;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RealTimeLocationManager
implements RealTimeLocation.OnRealTimeLocationQuitListener {
    private static final String TAG = RealTimeLocationManager.class.getSimpleName();
    private static final int TIMEOUT_INTERVAL = 30000;
    private static final int DEFALUT_MAX_PERTICIPANT = 5;
    private Context mContext;
    private HashMap<String, RealTimeInstance> mInsMap = new HashMap();
    private List<Class<? extends MessageContent>> mRtMessages = new ArrayList<Class<? extends MessageContent>>();
    private boolean mInitialized = false;
    private int maxParticipants = 5;
    private String[] supportConversationTypes = null;
    private IRongCoreListener.OnReceiveMessageListener mReceiveMessageListener;

    private RealTimeLocationManager() {
    }

    public void init(Context context, IRongCoreListener.OnReceiveMessageListener listener, IHandler stub) {
        RLog.i((String)TAG, (String)("init " + this.mInitialized));
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.mContext = context;
            this.mRtMessages.add(RealTimeLocationStartMessage.class);
            this.mRtMessages.add(RealTimeLocationJoinMessage.class);
            this.mRtMessages.add(RealTimeLocationQuitMessage.class);
            this.mRtMessages.add(RealTimeLocationStatusMessage.class);
            this.mReceiveMessageListener = listener;
            ModuleManager.addMessageRouter((ModuleManager.MessageRouter)new ModuleManager.MessageRouter(){

                public boolean onReceived(io.rong.imlib.model.Message message, int left, boolean offline, int cmdLeft) {
                    boolean contains = RealTimeLocationManager.this.mRtMessages.contains(message.getContent().getClass());
                    long sentTime = RealTimeLocationManager.this.getDeltaTime(message.getSentTime());
                    if (contains && sentTime < 30000L && left == 0) {
                        MessageContent content = message.getContent();
                        if (content instanceof RealTimeLocationStartMessage) {
                            RealTimeLocation rt = RealTimeLocationManager.this.getRealTimeLocation(message.getConversationType(), message.getTargetId());
                            Message msg = Message.obtain();
                            msg.what = 3;
                            msg.obj = message.getSenderUserId();
                            rt.sendMessage(msg);
                            return false;
                        }
                        if (content instanceof RealTimeLocationJoinMessage) {
                            RealTimeLocation rt = RealTimeLocationManager.this.getRealTimeLocation(message.getConversationType(), message.getTargetId());
                            Message msg = Message.obtain();
                            msg.what = 4;
                            msg.obj = message.getSenderUserId();
                            rt.sendMessage(msg);
                        } else if (content instanceof RealTimeLocationQuitMessage) {
                            RealTimeInstance rtIns = (RealTimeInstance)RealTimeLocationManager.this.mInsMap.get(message.getConversationType().getName() + message.getTargetId());
                            if (rtIns != null && rtIns.realTimeLocation != null) {
                                Message msg = Message.obtain();
                                msg.what = 5;
                                msg.obj = message.getSenderUserId();
                                rtIns.realTimeLocation.sendMessage(msg);
                            }
                        } else if (content instanceof RealTimeLocationStatusMessage) {
                            RealTimeLocation rt = RealTimeLocationManager.this.getRealTimeLocation(message.getConversationType(), message.getTargetId());
                            Message msg = Message.obtain();
                            msg.what = 6;
                            msg.obj = message;
                            rt.sendMessage(msg);
                        }
                    }
                    return contains;
                }
            });
            ModuleManager.addConnectivityStateChangedListener((ModuleManager.ConnectivityStateChangedListener)new ModuleManager.ConnectivityStateChangedListener(){

                public void onChanged(IRongCoreListener.ConnectionStatusListener.ConnectionStatus state) {
                    if (state != null && (state.equals((Object)IRongCoreListener.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT) || state.equals((Object)IRongCoreListener.ConnectionStatusListener.ConnectionStatus.USER_ABANDON))) {
                        Collection collections = RealTimeLocationManager.this.mInsMap.values();
                        for (RealTimeInstance rt : collections) {
                            if (rt.realTimeLocation == null || rt.realTimeLocation.getHandler() == null) continue;
                            rt.realTimeLocation.getHandler().sendEmptyMessage(13);
                        }
                    }
                }
            });
            Resources resources = this.mContext.getResources();
            try {
                this.maxParticipants = resources.getInteger(resources.getIdentifier("rc_max_realtime_location_participants", "integer", this.mContext.getPackageName()));
            }
            catch (Resources.NotFoundException e) {
                this.maxParticipants = 5;
            }
            try {
                this.supportConversationTypes = resources.getStringArray(resources.getIdentifier("rc_realtime_support_conversation_types", "array", context.getPackageName()));
            }
            catch (Exception e) {
                RLog.w((String)TAG, (String)"No conversation type is setup for realtime location.");
            }
        }
    }

    private long getDeltaTime(long sentTime) {
        long deltaTime = RongCoreClient.getInstance().getDeltaTime();
        long normalTime = System.currentTimeMillis() - deltaTime;
        return normalTime - sentTime;
    }

    public static RealTimeLocationManager getInstance() {
        return SingletonHolder.sIns;
    }

    @Override
    public void onRealTimeLocationQuit(Conversation.ConversationType type, String targetId) {
        RealTimeInstance realTimeInstance = this.mInsMap.get(type.getName() + targetId);
        if (realTimeInstance != null) {
            realTimeInstance.realTimeLocation.destroy();
            realTimeInstance.realTimeLocation = null;
        }
    }

    private RealTimeLocation getRealTimeLocation(Conversation.ConversationType type, String targetId) {
        String key = type.getName() + targetId;
        RealTimeInstance rtIns = this.mInsMap.get(key);
        if (rtIns == null) {
            rtIns = new RealTimeInstance();
            this.mInsMap.put(key, rtIns);
        }
        if (rtIns.realTimeLocation == null) {
            rtIns.realTimeLocation = new RealTimeLocation(this.mContext, type, targetId, this.mReceiveMessageListener);
            rtIns.realTimeLocation.addListener(rtIns.observer);
            rtIns.realTimeLocation.setOnRealTimeLocationQuitListener(this);
        }
        return rtIns.realTimeLocation;
    }

    public int setupRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        int errorCode = 0;
        String key = conversationType.getName() + targetId;
        if (this.supportConversationTypes != null) {
            for (String type : this.supportConversationTypes) {
                if (!conversationType.getName().equals(type)) continue;
                RealTimeInstance rtIns = this.mInsMap.get(key);
                if (rtIns != null && rtIns.realTimeLocation != null && !rtIns.realTimeLocation.getRealTimeLocationCurrentState().equals((Object)RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_IDLE)) {
                    errorCode = RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_IS_ON_GOING.getValue();
                }
                return errorCode;
            }
        } else if (conversationType.equals((Object)Conversation.ConversationType.PRIVATE)) {
            RealTimeInstance rtIns = this.mInsMap.get(key);
            if (rtIns != null && rtIns.realTimeLocation != null && !rtIns.realTimeLocation.getRealTimeLocationCurrentState().equals((Object)RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_IDLE)) {
                errorCode = RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_IS_ON_GOING.getValue();
            }
            return errorCode;
        }
        return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_CONVERSATION_NOT_SUPPORT.getValue();
    }

    public int startRealTimeLocation(Conversation.ConversationType type, String targetId) {
        RealTimeInstance rtIns;
        boolean typeIsDefined = false;
        String key = type.getName() + targetId;
        RLog.i((String)TAG, (String)("startRealTimeLocation " + key));
        if (this.supportConversationTypes != null || !type.equals((Object)Conversation.ConversationType.PRIVATE)) {
            if (this.supportConversationTypes != null) {
                for (String defType : this.supportConversationTypes) {
                    if (!type.getName().equals(defType)) continue;
                    typeIsDefined = true;
                }
            }
            if (!typeIsDefined) {
                return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_CONVERSATION_NOT_SUPPORT.getValue();
            }
        }
        if ((rtIns = this.mInsMap.get(key)) == null) {
            rtIns = new RealTimeInstance();
            this.mInsMap.put(key, rtIns);
        }
        if (rtIns.realTimeLocation == null) {
            rtIns.realTimeLocation = new RealTimeLocation(this.mContext, type, targetId, this.mReceiveMessageListener);
            rtIns.realTimeLocation.addListener(rtIns.observer);
            rtIns.realTimeLocation.setOnRealTimeLocationQuitListener(this);
        }
        rtIns.realTimeLocation.sendMessage(0);
        if (!rtIns.realTimeLocation.gpsIsAvailable()) {
            return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_GPS_DISABLED.getValue();
        }
        return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_SUCCESS.getValue();
    }

    public int joinRealTimeLocation(Conversation.ConversationType type, String targetId) {
        RealTimeInstance rtIns = this.mInsMap.get(type.getName() + targetId);
        RLog.i((String)TAG, (String)("joinRealTimeLocation " + type.getName() + targetId));
        if (rtIns == null || rtIns.realTimeLocation == null) {
            RLog.e((String)TAG, (String)"joinRealTimeLocation No instance!");
            return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_NOT_INIT.getValue();
        }
        List<String> participants = this.getRealTimeLocationParticipants(type, targetId);
        if (participants != null && this.maxParticipants <= participants.size()) {
            return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_EXCEED_MAX_PARTICIPANT.getValue();
        }
        rtIns.realTimeLocation.sendMessage(1);
        if (!rtIns.realTimeLocation.gpsIsAvailable()) {
            return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_GPS_DISABLED.getValue();
        }
        return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_SUCCESS.getValue();
    }

    public void quitRealTimeLocation(Conversation.ConversationType type, String targetId) {
        RealTimeInstance rtIns = this.mInsMap.get(type.getName() + targetId);
        RLog.i((String)TAG, (String)("quitRealTimeLocation " + type.getName() + targetId));
        if (rtIns == null || rtIns.realTimeLocation == null || rtIns.observer == null) {
            return;
        }
        rtIns.realTimeLocation.sendMessage(2);
        rtIns.observer.onParticipantsQuit(targetId);
        rtIns.observer.onStatusChange(RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_INCOMING);
    }

    public List<String> getRealTimeLocationParticipants(Conversation.ConversationType type, String targetId) {
        RealTimeInstance rtIns = this.mInsMap.get(type.getName() + targetId);
        if (rtIns == null || rtIns.realTimeLocation == null) {
            return Collections.emptyList();
        }
        return rtIns.realTimeLocation.getParticipants();
    }

    public RealTimeLocationConstant.RealTimeLocationStatus getRealTimeLocationCurrentState(Conversation.ConversationType type, String targetId) {
        RealTimeInstance rtIns = this.mInsMap.get(type.getName() + targetId);
        if (rtIns == null || rtIns.realTimeLocation == null) {
            return RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_IDLE;
        }
        return rtIns.realTimeLocation.getRealTimeLocationCurrentState();
    }

    public void addListener(Conversation.ConversationType type, String targetId, RealTimeLocationObserver observer) {
        RLog.i((String)TAG, (String)"addListener");
        String key = type.getName() + targetId;
        RealTimeInstance rtIns = this.mInsMap.get(key);
        if (rtIns != null) {
            rtIns.observer = observer;
        } else {
            rtIns = new RealTimeInstance();
            rtIns.observer = observer;
            this.mInsMap.put(key, rtIns);
        }
        if (rtIns.realTimeLocation != null) {
            rtIns.realTimeLocation.addListener(observer);
        }
    }

    public void removeListener(Conversation.ConversationType type, String targetId) {
        String key = type.getName() + targetId;
        RealTimeInstance rtIns = this.mInsMap.get(key);
        if (rtIns != null) {
            rtIns.observer = null;
            if (rtIns.realTimeLocation != null) {
                rtIns.realTimeLocation.deleteListener();
            }
        }
    }

    @Deprecated
    public void updateLocation(Conversation.ConversationType type, String targetId, double latitude, double longitude) {
        RealTimeInstance rtIns = this.mInsMap.get(type.getName() + targetId);
        if (rtIns == null || rtIns.realTimeLocation == null) {
            RLog.e((String)TAG, (String)"getRealTimeLocationCurrentState No instance!");
            return;
        }
        rtIns.realTimeLocation.updateLocation(latitude, longitude);
    }

    public void updateLocation(Conversation.ConversationType type, String targetId, double latitude, double longitude, RealTimeLocationType realTimeLocationType) {
        RealTimeInstance rtIns = this.mInsMap.get(type.getName() + targetId);
        if (rtIns == null || rtIns.realTimeLocation == null) {
            RLog.e((String)TAG, (String)"getRealTimeLocationCurrentState No instance!");
            return;
        }
        rtIns.realTimeLocation.updateLocationWithType(latitude, longitude, realTimeLocationType);
    }

    private static class RealTimeInstance {
        RealTimeLocation realTimeLocation;
        RealTimeLocationObserver observer;

        private RealTimeInstance() {
        }
    }

    private static class SingletonHolder {
        static RealTimeLocationManager sIns = new RealTimeLocationManager();

        private SingletonHolder() {
        }
    }
}

