/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.location.base;

import io.rong.common.rlog.RLog;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.RongCoreClient;
import io.rong.imlib.common.ExecutorFactory;
import io.rong.imlib.location.RealTimeLocationConstant;
import io.rong.imlib.location.RealTimeLocationManager;
import io.rong.imlib.location.RealTimeLocationObserver;
import io.rong.imlib.location.RealTimeLocationType;
import io.rong.imlib.location.base.RongLocationClient;
import io.rong.imlib.model.Conversation;
import java.util.Collections;
import java.util.List;

public class RongLocationClientImpl
extends RongLocationClient {
    private static final String TAG = "RongLocationClient";

    private RongLocationClientImpl() {
    }

    public static RongLocationClientImpl getInstanceForInterior() {
        return SingletonHolder.sInstance;
    }

    @Override
    public RealTimeLocationConstant.RealTimeLocationErrorCode getRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e((String)TAG, (String)"getRealTimeLocation Type or id is null!");
            return null;
        }
        int code = RealTimeLocationManager.getInstance().setupRealTimeLocation(conversationType, targetId);
        return RealTimeLocationConstant.RealTimeLocationErrorCode.valueOf(code);
    }

    @Override
    public RealTimeLocationConstant.RealTimeLocationErrorCode startRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e((String)TAG, (String)"startRealTimeLocation Type or id is null!");
            return null;
        }
        if (!IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED.equals((Object)RongCoreClient.getInstance().getCurrentConnectionStatus())) {
            RLog.e((String)TAG, (String)"startRealTimeLocation must be connected!");
            return RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_START_FAILURE;
        }
        int code = RealTimeLocationManager.getInstance().startRealTimeLocation(conversationType, targetId);
        return RealTimeLocationConstant.RealTimeLocationErrorCode.valueOf(code);
    }

    @Override
    public RealTimeLocationConstant.RealTimeLocationErrorCode joinRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e((String)TAG, (String)"joinRealTimeLocation Type or id is null!");
            return null;
        }
        int code = RealTimeLocationManager.getInstance().joinRealTimeLocation(conversationType, targetId);
        return RealTimeLocationConstant.RealTimeLocationErrorCode.valueOf(code);
    }

    @Override
    public RealTimeLocationConstant.RealTimeLocationStatus getRealTimeLocationCurrentState(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e((String)TAG, (String)"getRealTimeLocationCurrentState Type or id is null!");
            return RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_IDLE;
        }
        return RealTimeLocationManager.getInstance().getRealTimeLocationCurrentState(conversationType, targetId);
    }

    @Override
    public void updateRealTimeLocationStatus(Conversation.ConversationType conversationType, String targetId, double latitude, double longitude, RealTimeLocationType realTimeLocationType) {
        if (conversationType == null || targetId == null) {
            RLog.e((String)TAG, (String)"updateRealTimeLocationStatus Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().updateLocation(conversationType, targetId, latitude, longitude, realTimeLocationType);
    }

    @Override
    public void quitRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e((String)TAG, (String)"quitRealTimeLocation Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().quitRealTimeLocation(conversationType, targetId);
    }

    @Override
    public List<String> getRealTimeLocationParticipants(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null || RealTimeLocationManager.getInstance() == null) {
            RLog.e((String)TAG, (String)"getRealTimeLocationParticipants Type or id is null!");
            return Collections.emptyList();
        }
        return RealTimeLocationManager.getInstance().getRealTimeLocationParticipants(conversationType, targetId);
    }

    @Override
    public void addRealTimeLocationListener(Conversation.ConversationType conversationType, String targetId, final RongLocationClient.RealTimeLocationListener listener) {
        if (conversationType == null || targetId == null || RealTimeLocationManager.getInstance() == null) {
            RLog.e((String)TAG, (String)"addRealTimeLocationListener Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().addListener(conversationType, targetId, new RealTimeLocationObserver(){

            @Override
            public void onStatusChange(final RealTimeLocationConstant.RealTimeLocationStatus status) {
                ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onStatusChange(status);
                        }
                    }
                });
            }

            @Override
            public void onReceiveLocation(final double latitude, final double longitude, final String userId) {
                ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onReceiveLocation(latitude, longitude, userId);
                        }
                    }
                });
            }

            @Override
            public void onReceiveLocationWithType(final double latitude, final double longitude, final RealTimeLocationType type, final String userId) {
                ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onReceiveLocationWithType(latitude, longitude, type, userId);
                        }
                    }
                });
            }

            @Override
            public void onParticipantsJoin(final String userId) {
                ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onParticipantsJoin(userId);
                        }
                    }
                });
            }

            @Override
            public void onParticipantsQuit(final String userId) {
                ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onParticipantsQuit(userId);
                        }
                    }
                });
            }

            @Override
            public void onError(final RealTimeLocationConstant.RealTimeLocationErrorCode errorCode) {
                ExecutorFactory.getInstance().getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onError(errorCode);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void removeRealTimeLocationObserver(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e((String)TAG, (String)"removeRealTimeLocationObserver Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().removeListener(conversationType, targetId);
    }

    private static class SingletonHolder {
        static RongLocationClientImpl sInstance = new RongLocationClientImpl();

        private SingletonHolder() {
        }
    }
}

