/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.location.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import io.rong.common.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.location.message.LocationMessageHandler;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:LBSMsg", flag=3, messageHandler=LocationMessageHandler.class)
public class LocationMessage
extends MessageContent {
    private static final String TAG = LocationMessage.class.getSimpleName();
    private double mLat;
    private double mLng;
    private String mPoi;
    private String mBase64;
    private Uri mImgUri;
    public static final Parcelable.Creator<LocationMessage> CREATOR = new Parcelable.Creator<LocationMessage>(){

        public LocationMessage createFromParcel(Parcel source) {
            return new LocationMessage(source);
        }

        public LocationMessage[] newArray(int size) {
            return new LocationMessage[size];
        }
    };

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mBase64)) {
                jsonObj.put("content", (Object)this.mBase64);
            } else if (this.mImgUri != null) {
                jsonObj.put("content", (Object)this.mImgUri);
            }
            jsonObj.put("latitude", this.mLat);
            jsonObj.put("longitude", this.mLng);
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
            if (!TextUtils.isEmpty((CharSequence)this.mPoi)) {
                jsonObj.put("poi", (Object)this.mPoi);
            }
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
            jsonObj.put("isBurnAfterRead", this.isDestruct());
            jsonObj.put("burnDuration", this.getDestructTime());
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
        return jsonObj.toString().getBytes();
    }

    public LocationMessage(byte[] data) {
        String jsonStr = new String(data);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.setLat(jsonObj.getDouble("latitude"));
            this.setLng(jsonObj.getDouble("longitude"));
            if (jsonObj.has("content")) {
                this.setBase64(jsonObj.optString("content"));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.optString("extra"));
            }
            this.setPoi(jsonObj.optString("poi"));
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
            if (jsonObj.has("isBurnAfterRead")) {
                this.setDestruct(jsonObj.getBoolean("isBurnAfterRead"));
            }
            if (jsonObj.has("burnDuration")) {
                this.setDestructTime(jsonObj.getLong("burnDuration"));
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    public static LocationMessage obtain(double lat, double lng, String poi, Uri imgUri) {
        return new LocationMessage(lat, lng, poi, imgUri);
    }

    public LocationMessage(double lat, double lng, String poi, Uri imgUri) {
        this.mLat = lat;
        this.mLng = lng;
        this.mPoi = poi;
        this.mImgUri = imgUri;
    }

    public double getLat() {
        return this.mLat;
    }

    public void setLat(double lat) {
        this.mLat = lat;
    }

    public double getLng() {
        return this.mLng;
    }

    public void setLng(double lng) {
        this.mLng = lng;
    }

    public String getPoi() {
        return this.mPoi;
    }

    public void setPoi(String poi) {
        this.mPoi = poi;
    }

    public String getBase64() {
        return this.mBase64;
    }

    public void setBase64(String base64) {
        this.mBase64 = base64;
    }

    public Uri getImgUri() {
        return this.mImgUri;
    }

    public void setImgUri(Uri imgUri) {
        this.mImgUri = imgUri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.getExtra());
        ParcelUtils.writeToParcel((Parcel)dest, (Double)this.mLat);
        ParcelUtils.writeToParcel((Parcel)dest, (Double)this.mLng);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.mPoi);
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.mImgUri);
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.getUserInfo());
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)(this.isDestruct() ? 1 : 0));
        ParcelUtils.writeToParcel((Parcel)dest, (Long)this.getDestructTime());
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.getBase64());
    }

    public LocationMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel((Parcel)in));
        this.mLat = ParcelUtils.readDoubleFromParcel((Parcel)in);
        this.mLng = ParcelUtils.readDoubleFromParcel((Parcel)in);
        this.mPoi = ParcelUtils.readFromParcel((Parcel)in);
        this.mImgUri = (Uri)ParcelUtils.readFromParcel((Parcel)in, Uri.class);
        this.setUserInfo((UserInfo)ParcelUtils.readFromParcel((Parcel)in, UserInfo.class));
        this.setDestruct(ParcelUtils.readIntFromParcel((Parcel)in) == 1);
        this.setDestructTime(ParcelUtils.readLongFromParcel((Parcel)in));
        this.setBase64(ParcelUtils.readFromParcel((Parcel)in));
    }
}

