/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.location.message;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.location.message.LocationMessage;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.MessageHandler;
import io.rong.message.ReferenceMessage;
import io.rong.message.utils.BitmapUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class LocationMessageHandler
extends MessageHandler<LocationMessage> {
    private static final String TAG = "LocationMessageHandler";
    private static int THUMB_WIDTH = 408;
    private static int THUMB_HEIGHT = 240;
    private static int THUMB_COMPRESSED_QUALITY = 70;

    public LocationMessageHandler(Context context) {
        super(context);
    }

    public void decodeMessage(Message message, LocationMessage content) {
        String base64;
        Uri uri;
        File file;
        String name = message.getMessageId() + "";
        if (message.getMessageId() == 0) {
            name = message.getSentTime() + "";
        }
        if ((file = new File((uri = NativeClient.getInstance().obtainMediaFileSavedUri()).toString() + name)).exists()) {
            content.setImgUri(Uri.fromFile((File)file));
            return;
        }
        if (content != null && !TextUtils.isEmpty((CharSequence)(base64 = content.getBase64()))) {
            if (base64.startsWith("http")) {
                content.setImgUri(Uri.parse((String)base64));
                content.setBase64(null);
            } else {
                try {
                    byte[] audio = Base64.decode((String)content.getBase64(), (int)2);
                    file = FileUtils.byte2File((byte[])audio, (String)uri.toString(), (String)(name + ""));
                    if (content.getImgUri() == null) {
                        if (file != null && file.exists()) {
                            content.setImgUri(Uri.fromFile((File)file));
                        } else {
                            RLog.e((String)TAG, (String)"getImgUri is null");
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    RLog.e((String)TAG, (String)"Not Base64 Content!");
                    RLog.e((String)TAG, (String)"IllegalArgumentException", (Throwable)e);
                }
                message.setContent((MessageContent)content);
                content.setBase64(null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeMessage(Message message) {
        File file;
        String thumbnailPath;
        LocationMessage content;
        if (message.getContent() instanceof ReferenceMessage) {
            MessageContent refContent = ((ReferenceMessage)message.getContent()).getReferenceContent();
            if (!(refContent instanceof LocationMessage)) return;
            content = (LocationMessage)refContent;
        } else {
            if (!(message.getContent() instanceof LocationMessage)) return;
            content = (LocationMessage)message.getContent();
        }
        if (content.getImgUri() == null) {
            RLog.w((String)TAG, (String)"No thumbnail uri.");
            if (this.mHandleMessageListener == null) return;
            this.mHandleMessageListener.onHandleResult(message, 0);
            return;
        }
        Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
        String scheme = content.getImgUri().getScheme();
        if (!TextUtils.isEmpty((CharSequence)scheme) && scheme.equalsIgnoreCase("file")) {
            thumbnailPath = content.getImgUri().getPath();
        } else {
            file = this.loadLocationThumbnail(content, message.getSentTime() + "");
            String string = thumbnailPath = file != null ? file.getPath() : null;
        }
        if (thumbnailPath == null) {
            RLog.e((String)TAG, (String)"load thumbnailPath null!");
            if (this.mHandleMessageListener == null) return;
            this.mHandleMessageListener.onHandleResult(message, -1);
            return;
        }
        Resources resources = this.getContext().getResources();
        try {
            THUMB_COMPRESSED_QUALITY = resources.getInteger(resources.getIdentifier("rc_location_thumb_quality", "integer", this.getContext().getPackageName()));
            THUMB_WIDTH = resources.getInteger(resources.getIdentifier("rc_location_thumb_width", "integer", this.getContext().getPackageName()));
            THUMB_HEIGHT = resources.getInteger(resources.getIdentifier("rc_location_thumb_height", "integer", this.getContext().getPackageName()));
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        THUMB_WIDTH = (int)((float)THUMB_WIDTH / 2.0f * resources.getDisplayMetrics().density + 0.5f);
        THUMB_HEIGHT = (int)((float)THUMB_HEIGHT / 2.0f * resources.getDisplayMetrics().density + 0.5f);
        try {
            Bitmap bitmap = BitmapUtil.interceptBitmap((String)thumbnailPath, (int)THUMB_WIDTH, (int)THUMB_HEIGHT);
            if (bitmap != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, THUMB_COMPRESSED_QUALITY, (OutputStream)outputStream);
                byte[] data = outputStream.toByteArray();
                outputStream.close();
                String base64 = Base64.encodeToString((byte[])data, (int)2);
                content.setBase64(base64);
                file = FileUtils.byte2File((byte[])data, (String)uri.toString(), (String)(message.getMessageId() + ""));
                if (file != null && file.exists()) {
                    content.setImgUri(Uri.fromFile((File)file));
                }
                if (!bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                if (this.mHandleMessageListener == null) return;
                this.mHandleMessageListener.onHandleResult(message, 0);
                return;
            } else {
                RLog.e((String)TAG, (String)"get null bitmap!");
                if (this.mHandleMessageListener == null) return;
                this.mHandleMessageListener.onHandleResult(message, -1);
            }
            return;
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"Not Base64 Content!");
            RLog.e((String)TAG, (String)"Exception ", (Throwable)e);
            if (this.mHandleMessageListener == null) return;
            this.mHandleMessageListener.onHandleResult(message, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File loadLocationThumbnail(LocationMessage content, String name) {
        File file = null;
        HttpURLConnection conn = null;
        int responseCode = 0;
        InputStream is = null;
        FileOutputStream os = null;
        if (this.getContext() == null) {
            return null;
        }
        try {
            Uri uri = content.getImgUri();
            URL url = new URL(uri.toString());
            conn = NetUtils.createURLConnection((String)url.toString());
            conn.setRequestMethod("GET");
            conn.setReadTimeout(3000);
            conn.connect();
            responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                int len;
                boolean successMkdir;
                String path = FileUtils.getInternalCachePath((Context)this.getContext(), (String)"location");
                file = new File(path);
                if (!file.exists() && !(successMkdir = file.mkdirs())) {
                    RLog.e((String)TAG, (String)"Created folders unSuccessfully");
                }
                file = new File(path, name);
                is = conn.getInputStream();
                os = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"Exception ", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    RLog.d((String)TAG, (String)"is close error");
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    RLog.d((String)TAG, (String)"os close error");
                }
            }
            RLog.d((String)TAG, (String)("loadLocationThumbnail result : " + responseCode));
        }
        return file;
    }
}

