/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.location.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:RLStart", flag=3)
public class RealTimeLocationStartMessage
extends MessageContent {
    private static final String TAG = "RealTimeLocationStartMessage";
    private String content = "";
    private String extra = "";
    public static final Parcelable.Creator<RealTimeLocationStartMessage> CREATOR = new Parcelable.Creator<RealTimeLocationStartMessage>(){

        public RealTimeLocationStartMessage createFromParcel(Parcel source) {
            return new RealTimeLocationStartMessage(source);
        }

        public RealTimeLocationStartMessage[] newArray(int size) {
            return new RealTimeLocationStartMessage[size];
        }
    };

    public RealTimeLocationStartMessage(String content) {
        this.content = content;
    }

    public RealTimeLocationStartMessage(byte[] data) {
        String jsonStr = new String(data, StandardCharsets.UTF_8);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("content")) {
                this.content = jsonObj.optString("content");
            }
            if (jsonObj.has("extra")) {
                this.extra = jsonObj.getString("extra");
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public static RealTimeLocationStartMessage obtain(String content) {
        return new RealTimeLocationStartMessage(content);
    }

    public String getContent() {
        return this.content;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    private RealTimeLocationStartMessage(Parcel in) {
        this.content = in.readString();
        this.extra = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.content);
        dest.writeString(this.extra);
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("content", (Object)this.content);
            if (this.extra != null) {
                jsonObj.put("extra", (Object)this.extra);
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)"encode JSONException", (Throwable)e);
        }
        return jsonObj.toString().getBytes(StandardCharsets.UTF_8);
    }
}

