/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.publicservice.base;

import android.content.Context;
import android.os.IBinder;
import io.rong.imlib.IMLibExtensionModuleIPC;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.NativeObject;
import io.rong.imlib.publicservice.base.PublicServiceNativeClient;
import java.util.Collections;
import java.util.Map;

class PublicServiceExtensionIPCModule
implements IMLibExtensionModuleIPC {
    private static final String TAG = "PublicServiceExtensionModuleIPCManager";

    public static PublicServiceExtensionIPCModule getInstance() {
        return SingletonHolder.sInstance;
    }

    private PublicServiceExtensionIPCModule() {
    }

    public void onIPCProcessInit(Context context, NativeObject nativeObject) {
    }

    public Map onMethodCall(String className, String methodKey, Map param, NativeObject nativeObject) {
        if (methodKey.equals("searchPublicService")) {
            String keyWords = (String)param.get("keyWords");
            int businessType = (Integer)param.get("businessType");
            int searchType = (Integer)param.get("searchType");
            IResultCallback callback = IResultCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
            PublicServiceNativeClient.getInstance().searchPublicService(keyWords, businessType, searchType, callback, nativeObject);
        } else if (methodKey.equals("subscribePublicService")) {
            String targetId = (String)param.get("targetId");
            int categoryId = (Integer)param.get("categoryId");
            boolean subscribe = (Boolean)param.get("subscribe");
            IOperationCallback callback = IOperationCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
            PublicServiceNativeClient.getInstance().subscribePublicService(targetId, categoryId, subscribe, callback, nativeObject);
        } else if (methodKey.equals("getPublicServiceProfile")) {
            String targetId = (String)param.get("targetId");
            int conversationType = (Integer)param.get("conversationType");
            IResultCallback callback = IResultCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
            PublicServiceNativeClient.getInstance().getPublicServiceProfile(targetId, conversationType, callback, nativeObject);
        } else if (methodKey.equals("getPublicServiceList")) {
            IResultCallback callback = IResultCallback.Stub.asInterface((IBinder)((IBinder)param.get("callback")));
            PublicServiceNativeClient.getInstance().getPublicServiceList(callback, nativeObject);
        }
        return Collections.emptyMap();
    }

    private static class SingletonHolder {
        static PublicServiceExtensionIPCModule sInstance = new PublicServiceExtensionIPCModule();

        private SingletonHolder() {
        }
    }
}

