/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.publicservice.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Parcelable;
import android.os.RemoteException;
import io.rong.common.fwlog.FwLogUtil;
import io.rong.common.rlog.RLog;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.RemoteModelWrap;
import io.rong.imlib.publicservice.model.PublicServiceProfile;
import io.rong.imlib.publicservice.model.PublicServiceProfileList;
import java.util.ArrayList;

class PublicServiceNativeClient {
    private static final String TAG = "PublicServiceNativeClient";

    PublicServiceNativeClient() {
    }

    public static PublicServiceNativeClient getInstance() {
        return NativeClientHolder.client;
    }

    public void searchPublicService(String keyWords, int businessType, int searchType, final IResultCallback callback, NativeObject nativeObject) {
        try {
            if (nativeObject == null) {
                throw new RuntimeException("NativeClient has not been initialized yet!");
            }
            if (keyWords == null) {
                throw new IllegalArgumentException("Keywords parameter is null\u3002");
            }
            nativeObject.SearchAccount(keyWords, businessType, searchType, new NativeObject.AccountInfoListener(){

                public void onReceived(NativeObject.AccountInfo[] info) {
                    ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                    for (NativeObject.AccountInfo accountInfo : info) {
                        PublicServiceProfile item = new PublicServiceProfile();
                        item.setTargetId(new String(accountInfo.getAccountId()));
                        item.setName(new String(accountInfo.getAccountName()));
                        item.setPublicServiceType(Conversation.ConversationType.setValue((int)accountInfo.getAccountType()));
                        item.setPortraitUri(Uri.parse((String)new String(accountInfo.getAccountUri())));
                        String ss = new String(accountInfo.getExtra());
                        RLog.i((String)PublicServiceNativeClient.TAG, (String)("getPublicAccountInfoList extra:" + ss));
                        item.setExtra(ss);
                        list.add(item);
                    }
                    PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                    if (callback != null) {
                        RemoteModelWrap result = new RemoteModelWrap((Parcelable)infoList);
                        try {
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }

                public void OnError(int status) {
                    if (callback != null) {
                        try {
                            callback.onFailure(status);
                        }
                        catch (RemoteException e) {
                            FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void subscribePublicService(String targetId, int categoryId, boolean subscribe, final IOperationCallback callback, NativeObject nativeObject) {
        try {
            if (nativeObject == null) {
                throw new RuntimeException("NativeClient has not been initialized yet!");
            }
            nativeObject.SubscribeAccount(targetId, categoryId, subscribe, new NativeObject.PublishAckListener(){

                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback == null) {
                        return;
                    }
                    try {
                        if (code == 0) {
                            callback.onComplete();
                        } else {
                            callback.onFailure(code);
                        }
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
            });
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    public void getPublicServiceProfile(String targetId, int categoryId, IResultCallback callback, NativeObject nativeObject) {
        block10: {
            try {
                if (nativeObject == null) {
                    throw new RuntimeException("RongCoreClient has not been initialized!");
                }
                if (targetId == null) {
                    throw new IllegalArgumentException("targetId Parameter exception\u3002");
                }
                if (callback == null) break block10;
                PublicServiceProfile serviceInfo = new PublicServiceProfile();
                NativeObject.UserInfo info = nativeObject.GetUserInfoExSync(targetId, categoryId);
                if (info != null) {
                    serviceInfo.setTargetId(targetId);
                    serviceInfo.setName(info.getUserName());
                    if (info.getUrl() != null) {
                        serviceInfo.setPortraitUri(Uri.parse((String)info.getUrl()));
                    }
                    serviceInfo.setPublicServiceType(Conversation.ConversationType.setValue((int)info.getCategoryId()));
                    serviceInfo.setExtra(info.getAccountExtra());
                    RemoteModelWrap mModelWrap = new RemoteModelWrap((Parcelable)serviceInfo);
                    try {
                        callback.onComplete(mModelWrap);
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                    break block10;
                }
                try {
                    callback.onFailure(IRongCoreEnum.CoreErrorCode.RC_PUBLIC_SERVICE_PROFILE_NOT_EXIST.getValue());
                }
                catch (RemoteException e) {
                    FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                }
                RLog.e((String)TAG, (String)"Public service info is null");
            }
            catch (RuntimeException e) {
                FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
            }
        }
    }

    public void getPublicServiceList(IResultCallback callback, NativeObject nativeObject) {
        try {
            if (nativeObject == null) {
                throw new RuntimeException("RongCoreClient has not been initialized!");
            }
            if (callback != null) {
                NativeObject.AccountInfo[] info = nativeObject.LoadAccountInfo();
                if (info != null && info.length > 0) {
                    ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                    for (NativeObject.AccountInfo accountInfo : info) {
                        PublicServiceProfile item = new PublicServiceProfile();
                        item.setTargetId(new String(accountInfo.getAccountId()));
                        item.setName(new String(accountInfo.getAccountName()));
                        item.setPublicServiceType(Conversation.ConversationType.setValue((int)accountInfo.getAccountType()));
                        item.setPortraitUri(Uri.parse((String)new String(accountInfo.getAccountUri())));
                        String ss = new String(accountInfo.getExtra());
                        item.setExtra(ss);
                        list.add(item);
                    }
                    PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                    RemoteModelWrap mModelWrap = new RemoteModelWrap((Parcelable)infoList);
                    try {
                        callback.onComplete(mModelWrap);
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                } else {
                    RLog.e((String)TAG, (String)"Public service list is empty");
                    ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                    PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                    RemoteModelWrap mModelWrap = new RemoteModelWrap((Parcelable)infoList);
                    try {
                        callback.onComplete(mModelWrap);
                    }
                    catch (RemoteException e) {
                        FwLogUtil.handleRemoteException((RemoteException)e, (Context)NativeClient.getApplicationContext());
                    }
                }
            }
        }
        catch (RuntimeException e) {
            FwLogUtil.handleRuntimeException((RuntimeException)e, (Context)NativeClient.getApplicationContext());
        }
    }

    private static class NativeClientHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final PublicServiceNativeClient client = new PublicServiceNativeClient();

        private NativeClientHolder() {
        }
    }
}

