/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.publicservice.base;

import android.os.RemoteException;
import android.text.TextUtils;
import io.rong.common.rlog.RLog;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.common.ExecutorFactory;
import io.rong.imlib.ipc.IpcCallbackProxy;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.RemoteModelWrap;
import io.rong.imlib.publicservice.base.PublicServiceHelper;
import io.rong.imlib.publicservice.model.PublicServiceProfile;
import io.rong.imlib.publicservice.model.PublicServiceProfileList;

public class RongPublicServiceClient {
    private static final String TAG = "RongPublicServiceClient";

    public static RongPublicServiceClient getInstance() {
        return SingletonHolder.sInstance;
    }

    private RongPublicServiceClient() {
    }

    public void searchPublicService(final IRongCoreEnum.SearchType searchType, final String keywords, IRongCoreCallback.ResultCallback<PublicServiceProfileList> callback) {
        if (searchType == null) {
            RLog.e((String)TAG, (String)"searchType  is null!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy(callback);
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        PublicServiceHelper.getInstance().searchPublicService(keywords, 0, searchType.getValue(), (IResultCallback)new IResultCallback.Stub(){

                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                if (ipcCallbackProxy.callback != null && model != null && model.getContent() != null && model.getContent() instanceof PublicServiceProfileList) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onCallback((Object)((PublicServiceProfileList)model.getContent()));
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e((String)RongPublicServiceClient.TAG, (String)"searchPublicService", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void searchPublicServiceByType(Conversation.PublicServiceType publicServiceType, final IRongCoreEnum.SearchType searchType, final String keywords, IRongCoreCallback.ResultCallback<PublicServiceProfileList> callback) {
        if (publicServiceType == null || searchType == null) {
            RLog.e((String)TAG, (String)"searchType  is null!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final int[] businessType = new int[]{0};
        if (publicServiceType == Conversation.PublicServiceType.APP_PUBLIC_SERVICE) {
            businessType[0] = 2;
        } else if (publicServiceType == Conversation.PublicServiceType.PUBLIC_SERVICE) {
            businessType[0] = 1;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy(callback);
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        PublicServiceHelper.getInstance().searchPublicService(keywords, businessType[0], searchType.getValue(), (IResultCallback)new IResultCallback.Stub(){

                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                if (ipcCallbackProxy.callback != null && model != null && model.getContent() != null && model.getContent() instanceof PublicServiceProfileList) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onCallback((Object)((PublicServiceProfileList)model.getContent()));
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e((String)RongPublicServiceClient.TAG, (String)"searchPublicServiceByType", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void subscribePublicService(final Conversation.PublicServiceType publicServiceType, final String publicServiceId, IRongCoreCallback.OperationCallback callback) {
        if (publicServiceType == null || TextUtils.isEmpty((CharSequence)publicServiceId)) {
            RLog.e((String)TAG, (String)"Parameter  is error!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        PublicServiceHelper.getInstance().subscribePublicService(publicServiceId, publicServiceType.getValue(), true, (IOperationCallback)new IRongCoreCallback.DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e((String)RongPublicServiceClient.TAG, (String)"subscribePublicService", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void unsubscribePublicService(final Conversation.PublicServiceType publicServiceType, final String publicServiceId, IRongCoreCallback.OperationCallback callback) {
        if (publicServiceType == null || TextUtils.isEmpty((CharSequence)publicServiceId)) {
            RLog.e((String)TAG, (String)"Parameter  is error!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy((Object)callback);
        ExecutorFactory.getInstance().getWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        PublicServiceHelper.getInstance().subscribePublicService(publicServiceId, publicServiceType.getValue(), false, (IOperationCallback)new IRongCoreCallback.DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e((String)RongPublicServiceClient.TAG, (String)"unsubscribePublicService", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.OperationCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void getPublicServiceProfile(final Conversation.PublicServiceType publicServiceType, final String publicServiceId, IRongCoreCallback.ResultCallback<PublicServiceProfile> callback) {
        if (publicServiceType == null || TextUtils.isEmpty((CharSequence)publicServiceId)) {
            RLog.e((String)TAG, (String)"Parameter  is error!");
            if (callback != null) {
                callback.onError(IRongCoreEnum.CoreErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy(callback);
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        PublicServiceHelper.getInstance().getPublicServiceProfile(publicServiceId, publicServiceType.getValue(), (IResultCallback)new IResultCallback.Stub(){

                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    PublicServiceProfile publicServiceProfile = null;
                                    if (model != null) {
                                        publicServiceProfile = (PublicServiceProfile)model.getContent();
                                    }
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onCallback((Object)publicServiceProfile);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e((String)RongPublicServiceClient.TAG, (String)"getPublicServiceProfile", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void getPublicServiceList(IRongCoreCallback.ResultCallback<PublicServiceProfileList> callback) {
        final IpcCallbackProxy ipcCallbackProxy = new IpcCallbackProxy(callback);
        ExecutorFactory.getInstance().getSearchExecutor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        PublicServiceHelper.getInstance().getPublicServiceList((IResultCallback)new IResultCallback.Stub(){

                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    PublicServiceProfileList publicServiceInfoList = (PublicServiceProfileList)model.getContent();
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onCallback((Object)publicServiceInfoList);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e((String)RongPublicServiceClient.TAG, (String)"getPublicServiceList", (Throwable)e);
                        if (ipcCallbackProxy.callback == null) break block2;
                        ((IRongCoreCallback.ResultCallback)ipcCallbackProxy.callback).onFail(IRongCoreEnum.CoreErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    private static class SingletonHolder {
        static RongPublicServiceClient sInstance = new RongPublicServiceClient();

        private SingletonHolder() {
        }
    }
}

