/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.publicservice.model;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import io.rong.common.ParcelUtils;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.publicservice.model.PublicServiceMenu;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicServiceProfile
implements Parcelable {
    private String name;
    private Uri portraitUri;
    private String publicServiceId;
    private Conversation.ConversationType publicServiceType;
    private boolean isFollowed;
    private String introduction;
    private boolean isGlobal;
    private PublicServiceMenu menu;
    public static final Parcelable.Creator<PublicServiceProfile> CREATOR = new Parcelable.Creator<PublicServiceProfile>(){

        public PublicServiceProfile createFromParcel(Parcel source) {
            return new PublicServiceProfile(source);
        }

        public PublicServiceProfile[] newArray(int size) {
            return new PublicServiceProfile[size];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.name);
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.portraitUri);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.publicServiceId);
        if (this.publicServiceType != null) {
            ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.publicServiceType.getValue());
        } else {
            ParcelUtils.writeToParcel((Parcel)dest, (Integer)0);
        }
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.introduction);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)(this.isFollowed ? 1 : 0));
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)(this.isGlobal ? 1 : 0));
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.menu);
    }

    public PublicServiceProfile() {
    }

    public void setExtra(String extra) {
        try {
            if (!TextUtils.isEmpty((CharSequence)extra)) {
                JSONObject jsonObj = new JSONObject(extra);
                if (jsonObj.has("introduction")) {
                    this.setIntroduction(jsonObj.optString("introduction"));
                }
                if (jsonObj.has("follow")) {
                    this.setIsFollow(jsonObj.optBoolean("follow"));
                }
                if (jsonObj.has("isGlobal")) {
                    this.setIsGlobal(jsonObj.optBoolean("isGlobal"));
                }
                if (jsonObj.has("menu") && jsonObj.getJSONArray("menu") != null) {
                    try {
                        this.menu = new PublicServiceMenu(jsonObj.getJSONArray("menu"));
                    }
                    catch (Exception e) {
                        Log.e((String)"DecodePSMenu", (String)e.getMessage());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    public PublicServiceProfile(Parcel source) {
        this.name = ParcelUtils.readFromParcel((Parcel)source);
        this.portraitUri = (Uri)ParcelUtils.readFromParcel((Parcel)source, Uri.class);
        this.publicServiceId = ParcelUtils.readFromParcel((Parcel)source);
        this.publicServiceType = Conversation.ConversationType.setValue((int)ParcelUtils.readIntFromParcel((Parcel)source));
        this.introduction = ParcelUtils.readFromParcel((Parcel)source);
        this.isFollowed = ParcelUtils.readIntFromParcel((Parcel)source) == 1;
        this.isGlobal = ParcelUtils.readIntFromParcel((Parcel)source) == 1;
        this.menu = (PublicServiceMenu)ParcelUtils.readFromParcel((Parcel)source, PublicServiceMenu.class);
    }

    public void setIsGlobal(boolean global) {
        this.isGlobal = global;
    }

    public Uri getPortraitUri() {
        return this.portraitUri;
    }

    public void setPortraitUri(Uri portraitUri) {
        this.portraitUri = portraitUri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTargetId() {
        return this.publicServiceId;
    }

    public void setTargetId(String targetId) {
        this.publicServiceId = targetId;
    }

    public void setIntroduction(String intro) {
        this.introduction = intro;
    }

    public boolean isFollow() {
        return this.isFollowed;
    }

    public void setIsFollow(boolean isFollow) {
        this.isFollowed = isFollow;
    }

    public Conversation.ConversationType getConversationType() {
        return this.publicServiceType;
    }

    public void setPublicServiceType(Conversation.ConversationType publicServiceType) {
        this.publicServiceType = publicServiceType;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public PublicServiceMenu getMenu() {
        return this.menu;
    }

    public void setMenu(PublicServiceMenu menu) {
        this.menu = menu;
    }
}

