/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.core.network;

import java.util.HashMap;
import java.util.Map;

public class Request {
    final String url;
    final String method;
    final Map<String, String> headers;
    final String body;
    final boolean gzip;
    final boolean useCache;
    final boolean callBackOnMainThread;

    Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers;
        this.body = builder.body;
        this.gzip = builder.gzip;
        this.useCache = builder.useCache;
        this.callBackOnMainThread = builder.callBackOnMainThread;
    }

    public static class Builder {
        String url;
        String method = "GET";
        Map<String, String> headers;
        String body;
        boolean gzip;
        boolean useCache;
        boolean callBackOnMainThread;

        public Builder() {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            v1.headers = hashMap2;
            v1.gzip = false;
            v1.useCache = true;
            v1.callBackOnMainThread = false;
        }

        public Builder url(String string) {
            if (string != null) {
                this.url = string;
                return this;
            }
            throw new NullPointerException("http url == null");
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder post(String string) {
            return this.method("POST", string);
        }

        public Builder method(String string, String string2) {
            if (string2 == null && "POST".equals(string)) {
                throw new IllegalArgumentException("method " + string + " must have a request body.");
            }
            this.method = string;
            this.body = string2;
            return this;
        }

        public Builder addHeader(String string, String string2) {
            Builder builder = this;
            builder.headers.put(string, string2);
            return builder;
        }

        public Builder removeHeader(String string) {
            Builder builder = this;
            builder.headers.remove(string);
            return builder;
        }

        public Builder headers(Map<String, String> map) {
            Builder builder = this;
            builder.headers.putAll(map);
            return builder;
        }

        public Builder gzip() {
            this.gzip = true;
            return this;
        }

        public Builder useCache(boolean bl) {
            this.useCache = bl;
            return this;
        }

        public Builder mainThread() {
            this.callBackOnMainThread = true;
            return this;
        }

        public Request build() {
            if (this.url != null) {
                return new Request(this);
            }
            throw new IllegalStateException("url == null");
        }
    }
}

