/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.core.network;

import cn.thinkingdata.core.network.Call;
import cn.thinkingdata.core.network.RealCall;
import cn.thinkingdata.core.network.Request;
import cn.thinkingdata.core.network.TEHttpTaskManager;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLSocketFactory;

public class TEHttpClient
implements Call.Factory {
    final ExecutorService dispatcher;
    final int connectTimeout;
    final int readTimeout;
    final SSLSocketFactory sslSocketFactory;

    public TEHttpClient() {
        Builder builder;
        TEHttpClient tEHttpClient = builder2;
        Builder builder2 = builder;
        builder = new Builder();
        tEHttpClient(builder2);
    }

    TEHttpClient(Builder builder) {
        this.dispatcher = builder.dispatcher;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.sslSocketFactory = builder.sslSocketFactory;
    }

    @Override
    public Call newCall(Request request) {
        return RealCall.newRealCall(this, request);
    }

    public static final class Builder {
        int connectTimeout = 15000;
        int readTimeout = 20000;
        SSLSocketFactory sslSocketFactory;
        ExecutorService dispatcher = TEHttpTaskManager.getExecutor();

        public Builder connectTimeout(int n) {
            this.connectTimeout = n;
            return this;
        }

        public Builder readTimeout(int n) {
            this.readTimeout = n;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.sslSocketFactory = sSLSocketFactory;
            return this;
        }

        public Builder dispatcher(ExecutorService executorService) {
            if (executorService != null) {
                this.dispatcher = executorService;
                return this;
            }
            throw new IllegalArgumentException("dispatcher == null");
        }

        public TEHttpClient build() {
            return new TEHttpClient(this);
        }
    }
}

