/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.core.utils;

import android.text.TextUtils;

public class EmulatorDetector {
    public static boolean isEmulator() {
        return EmulatorDetector.mayOnEmulatorViaQEMU() || EmulatorDetector.isEmulatorFromAbi();
    }

    private static boolean mayOnEmulatorViaQEMU() {
        return "1".equals(EmulatorDetector.getProp("ro.kernel.qemu"));
    }

    private static boolean isEmulatorFromAbi() {
        String string = EmulatorDetector.getProp("ro.product.cpu.abi");
        if (string == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)string) && string.contains("x86");
    }

    private static String getProp(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName("android.os.SystemProperties");
        }
        catch (Exception exception) {
            return null;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        return (String)clazz.getMethod("get", classArray).invoke(clazz, string);
    }
}

