/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.core.utils.pool;

import cn.thinkingdata.core.utils.TDLog;
import cn.thinkingdata.core.utils.pool.DefaultThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultPoolExecutor
extends ThreadPoolExecutor {
    private static final String TAG = "ThinkingAnalytics.DefaultPoolExecutor";
    private static final int CPU_COUNT;
    private static final int INIT_THREAD_COUNT;
    private static final int MAX_THREAD_COUNT;
    private static final long SURPLUS_THREAD_LIFE = 30L;
    private static volatile DefaultPoolExecutor instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultPoolExecutor getInstance() {
        if (instance != null) return instance;
        Class<DefaultPoolExecutor> clazz = DefaultPoolExecutor.class;
        synchronized (DefaultPoolExecutor.class) {
            DefaultPoolExecutor defaultPoolExecutor;
            if (instance != null) return instance;
            DefaultPoolExecutor defaultPoolExecutor2 = defaultPoolExecutor;
            DefaultPoolExecutor defaultPoolExecutor3 = defaultPoolExecutor;
            int n = INIT_THREAD_COUNT;
            int n2 = MAX_THREAD_COUNT;
            defaultPoolExecutor2(n, n2, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(64), new DefaultThreadFactory());
            instance = defaultPoolExecutor3;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DefaultPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        RejectedExecutionHandler rejectedExecutionHandler;
        DefaultPoolExecutor defaultPoolExecutor = rejectedExecutionHandler2;
        RejectedExecutionHandler rejectedExecutionHandler2 = rejectedExecutionHandler;
        rejectedExecutionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                TDLog.w(DefaultPoolExecutor.TAG, "Task rejected, too many task!");
            }
        };
        super(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler2);
    }

    static {
        int n;
        CPU_COUNT = n = Runtime.getRuntime().availableProcessors();
        MAX_THREAD_COUNT = INIT_THREAD_COUNT = n + 1;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        block5: {
            Object object;
            block6: {
                super.afterExecute(runnable, throwable);
                if (throwable != null || !(runnable instanceof Future)) break block6;
                try {
                    ((Future)((Object)runnable)).get();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    throwable = executionException.getCause();
                    object = throwable;
                    break block5;
                }
                catch (CancellationException cancellationException) {
                    break block5;
                }
            }
            object = throwable;
        }
        if (object != null) {
            TDLog.w(TAG, "Running task appeared exception! Thread [" + Thread.currentThread().getName() + "], because [" + ((Throwable)object).getMessage() + "]\n");
        }
    }
}

