/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.network;

import com.airbnb.lottie.utils.Logger;

public enum FileExtension {
    JSON(".json"),
    ZIP(".zip");

    public final String extension;

    private FileExtension(String extension) {
        this.extension = extension;
    }

    public String tempExtension() {
        return ".temp" + this.extension;
    }

    public String toString() {
        return this.extension;
    }

    public static FileExtension forFile(String filename) {
        for (FileExtension e : FileExtension.values()) {
            if (!filename.endsWith(e.extension)) continue;
            return e;
        }
        Logger.warning("Unable to find correct extension for " + filename);
        return JSON;
    }
}

