/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.content.CompoundTrimPathContent;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.KeyPathElementContent;
import com.airbnb.lottie.animation.content.PathContent;
import com.airbnb.lottie.animation.content.RoundedCornersContent;
import com.airbnb.lottie.animation.content.TrimPathContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.content.RectangleShape;
import com.airbnb.lottie.model.content.ShapeTrimPath;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.List;

public class RectangleContent
implements BaseKeyframeAnimation.AnimationListener,
KeyPathElementContent,
PathContent {
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final String name;
    private final boolean hidden;
    private final LottieDrawable lottieDrawable;
    private final BaseKeyframeAnimation<?, PointF> positionAnimation;
    private final BaseKeyframeAnimation<?, PointF> sizeAnimation;
    private final BaseKeyframeAnimation<?, Float> cornerRadiusAnimation;
    private final CompoundTrimPathContent trimPaths = new CompoundTrimPathContent();
    @Nullable
    private BaseKeyframeAnimation<Float, Float> roundedCornersAnimation = null;
    private boolean isPathValid;

    public RectangleContent(LottieDrawable lottieDrawable, BaseLayer layer, RectangleShape rectShape) {
        this.name = rectShape.getName();
        this.hidden = rectShape.isHidden();
        this.lottieDrawable = lottieDrawable;
        this.positionAnimation = rectShape.getPosition().createAnimation();
        this.sizeAnimation = rectShape.getSize().createAnimation();
        this.cornerRadiusAnimation = rectShape.getCornerRadius().createAnimation();
        layer.addAnimation(this.positionAnimation);
        layer.addAnimation(this.sizeAnimation);
        layer.addAnimation(this.cornerRadiusAnimation);
        this.positionAnimation.addUpdateListener(this);
        this.sizeAnimation.addUpdateListener(this);
        this.cornerRadiusAnimation.addUpdateListener(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsBefore.size(); ++i) {
            Content content = contentsBefore.get(i);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath.Type.SIMULTANEOUSLY) {
                TrimPathContent trimPath = (TrimPathContent)content;
                this.trimPaths.addTrimPath(trimPath);
                trimPath.addListener(this);
                continue;
            }
            if (!(content instanceof RoundedCornersContent)) continue;
            this.roundedCornersAnimation = ((RoundedCornersContent)content).getRoundedCorners();
        }
    }

    @Override
    public Path getPath() {
        float maxRadius;
        float radius;
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        if (this.hidden) {
            this.isPathValid = true;
            return this.path;
        }
        PointF size = this.sizeAnimation.getValue();
        float halfWidth = size.x / 2.0f;
        float halfHeight = size.y / 2.0f;
        float f = radius = this.cornerRadiusAnimation == null ? 0.0f : ((FloatKeyframeAnimation)this.cornerRadiusAnimation).getFloatValue();
        if (radius == 0.0f && this.roundedCornersAnimation != null) {
            radius = Math.min(this.roundedCornersAnimation.getValue().floatValue(), Math.min(halfWidth, halfHeight));
        }
        if (radius > (maxRadius = Math.min(halfWidth, halfHeight))) {
            radius = maxRadius;
        }
        PointF position = this.positionAnimation.getValue();
        this.path.moveTo(position.x + halfWidth, position.y - halfHeight + radius);
        this.path.lineTo(position.x + halfWidth, position.y + halfHeight - radius);
        if (radius > 0.0f) {
            this.rect.set(position.x + halfWidth - 2.0f * radius, position.y + halfHeight - 2.0f * radius, position.x + halfWidth, position.y + halfHeight);
            this.path.arcTo(this.rect, 0.0f, 90.0f, false);
        }
        this.path.lineTo(position.x - halfWidth + radius, position.y + halfHeight);
        if (radius > 0.0f) {
            this.rect.set(position.x - halfWidth, position.y + halfHeight - 2.0f * radius, position.x - halfWidth + 2.0f * radius, position.y + halfHeight);
            this.path.arcTo(this.rect, 90.0f, 90.0f, false);
        }
        this.path.lineTo(position.x - halfWidth, position.y - halfHeight + radius);
        if (radius > 0.0f) {
            this.rect.set(position.x - halfWidth, position.y - halfHeight, position.x - halfWidth + 2.0f * radius, position.y - halfHeight + 2.0f * radius);
            this.path.arcTo(this.rect, 180.0f, 90.0f, false);
        }
        this.path.lineTo(position.x + halfWidth - radius, position.y - halfHeight);
        if (radius > 0.0f) {
            this.rect.set(position.x + halfWidth - 2.0f * radius, position.y - halfHeight, position.x + halfWidth, position.y - halfHeight + 2.0f * radius);
            this.path.arcTo(this.rect, 270.0f, 90.0f, false);
        }
        this.path.close();
        this.trimPaths.apply(this.path);
        this.isPathValid = true;
        return this.path;
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        MiscUtils.resolveKeyPath(keyPath, depth, accumulator, currentPartialKeyPath, this);
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        if (property == LottieProperty.RECTANGLE_SIZE) {
            this.sizeAnimation.setValueCallback(callback);
        } else if (property == LottieProperty.POSITION) {
            this.positionAnimation.setValueCallback(callback);
        } else if (property == LottieProperty.CORNER_RADIUS) {
            this.cornerRadiusAnimation.setValueCallback(callback);
        }
    }
}

