/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import com.airbnb.lottie.animation.keyframe.KeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.PathKeyframe;
import com.airbnb.lottie.value.Keyframe;
import java.util.List;

public class PathKeyframeAnimation
extends KeyframeAnimation<PointF> {
    private final PointF point = new PointF();
    private final float[] pos = new float[2];
    private final float[] tangent = new float[2];
    private final PathMeasure pathMeasure = new PathMeasure();
    private PathKeyframe pathMeasureKeyframe;

    public PathKeyframeAnimation(List<? extends Keyframe<PointF>> keyframes) {
        super(keyframes);
    }

    @Override
    public PointF getValue(Keyframe<PointF> keyframe, float keyframeProgress) {
        PointF value;
        PathKeyframe pathKeyframe = (PathKeyframe)keyframe;
        Path path = pathKeyframe.getPath();
        if (this.valueCallback != null && keyframe.endFrame != null && (value = this.valueCallback.getValueInternal(pathKeyframe.startFrame, pathKeyframe.endFrame.floatValue(), (PointF)pathKeyframe.startValue, (PointF)pathKeyframe.endValue, this.getLinearCurrentKeyframeProgress(), keyframeProgress, this.getProgress())) != null) {
            return value;
        }
        if (path == null) {
            return (PointF)keyframe.startValue;
        }
        if (this.pathMeasureKeyframe != pathKeyframe) {
            this.pathMeasure.setPath(path, false);
            this.pathMeasureKeyframe = pathKeyframe;
        }
        float length = this.pathMeasure.getLength();
        float distance = keyframeProgress * length;
        this.pathMeasure.getPosTan(distance, this.pos, this.tangent);
        this.point.set(this.pos[0], this.pos[1]);
        if (distance < 0.0f) {
            this.point.offset(this.tangent[0] * distance, this.tangent[1] * distance);
        } else if (distance > length) {
            this.point.offset(this.tangent[0] * (distance - length), this.tangent[1] * (distance - length));
        }
        return this.point;
    }
}

