/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.value;

import android.graphics.PointF;
import android.view.animation.Interpolator;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;

public class Keyframe<T> {
    private static final float UNSET_FLOAT = -3987645.8f;
    private static final int UNSET_INT = 784923401;
    @Nullable
    private final LottieComposition composition;
    @Nullable
    public final T startValue;
    @Nullable
    public T endValue;
    @Nullable
    public final Interpolator interpolator;
    @Nullable
    public final Interpolator xInterpolator;
    @Nullable
    public final Interpolator yInterpolator;
    public final float startFrame;
    @Nullable
    public Float endFrame;
    private float startValueFloat = -3987645.8f;
    private float endValueFloat = -3987645.8f;
    private int startValueInt = 784923401;
    private int endValueInt = 784923401;
    private float startProgress = Float.MIN_VALUE;
    private float endProgress = Float.MIN_VALUE;
    public PointF pathCp1 = null;
    public PointF pathCp2 = null;

    public Keyframe(LottieComposition composition, @Nullable T startValue, @Nullable T endValue, @Nullable Interpolator interpolator, float startFrame, @Nullable Float endFrame) {
        this.composition = composition;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interpolator = interpolator;
        this.xInterpolator = null;
        this.yInterpolator = null;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    public Keyframe(LottieComposition composition, @Nullable T startValue, @Nullable T endValue, @Nullable Interpolator xInterpolator, @Nullable Interpolator yInterpolator, float startFrame, @Nullable Float endFrame) {
        this.composition = composition;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interpolator = null;
        this.xInterpolator = xInterpolator;
        this.yInterpolator = yInterpolator;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    protected Keyframe(LottieComposition composition, @Nullable T startValue, @Nullable T endValue, @Nullable Interpolator interpolator, @Nullable Interpolator xInterpolator, @Nullable Interpolator yInterpolator, float startFrame, @Nullable Float endFrame) {
        this.composition = composition;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interpolator = interpolator;
        this.xInterpolator = xInterpolator;
        this.yInterpolator = yInterpolator;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    public Keyframe(T value) {
        this.composition = null;
        this.startValue = value;
        this.endValue = value;
        this.interpolator = null;
        this.xInterpolator = null;
        this.yInterpolator = null;
        this.startFrame = Float.MIN_VALUE;
        this.endFrame = Float.valueOf(Float.MAX_VALUE);
    }

    private Keyframe(T startValue, T endValue) {
        this.composition = null;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interpolator = null;
        this.xInterpolator = null;
        this.yInterpolator = null;
        this.startFrame = Float.MIN_VALUE;
        this.endFrame = Float.valueOf(Float.MAX_VALUE);
    }

    public Keyframe<T> copyWith(T startValue, T endValue) {
        return new Keyframe<T>(startValue, endValue);
    }

    public float getStartProgress() {
        if (this.composition == null) {
            return 0.0f;
        }
        if (this.startProgress == Float.MIN_VALUE) {
            this.startProgress = (this.startFrame - this.composition.getStartFrame()) / this.composition.getDurationFrames();
        }
        return this.startProgress;
    }

    public float getEndProgress() {
        if (this.composition == null) {
            return 1.0f;
        }
        if (this.endProgress == Float.MIN_VALUE) {
            if (this.endFrame == null) {
                this.endProgress = 1.0f;
            } else {
                float startProgress = this.getStartProgress();
                float durationFrames = this.endFrame.floatValue() - this.startFrame;
                float durationProgress = durationFrames / this.composition.getDurationFrames();
                this.endProgress = startProgress + durationProgress;
            }
        }
        return this.endProgress;
    }

    public boolean isStatic() {
        return this.interpolator == null && this.xInterpolator == null && this.yInterpolator == null;
    }

    public boolean containsProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        return progress >= this.getStartProgress() && progress < this.getEndProgress();
    }

    public float getStartValueFloat() {
        if (this.startValueFloat == -3987645.8f) {
            this.startValueFloat = ((Float)this.startValue).floatValue();
        }
        return this.startValueFloat;
    }

    public float getEndValueFloat() {
        if (this.endValueFloat == -3987645.8f) {
            this.endValueFloat = ((Float)this.endValue).floatValue();
        }
        return this.endValueFloat;
    }

    public int getStartValueInt() {
        if (this.startValueInt == 784923401) {
            this.startValueInt = (Integer)this.startValue;
        }
        return this.startValueInt;
    }

    public int getEndValueInt() {
        if (this.endValueInt == 784923401) {
            this.endValueInt = (Integer)this.endValue;
        }
        return this.endValueInt;
    }

    public String toString() {
        return "Keyframe{startValue=" + this.startValue + ", endValue=" + this.endValue + ", startFrame=" + this.startFrame + ", endFrame=" + this.endFrame + ", interpolator=" + this.interpolator + '}';
    }
}

