/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import java.lang.reflect.Array;

public class SortedList<T> {
    public static final int INVALID_POSITION = -1;
    private static final int MIN_CAPACITY = 10;
    private static final int CAPACITY_GROWTH = 10;
    private static final int INSERTION = 1;
    private static final int DELETION = 2;
    private static final int LOOKUP = 4;
    T[] mData;
    private Callback mCallback;
    private BatchedCallback mBatchedCallback;
    private int mSize;
    private final Class<T> mTClass;

    public SortedList(Class<T> klass, Callback<T> callback) {
        this(klass, callback, 10);
    }

    public SortedList(Class<T> klass, Callback<T> callback, int initialCapacity) {
        this.mTClass = klass;
        this.mData = (Object[])Array.newInstance(klass, initialCapacity);
        this.mCallback = callback;
        this.mSize = 0;
    }

    public int size() {
        return this.mSize;
    }

    public int add(T item) {
        return this.add(item, true);
    }

    public void beginBatchedUpdates() {
        if (this.mCallback instanceof BatchedCallback) {
            return;
        }
        if (this.mBatchedCallback == null) {
            this.mBatchedCallback = new BatchedCallback(this.mCallback);
        }
        this.mCallback = this.mBatchedCallback;
    }

    public void endBatchedUpdates() {
        if (this.mCallback instanceof BatchedCallback) {
            ((BatchedCallback)this.mCallback).dispatchLastEvent();
        }
        if (this.mCallback == this.mBatchedCallback) {
            this.mCallback = this.mBatchedCallback.mWrappedCallback;
        }
    }

    private int add(T item, boolean notify) {
        T existing;
        int index = this.findIndexOf(item, 1);
        if (index == -1) {
            index = 0;
        } else if (index < this.mSize && this.mCallback.areItemsTheSame(existing = this.mData[index], item)) {
            if (this.mCallback.areContentsTheSame(existing, item)) {
                this.mData[index] = item;
                return index;
            }
            this.mData[index] = item;
            this.mCallback.onChanged(index, 1);
            return index;
        }
        this.addToData(index, item);
        if (notify) {
            this.mCallback.onInserted(index, 1);
        }
        return index;
    }

    public boolean remove(T item) {
        return this.remove(item, true);
    }

    public T removeItemAt(int index) {
        T item = this.get(index);
        this.removeItemAtIndex(index, true);
        return item;
    }

    private boolean remove(T item, boolean notify) {
        int index = this.findIndexOf(item, 2);
        if (index == -1) {
            return false;
        }
        this.removeItemAtIndex(index, notify);
        return true;
    }

    private void removeItemAtIndex(int index, boolean notify) {
        System.arraycopy(this.mData, index + 1, this.mData, index, this.mSize - index - 1);
        --this.mSize;
        this.mData[this.mSize] = null;
        if (notify) {
            this.mCallback.onRemoved(index, 1);
        }
    }

    public void updateItemAt(int index, T item) {
        int cmp;
        boolean contentsChanged;
        T existing = this.get(index);
        boolean bl = contentsChanged = existing == item || !this.mCallback.areContentsTheSame(existing, item);
        if (existing != item && (cmp = this.mCallback.compare(existing, item)) == 0) {
            this.mData[index] = item;
            if (contentsChanged) {
                this.mCallback.onChanged(index, 1);
            }
            return;
        }
        if (contentsChanged) {
            this.mCallback.onChanged(index, 1);
        }
        this.removeItemAtIndex(index, false);
        int newIndex = this.add(item, false);
        if (index != newIndex) {
            this.mCallback.onMoved(index, newIndex);
        }
    }

    public void recalculatePositionOfItemAt(int index) {
        T item = this.get(index);
        this.removeItemAtIndex(index, false);
        int newIndex = this.add(item, false);
        if (index != newIndex) {
            this.mCallback.onMoved(index, newIndex);
        }
    }

    public T get(int index) throws IndexOutOfBoundsException {
        if (index >= this.mSize || index < 0) {
            throw new IndexOutOfBoundsException("Asked to get item at " + index + " but size is " + this.mSize);
        }
        return this.mData[index];
    }

    public int indexOf(T item) {
        return this.findIndexOf(item, 4);
    }

    private int findIndexOf(T item, int reason) {
        int left = 0;
        int right = this.mSize;
        while (left < right) {
            int middle = (left + right) / 2;
            T myItem = this.mData[middle];
            int cmp = this.mCallback.compare(myItem, item);
            if (cmp < 0) {
                left = middle + 1;
                continue;
            }
            if (cmp == 0) {
                if (this.mCallback.areItemsTheSame(myItem, item)) {
                    return middle;
                }
                int exact = this.linearEqualitySearch(item, middle, left, right);
                if (reason == 1) {
                    return exact == -1 ? middle : exact;
                }
                return exact;
            }
            right = middle;
        }
        return reason == 1 ? left : -1;
    }

    private int linearEqualitySearch(T item, int middle, int left, int right) {
        T nextItem;
        int cmp;
        int next;
        for (next = middle - 1; next >= left && (cmp = this.mCallback.compare(nextItem = this.mData[next], item)) == 0; --next) {
            if (!this.mCallback.areItemsTheSame(nextItem, item)) continue;
            return next;
        }
        for (next = middle + 1; next < right && (cmp = this.mCallback.compare(nextItem = this.mData[next], item)) == 0; ++next) {
            if (!this.mCallback.areItemsTheSame(nextItem, item)) continue;
            return next;
        }
        return -1;
    }

    private void addToData(int index, T item) {
        if (index > this.mSize) {
            throw new IndexOutOfBoundsException("cannot add item to " + index + " because size is " + this.mSize);
        }
        if (this.mSize == this.mData.length) {
            Object[] newData = (Object[])Array.newInstance(this.mTClass, this.mData.length + 10);
            System.arraycopy(this.mData, 0, newData, 0, index);
            newData[index] = item;
            System.arraycopy(this.mData, index, newData, index + 1, this.mSize - index);
            this.mData = newData;
        } else {
            System.arraycopy(this.mData, index, this.mData, index + 1, this.mSize - index);
            this.mData[index] = item;
        }
        ++this.mSize;
    }

    public static class BatchedCallback<T2>
    extends Callback<T2> {
        private final Callback<T2> mWrappedCallback;
        static final int TYPE_NONE = 0;
        static final int TYPE_ADD = 1;
        static final int TYPE_REMOVE = 2;
        static final int TYPE_CHANGE = 3;
        static final int TYPE_MOVE = 4;
        int mLastEventType = 0;
        int mLastEventPosition = -1;
        int mLastEventCount = -1;

        public BatchedCallback(Callback<T2> wrappedCallback) {
            this.mWrappedCallback = wrappedCallback;
        }

        @Override
        public int compare(T2 o1, T2 o2) {
            return this.mWrappedCallback.compare(o1, o2);
        }

        @Override
        public void onInserted(int position, int count) {
            if (this.mLastEventType == 1 && position >= this.mLastEventPosition && position <= this.mLastEventPosition + this.mLastEventCount) {
                this.mLastEventCount += count;
                this.mLastEventPosition = Math.min(position, this.mLastEventPosition);
                return;
            }
            this.dispatchLastEvent();
            this.mLastEventPosition = position;
            this.mLastEventCount = count;
            this.mLastEventType = 1;
        }

        @Override
        public void onRemoved(int position, int count) {
            if (this.mLastEventType == 2 && this.mLastEventPosition == position) {
                this.mLastEventCount += count;
                return;
            }
            this.dispatchLastEvent();
            this.mLastEventPosition = position;
            this.mLastEventCount = count;
            this.mLastEventType = 2;
        }

        @Override
        public void onMoved(int fromPosition, int toPosition) {
            this.dispatchLastEvent();
            this.mWrappedCallback.onMoved(fromPosition, toPosition);
        }

        @Override
        public void onChanged(int position, int count) {
            if (this.mLastEventType == 3 && position <= this.mLastEventPosition + this.mLastEventCount && position + count >= this.mLastEventPosition) {
                int previousEnd = this.mLastEventPosition + this.mLastEventCount;
                this.mLastEventPosition = Math.min(position, this.mLastEventPosition);
                this.mLastEventCount = Math.max(previousEnd, position + count) - this.mLastEventPosition;
                return;
            }
            this.dispatchLastEvent();
            this.mLastEventPosition = position;
            this.mLastEventCount = count;
            this.mLastEventType = 3;
        }

        @Override
        public boolean areContentsTheSame(T2 oldItem, T2 newItem) {
            return this.mWrappedCallback.areContentsTheSame(oldItem, newItem);
        }

        @Override
        public boolean areItemsTheSame(T2 item1, T2 item2) {
            return this.mWrappedCallback.areItemsTheSame(item1, item2);
        }

        public void dispatchLastEvent() {
            if (this.mLastEventType == 0) {
                return;
            }
            switch (this.mLastEventType) {
                case 1: {
                    this.mWrappedCallback.onInserted(this.mLastEventPosition, this.mLastEventCount);
                    break;
                }
                case 2: {
                    this.mWrappedCallback.onRemoved(this.mLastEventPosition, this.mLastEventCount);
                    break;
                }
                case 3: {
                    this.mWrappedCallback.onChanged(this.mLastEventPosition, this.mLastEventCount);
                }
            }
            this.mLastEventType = 0;
        }
    }

    public static abstract class Callback<T2> {
        public abstract int compare(T2 var1, T2 var2);

        public abstract void onInserted(int var1, int var2);

        public abstract void onRemoved(int var1, int var2);

        public abstract void onMoved(int var1, int var2);

        public abstract void onChanged(int var1, int var2);

        public abstract boolean areContentsTheSame(T2 var1, T2 var2);

        public abstract boolean areItemsTheSame(T2 var1, T2 var2);
    }
}

